/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;

public class OSInAppMessageOutcome {
    private static final String OUTCOME_NAME = "name";
    private static final String OUTCOME_WEIGHT = "weight";
    private static final String OUTCOME_UNIQUE = "unique";
    private String name;
    private float weight;
    private boolean unique;

    OSInAppMessageOutcome(@NonNull JSONObject json) throws JSONException {
        this.name = json.getString(OUTCOME_NAME);
        this.weight = json.has(OUTCOME_WEIGHT) ? (float)json.getDouble(OUTCOME_WEIGHT) : 0.0f;
        this.unique = json.has(OUTCOME_UNIQUE) && json.getBoolean(OUTCOME_UNIQUE);
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put(OUTCOME_NAME, (Object)this.name);
            mainObj.put(OUTCOME_WEIGHT, (double)this.weight);
            mainObj.put(OUTCOME_UNIQUE, this.unique);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String toString() {
        return "OSInAppMessageOutcome{name='" + this.name + '\'' + ", weight=" + this.weight + ", unique=" + this.unique + '}';
    }
}

