/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSInAppMessageOutcome;
import com.onesignal.OSSessionManager;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalApiResponseHandler;
import com.onesignal.OutcomeEvent;
import com.onesignal.influence.model.OSInfluence;
import com.onesignal.influence.model.OSInfluenceType;
import com.onesignal.outcomes.OSOutcomeEventsFactory;
import com.onesignal.outcomes.model.OSOutcomeEventParams;
import com.onesignal.outcomes.model.OSOutcomeSource;
import com.onesignal.outcomes.model.OSOutcomeSourceBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class OSOutcomeEventsController {
    private static final String OS_SAVE_OUTCOMES = "OS_SAVE_OUTCOMES";
    private static final String OS_SEND_SAVED_OUTCOMES = "OS_SEND_SAVED_OUTCOMES";
    private static final String OS_SAVE_UNIQUE_OUTCOME_NOTIFICATIONS = "OS_SAVE_UNIQUE_OUTCOME_NOTIFICATIONS";
    private Set<String> unattributedUniqueOutcomeEventsSentOnSession;
    @NonNull
    private final OSOutcomeEventsFactory outcomeEventsFactory;
    @NonNull
    private final OSSessionManager osSessionManager;

    public OSOutcomeEventsController(@NonNull OSSessionManager osSessionManager, @NonNull OSOutcomeEventsFactory outcomeEventsFactory) {
        this.osSessionManager = osSessionManager;
        this.outcomeEventsFactory = outcomeEventsFactory;
        this.initUniqueOutcomeEventsSentSets();
    }

    private void initUniqueOutcomeEventsSentSets() {
        this.unattributedUniqueOutcomeEventsSentOnSession = OSUtils.newConcurrentSet();
        Set<String> tempUnattributedUniqueOutcomeEventsSentSet = this.outcomeEventsFactory.getRepository().getUnattributedUniqueOutcomeEventsSent();
        if (tempUnattributedUniqueOutcomeEventsSentSet != null) {
            this.unattributedUniqueOutcomeEventsSentOnSession = tempUnattributedUniqueOutcomeEventsSentSet;
        }
    }

    void cleanOutcomes() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignal cleanOutcomes for session");
        this.unattributedUniqueOutcomeEventsSentOnSession = OSUtils.newConcurrentSet();
        this.saveUnattributedUniqueOutcomeEvents();
    }

    void sendSavedOutcomes() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                List<OSOutcomeEventParams> outcomeEvents = OSOutcomeEventsController.this.outcomeEventsFactory.getRepository().getSavedOutcomeEvents();
                for (OSOutcomeEventParams event : outcomeEvents) {
                    OSOutcomeEventsController.this.sendSavedOutcomeEvent(event);
                }
            }
        }, OS_SEND_SAVED_OUTCOMES).start();
    }

    private void sendSavedOutcomeEvent(final @NonNull OSOutcomeEventParams event) {
        int deviceType = new OSUtils().getDeviceType();
        String appId = OneSignal.appId;
        OneSignalApiResponseHandler responseHandler = new OneSignalApiResponseHandler(){

            @Override
            public void onSuccess(String response) {
                OSOutcomeEventsController.this.outcomeEventsFactory.getRepository().removeEvent(event);
            }

            @Override
            public void onFailure(int statusCode, String response, Throwable throwable) {
            }
        };
        this.outcomeEventsFactory.getRepository().requestMeasureOutcomeEvent(appId, deviceType, event, responseHandler);
    }

    void sendClickActionOutcomes(List<OSInAppMessageOutcome> outcomes) {
        for (OSInAppMessageOutcome outcome : outcomes) {
            String name = outcome.getName();
            if (outcome.isUnique()) {
                this.sendUniqueOutcomeEvent(name, null);
                continue;
            }
            if (outcome.getWeight() > 0.0f) {
                this.sendOutcomeEventWithValue(name, outcome.getWeight(), null);
                continue;
            }
            this.sendOutcomeEvent(name, null);
        }
    }

    void sendUniqueOutcomeEvent(@NonNull String name, @Nullable OneSignal.OutcomeCallback callback) {
        List<OSInfluence> sessionResult = this.osSessionManager.getInfluences();
        this.sendUniqueOutcomeEvent(name, sessionResult, callback);
    }

    void sendOutcomeEvent(@NonNull String name, @Nullable OneSignal.OutcomeCallback callback) {
        List<OSInfluence> influences = this.osSessionManager.getInfluences();
        this.sendAndCreateOutcomeEvent(name, 0.0f, influences, callback);
    }

    void sendOutcomeEventWithValue(@NonNull String name, float weight, @Nullable OneSignal.OutcomeCallback callback) {
        List<OSInfluence> influences = this.osSessionManager.getInfluences();
        this.sendAndCreateOutcomeEvent(name, weight, influences, callback);
    }

    private void sendUniqueOutcomeEvent(@NonNull String name, @NonNull List<OSInfluence> sessionInfluences, @Nullable OneSignal.OutcomeCallback callback) {
        List<OSInfluence> influences = this.removeDisabledInfluences(sessionInfluences);
        if (influences.isEmpty()) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Unique Outcome disabled for current session");
            return;
        }
        boolean attributed = false;
        for (OSInfluence influence : influences) {
            if (!influence.getInfluenceType().isAttributed()) continue;
            attributed = true;
            break;
        }
        if (attributed) {
            List<OSInfluence> uniqueInfluences = this.getUniqueIds(name, influences);
            if (uniqueInfluences == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Measure endpoint will not send because unique outcome already sent for: \nSessionInfluences: " + influences.toString() + "\nOutcome name: " + name);
                if (callback != null) {
                    callback.onSuccess(null);
                }
                return;
            }
            this.sendAndCreateOutcomeEvent(name, 0.0f, uniqueInfluences, callback);
        } else {
            if (this.unattributedUniqueOutcomeEventsSentOnSession.contains(name)) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Measure endpoint will not send because unique outcome already sent for: \nSession: " + (Object)((Object)OSInfluenceType.UNATTRIBUTED) + "\nOutcome name: " + name);
                if (callback != null) {
                    callback.onSuccess(null);
                }
                return;
            }
            this.unattributedUniqueOutcomeEventsSentOnSession.add(name);
            this.sendAndCreateOutcomeEvent(name, 0.0f, influences, callback);
        }
    }

    private void sendAndCreateOutcomeEvent(final @NonNull String name, @NonNull float weight, @NonNull List<OSInfluence> influences, final @Nullable OneSignal.OutcomeCallback callback) {
        final long timestampSeconds = System.currentTimeMillis() / 1000L;
        int deviceType = new OSUtils().getDeviceType();
        String appId = OneSignal.appId;
        OSOutcomeSourceBody directSourceBody = null;
        OSOutcomeSourceBody indirectSourceBody = null;
        boolean unattributed = false;
        for (OSInfluence influence : influences) {
            switch (influence.getInfluenceType()) {
                case DIRECT: {
                    directSourceBody = this.setSourceChannelIds(influence, directSourceBody == null ? new OSOutcomeSourceBody() : directSourceBody);
                    break;
                }
                case INDIRECT: {
                    indirectSourceBody = this.setSourceChannelIds(influence, indirectSourceBody == null ? new OSOutcomeSourceBody() : indirectSourceBody);
                    break;
                }
                case UNATTRIBUTED: {
                    unattributed = true;
                    break;
                }
                case DISABLED: {
                    OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Outcomes disabled for channel: " + (Object)((Object)influence.getInfluenceChannel()));
                    if (callback != null) {
                        callback.onSuccess(null);
                    }
                    return;
                }
            }
        }
        if (directSourceBody == null && indirectSourceBody == null && !unattributed) {
            OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Outcomes disabled for all channels");
            if (callback != null) {
                callback.onSuccess(null);
            }
            return;
        }
        OSOutcomeSource source = new OSOutcomeSource(directSourceBody, indirectSourceBody);
        final OSOutcomeEventParams eventParams = new OSOutcomeEventParams(name, source, weight);
        OneSignalApiResponseHandler responseHandler = new OneSignalApiResponseHandler(){

            @Override
            public void onSuccess(String response) {
                OSOutcomeEventsController.this.saveUniqueOutcome(eventParams);
                if (callback != null) {
                    callback.onSuccess(OutcomeEvent.fromOutcomeEventParamsV2toOutcomeEventV1(eventParams));
                }
            }

            @Override
            public void onFailure(int statusCode, String response, Throwable throwable) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(10);
                        eventParams.setTimestamp(timestampSeconds);
                        OSOutcomeEventsController.this.outcomeEventsFactory.getRepository().saveOutcomeEvent(eventParams);
                    }
                }, OSOutcomeEventsController.OS_SAVE_OUTCOMES).start();
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "Sending outcome with name: " + name + " failed with status code: " + statusCode + " and response: " + response + "\nOutcome event was cached and will be reattempted on app cold start");
                if (callback != null) {
                    callback.onSuccess(null);
                }
            }
        };
        this.outcomeEventsFactory.getRepository().requestMeasureOutcomeEvent(appId, deviceType, eventParams, responseHandler);
    }

    private OSOutcomeSourceBody setSourceChannelIds(OSInfluence influence, OSOutcomeSourceBody sourceBody) {
        switch (influence.getInfluenceChannel()) {
            case IAM: {
                sourceBody.setInAppMessagesIds(influence.getIds());
                break;
            }
            case NOTIFICATION: {
                sourceBody.setNotificationIds(influence.getIds());
            }
        }
        return sourceBody;
    }

    private List<OSInfluence> removeDisabledInfluences(List<OSInfluence> influences) {
        ArrayList<OSInfluence> availableInfluences = new ArrayList<OSInfluence>(influences);
        for (OSInfluence influence : influences) {
            if (!influence.getInfluenceType().isDisabled()) continue;
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Outcomes disabled for channel: " + influence.getInfluenceChannel().toString());
            availableInfluences.remove(influence);
        }
        return availableInfluences;
    }

    private void saveUniqueOutcome(OSOutcomeEventParams eventParams) {
        if (eventParams.isUnattributed()) {
            this.saveUnattributedUniqueOutcomeEvents();
        } else {
            this.saveAttributedUniqueOutcomeNotifications(eventParams);
        }
    }

    private void saveAttributedUniqueOutcomeNotifications(final OSOutcomeEventParams eventParams) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OSOutcomeEventsController.this.outcomeEventsFactory.getRepository().saveUniqueOutcomeNotifications(eventParams);
            }
        }, OS_SAVE_UNIQUE_OUTCOME_NOTIFICATIONS).start();
    }

    private void saveUnattributedUniqueOutcomeEvents() {
        this.outcomeEventsFactory.getRepository().saveUnattributedUniqueOutcomeEventsSent(this.unattributedUniqueOutcomeEventsSentOnSession);
    }

    private List<OSInfluence> getUniqueIds(String name, List<OSInfluence> influences) {
        List<OSInfluence> uniqueInfluences = this.outcomeEventsFactory.getRepository().getNotCachedUniqueOutcome(name, influences);
        return uniqueInfluences.size() > 0 ? uniqueInfluences : null;
    }
}

