/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.onesignal.GenerateNotification;
import com.onesignal.NotificationGenerationJob;
import com.onesignal.NotificationRestorer;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationSummaryManager {
    NotificationSummaryManager() {
    }

    static void updatePossibleDependentSummaryOnDismiss(Context context, SQLiteDatabase writableDb, int androidNotificationId) {
        Cursor cursor = writableDb.query("notification", new String[]{"group_id"}, "android_notification_id = " + androidNotificationId, null, null, null, null);
        if (cursor.moveToFirst()) {
            String group = cursor.getString(cursor.getColumnIndex("group_id"));
            cursor.close();
            if (group != null) {
                NotificationSummaryManager.updateSummaryNotificationAfterChildRemoved(context, writableDb, group, true);
            }
        } else {
            cursor.close();
        }
    }

    static void updateSummaryNotificationAfterChildRemoved(Context context, SQLiteDatabase writableDb, String group, boolean dismissed) {
        Cursor cursor = writableDb.query("notification", new String[]{"android_notification_id", "created_time"}, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", new String[]{group}, null, null, "_id DESC");
        int notifsInGroup = cursor.getCount();
        if (notifsInGroup == 0) {
            cursor.close();
            cursor = writableDb.query("notification", new String[]{"android_notification_id"}, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 1", new String[]{group}, null, null, null);
            cursor.moveToFirst();
            int androidNotifId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
            cursor.close();
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(androidNotifId);
            ContentValues values = new ContentValues();
            values.put(dismissed ? "dismissed" : "opened", Integer.valueOf(1));
            writableDb.update("notification", values, "android_notification_id = " + androidNotifId, null);
            return;
        }
        if (notifsInGroup == 1) {
            cursor.close();
            NotificationSummaryManager.restoreSummary(context, group);
            return;
        }
        try {
            cursor.moveToFirst();
            Long datetime = cursor.getLong(cursor.getColumnIndex("created_time"));
            cursor.close();
            NotificationGenerationJob notifJob = new NotificationGenerationJob(context);
            notifJob.restoring = true;
            notifJob.shownTimeStamp = datetime;
            JSONObject payload = new JSONObject();
            payload.put("grp", (Object)group);
            notifJob.jsonPayload = payload;
            GenerateNotification.updateSummaryNotification(notifJob);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreSummary(Context context, String group) {
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        Cursor cursor = null;
        String[] whereArgs = new String[]{group};
        try {
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            cursor = readableDb.query("notification", NotificationRestorer.COLUMNS_FOR_RESTORE, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", whereArgs, null, null, null);
            NotificationRestorer.showNotifications(context, cursor);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error restoring notification records! ", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }
}

