/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.onesignal.GcmBroadcastReceiver;
import com.onesignal.JobIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationGenerationJob;
import com.onesignal.OSNotificationDisplayedResult;
import com.onesignal.OSNotificationReceivedResult;
import com.onesignal.OneSignal;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class NotificationExtenderService
extends JobIntentService {
    static final int EXTENDER_SERVICE_JOB_ID = 2071862121;
    private OSNotificationDisplayedResult osNotificationDisplayedResult;
    private JSONObject currentJsonPayload;
    private boolean currentlyRestoring;
    private Long restoreTimestamp;
    private OverrideSettings currentBaseOverrideSettings = null;

    protected final OSNotificationDisplayedResult displayNotification(OverrideSettings overrideSettings) {
        if (this.osNotificationDisplayedResult != null || overrideSettings == null) {
            return null;
        }
        overrideSettings.override(this.currentBaseOverrideSettings);
        this.osNotificationDisplayedResult = new OSNotificationDisplayedResult();
        NotificationGenerationJob notifJob = this.createNotifJobFromCurrent();
        notifJob.overrideSettings = overrideSettings;
        this.osNotificationDisplayedResult.androidNotificationId = NotificationBundleProcessor.ProcessJobForDisplay(notifJob);
        return this.osNotificationDisplayedResult;
    }

    protected abstract boolean onNotificationProcessing(OSNotificationReceivedResult var1);

    @Override
    protected final void onHandleWork(Intent intent) {
        if (intent == null) {
            return;
        }
        this.processIntent(intent);
        GcmBroadcastReceiver.completeWakefulIntent((Intent)intent);
    }

    private void processIntent(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "No extras sent to NotificationExtenderService in its Intent!\n" + intent);
            return;
        }
        String jsonStrPayload = bundle.getString("json_payload");
        if (jsonStrPayload == null) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "json_payload key is nonexistent from bundle passed to NotificationExtenderService: " + bundle);
            return;
        }
        try {
            this.currentJsonPayload = new JSONObject(jsonStrPayload);
            this.currentlyRestoring = bundle.getBoolean("restoring", false);
            if (bundle.containsKey("android_notif_id")) {
                this.currentBaseOverrideSettings = new OverrideSettings();
                this.currentBaseOverrideSettings.androidNotificationId = bundle.getInt("android_notif_id");
            }
            if (!this.currentlyRestoring && OneSignal.notValidOrDuplicated((Context)this, this.currentJsonPayload)) {
                return;
            }
            this.restoreTimestamp = bundle.getLong("timestamp");
            this.processJsonObject(this.currentJsonPayload, this.currentlyRestoring);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void processJsonObject(JSONObject currentJsonPayload, boolean restoring) {
        OSNotificationReceivedResult receivedResult = new OSNotificationReceivedResult();
        receivedResult.payload = NotificationBundleProcessor.OSNotificationPayloadFrom(currentJsonPayload);
        receivedResult.restoring = restoring;
        receivedResult.isAppInFocus = OneSignal.isAppActive();
        this.osNotificationDisplayedResult = null;
        boolean developerProcessed = false;
        try {
            developerProcessed = this.onNotificationProcessing(receivedResult);
        }
        catch (Throwable t) {
            if (this.osNotificationDisplayedResult == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "onNotificationProcessing throw an exception. Displaying normal OneSignal notification.", t);
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "onNotificationProcessing throw an exception. Extended notification displayed but custom processing did not finish.", t);
        }
        if (this.osNotificationDisplayedResult == null) {
            boolean display;
            boolean bl = display = !developerProcessed && NotificationBundleProcessor.shouldDisplay(currentJsonPayload.optString("alert"));
            if (!display) {
                if (!restoring) {
                    NotificationGenerationJob notifJob = new NotificationGenerationJob((Context)this);
                    notifJob.jsonPayload = currentJsonPayload;
                    notifJob.overrideSettings = new OverrideSettings();
                    notifJob.overrideSettings.androidNotificationId = -1;
                    NotificationBundleProcessor.saveNotification(notifJob, true);
                    OneSignal.handleNotificationReceived(NotificationBundleProcessor.newJsonArray(currentJsonPayload), false, false);
                } else if (this.currentBaseOverrideSettings != null) {
                    NotificationBundleProcessor.markRestoredNotificationAsDismissed(this.createNotifJobFromCurrent());
                }
            } else {
                NotificationBundleProcessor.ProcessJobForDisplay(this.createNotifJobFromCurrent());
            }
        }
    }

    static Intent getIntent(Context context) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent().setAction("com.onesignal.NotificationExtender").setPackage(context.getPackageName()), 128);
        if (resolveInfo.size() < 1) {
            return null;
        }
        intent.setComponent(new ComponentName(context, ((ResolveInfo)resolveInfo.get((int)0)).serviceInfo.name));
        return intent;
    }

    private NotificationGenerationJob createNotifJobFromCurrent() {
        NotificationGenerationJob notifJob = new NotificationGenerationJob((Context)this);
        notifJob.restoring = this.currentlyRestoring;
        notifJob.jsonPayload = this.currentJsonPayload;
        notifJob.shownTimeStamp = this.restoreTimestamp;
        notifJob.overrideSettings = this.currentBaseOverrideSettings;
        return notifJob;
    }

    public static class OverrideSettings {
        public NotificationCompat.Extender extender;
        public Integer androidNotificationId;

        void override(OverrideSettings overrideSettings) {
            if (overrideSettings == null) {
                return;
            }
            if (overrideSettings.androidNotificationId != null) {
                this.androidNotificationId = overrideSettings.androidNotificationId;
            }
        }
    }
}

