/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.onesignal.LocationGMS;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.SyncJobService;
import com.onesignal.SyncService;

class OneSignalSyncUtils {
    private static final int SYNC_TASK_JOB_ID = 2071862119;
    private static final int SYNC_SERVICE_REQUEST_CODE = 2071862119;

    OneSignalSyncUtils() {
    }

    @TargetApi(value=26)
    static void scheduleSyncTask(Context context, long atTime) {
        if (Build.VERSION.SDK_INT >= 26) {
            OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleJobSyncTask:atTime: " + atTime);
            JobInfo.Builder jobBuilder = new JobInfo.Builder(SYNC_TASK_JOB_ID, new ComponentName(context, SyncJobService.class));
            JobInfo job = jobBuilder.setMinimumLatency(atTime - System.currentTimeMillis()).setOverrideDeadline(atTime - System.currentTimeMillis()).build();
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            jobScheduler.schedule(job);
        } else {
            OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleServiceSyncTask:atTime: " + atTime);
            Intent intent = new Intent(context, SyncService.class);
            intent.putExtra("task", 1);
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)SYNC_SERVICE_REQUEST_CODE, (Intent)intent, (int)0x8000000);
            AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
            alarm.set(0, atTime, pendingIntent);
        }
    }

    static void scheduleSyncTask(Context context, int executeInSecs) {
        OneSignalSyncUtils.scheduleSyncTask(context, System.currentTimeMillis() + (long)(executeInSecs * 1000));
    }

    static void checkOnFocusSync() {
        long unsentTime = OneSignal.GetUnsentActiveTime();
        if (unsentTime < 60L) {
            return;
        }
        OneSignal.sendOnFocus(unsentTime, true);
    }

    static void doBackgroundSync(Context context, SyncRunnable runnable) {
        OneSignal.appContext = context;
        new Thread((Runnable)runnable, "OS_SYNCSRV_BG_SYNC").start();
    }

    static class LegacySyncRunnable
    extends SyncRunnable {
        LegacySyncRunnable(Service caller) {
            super(caller);
        }

        @Override
        void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "LegacySyncRunnable:Stopped");
            this.callerService.stopSelf();
        }
    }

    @RequiresApi(api=21)
    static class OreoSyncRunnable
    extends SyncRunnable {
        private JobService jobService;
        private JobParameters jobParameters;

        OreoSyncRunnable(Service caller, JobParameters jobParameters) {
            super(caller);
            this.jobService = (JobService)caller;
            this.jobParameters = jobParameters;
        }

        @Override
        void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OreoSyncRunnable:JobFinished");
            this.jobService.jobFinished(this.jobParameters, false);
        }
    }

    private static abstract class SyncRunnable
    implements Runnable {
        Service callerService;

        SyncRunnable(Service caller) {
            this.callerService = caller;
        }

        @Override
        public void run() {
            if (OneSignal.getUserId() == null) {
                this.stopSync();
                return;
            }
            OneSignal.appId = OneSignal.getSavedAppId();
            OneSignalStateSynchronizer.initUserState();
            LocationGMS.getLocation(OneSignal.appContext, false, new LocationGMS.LocationHandler(){

                @Override
                public void complete(LocationGMS.LocationPoint point) {
                    if (point != null) {
                        OneSignalStateSynchronizer.updateLocation(point);
                    }
                    OneSignalStateSynchronizer.syncUserState(true);
                    OneSignalSyncUtils.checkOnFocusSync();
                    SyncRunnable.this.stopSync();
                }
            });
        }

        abstract void stopSync();
    }
}

