/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JSONUtils {
    JSONUtils() {
    }

    static JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        if (cur == null) {
            return null;
        }
        if (changedTo == null) {
            return baseOutput;
        }
        Iterator keys = changedTo.keys();
        JSONObject output = baseOutput != null ? baseOutput : new JSONObject();
        while (keys.hasNext()) {
            try {
                String key = (String)keys.next();
                Object value = changedTo.get(key);
                if (cur.has(key)) {
                    Object curValue;
                    if (value instanceof JSONObject) {
                        JSONObject returnedJson;
                        String returnedJsonStr;
                        curValue = cur.getJSONObject(key);
                        JSONObject outValue = null;
                        if (baseOutput != null && baseOutput.has(key)) {
                            outValue = baseOutput.getJSONObject(key);
                        }
                        if ((returnedJsonStr = (returnedJson = JSONUtils.generateJsonDiff(curValue, (JSONObject)value, outValue, includeFields)).toString()).equals("{}")) continue;
                        output.put(key, (Object)new JSONObject(returnedJsonStr));
                        continue;
                    }
                    if (value instanceof JSONArray) {
                        JSONUtils.handleJsonArray(key, (JSONArray)value, cur.getJSONArray(key), output);
                        continue;
                    }
                    if (includeFields != null && includeFields.contains(key)) {
                        output.put(key, value);
                        continue;
                    }
                    curValue = cur.get(key);
                    if (value.equals(curValue)) continue;
                    if (curValue instanceof Integer && !"".equals(value)) {
                        if (((Number)curValue).doubleValue() == ((Number)value).doubleValue()) continue;
                        output.put(key, value);
                        continue;
                    }
                    output.put(key, value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    output.put(key, (Object)new JSONObject(value.toString()));
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONUtils.handleJsonArray(key, (JSONArray)value, null, output);
                    continue;
                }
                output.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    private static void handleJsonArray(String key, JSONArray newArray, JSONArray curArray, JSONObject output) throws JSONException {
        String arrayValue;
        int i;
        if (key.endsWith("_a") || key.endsWith("_d")) {
            output.put(key, (Object)newArray);
            return;
        }
        String arrayStr = JSONUtils.toStringNE(newArray);
        JSONArray newOutArray = new JSONArray();
        JSONArray remOutArray = new JSONArray();
        String curArrayStr = curArray == null ? null : JSONUtils.toStringNE(curArray);
        for (i = 0; i < newArray.length(); ++i) {
            arrayValue = (String)newArray.get(i);
            if (curArray != null && curArrayStr.contains(arrayValue)) continue;
            newOutArray.put((Object)arrayValue);
        }
        if (curArray != null) {
            for (i = 0; i < curArray.length(); ++i) {
                arrayValue = curArray.getString(i);
                if (arrayStr.contains(arrayValue)) continue;
                remOutArray.put((Object)arrayValue);
            }
        }
        if (!newOutArray.toString().equals("[]")) {
            output.put(key + "_a", (Object)newOutArray);
        }
        if (!remOutArray.toString().equals("[]")) {
            output.put(key + "_d", (Object)remOutArray);
        }
    }

    static String toStringNE(JSONArray jsonArray) {
        String strArray = "[";
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                strArray = strArray + "\"" + jsonArray.getString(i) + "\"";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return strArray + "]";
    }

    static JSONObject getJSONObjectWithoutBlankValues(JSONObject jsonObject, String getKey) {
        if (!jsonObject.has(getKey)) {
            return null;
        }
        JSONObject toReturn = new JSONObject();
        JSONObject keyValues = jsonObject.optJSONObject(getKey);
        Iterator keys = keyValues.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = keyValues.get(key);
                if ("".equals(value)) continue;
                toReturn.put(key, value);
            }
            catch (Throwable throwable) {}
        }
        return toReturn;
    }
}

