/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.BundleCompat;
import com.onesignal.GenerateNotification;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationController;
import com.onesignal.OSNotificationFormatHelper;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OSNotificationWorkManager;
import com.onesignal.OSReceiveReceiptController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationBundleProcessor {
    public static final String PUSH_ADDITIONAL_DATA_KEY = "a";
    public static final String PUSH_MINIFIED_BUTTONS_LIST = "o";
    public static final String PUSH_MINIFIED_BUTTON_ID = "i";
    public static final String PUSH_MINIFIED_BUTTON_TEXT = "n";
    public static final String PUSH_MINIFIED_BUTTON_ICON = "p";
    private static final String IAM_PREVIEW_KEY = "os_in_app_message_preview_id";
    static final String DEFAULT_ACTION = "__DEFAULT__";
    static final String OS_NOTIFICATION_PROCESSING_THREAD = "OS_NOTIFICATION_PROCESSING_THREAD";

    NotificationBundleProcessor() {
    }

    static void processFromFCMIntentService(Context context, BundleCompat bundle) {
        OneSignal.initWithContext(context);
        try {
            String jsonStrPayload = bundle.getString("json_payload");
            if (jsonStrPayload == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "json_payload key is nonexistent from mBundle passed to ProcessFromFCMIntentService: " + bundle);
                return;
            }
            JSONObject jsonPayload = new JSONObject(jsonStrPayload);
            boolean isRestoring = bundle.getBoolean("is_restoring", false);
            long shownTimeStamp = bundle.getLong("timestamp");
            boolean isIamPreview = NotificationBundleProcessor.inAppPreviewPushUUID(jsonPayload) != null;
            int androidNotificationId = 0;
            if (bundle.containsKey("android_notif_id")) {
                androidNotificationId = bundle.getInt("android_notif_id");
            }
            if (!isRestoring && !isIamPreview && OneSignal.notValidOrDuplicated(context, jsonPayload)) {
                return;
            }
            String osNotificationId = OSNotificationFormatHelper.getOSNotificationIdFromJson(jsonPayload);
            OSNotificationWorkManager.beginEnqueueingWork(context, osNotificationId, androidNotificationId, jsonStrPayload, isRestoring, shownTimeStamp, false);
            if (isRestoring) {
                OSUtils.sleep(100);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @WorkerThread
    static int processJobForDisplay(OSNotificationGenerationJob notificationJob, boolean fromBackgroundLogic) {
        OSNotificationController notificationController = new OSNotificationController(notificationJob, notificationJob.isRestoring(), true);
        return NotificationBundleProcessor.processJobForDisplay(notificationController, false, fromBackgroundLogic);
    }

    @WorkerThread
    static int processJobForDisplay(OSNotificationController notificationController, boolean fromBackgroundLogic) {
        return NotificationBundleProcessor.processJobForDisplay(notificationController, false, fromBackgroundLogic);
    }

    @WorkerThread
    static int processJobForDisplay(OSNotificationController notificationController, boolean opened, boolean fromBackgroundLogic) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Starting processJobForDisplay");
        OSNotificationGenerationJob notificationJob = notificationController.getNotificationJob();
        NotificationBundleProcessor.processCollapseKey(notificationJob);
        int androidNotificationId = notificationJob.getAndroidIdWithoutCreate();
        boolean doDisplay = NotificationBundleProcessor.shouldDisplayNotif(notificationJob);
        if (doDisplay) {
            androidNotificationId = notificationJob.getAndroidId();
            if (fromBackgroundLogic && OneSignal.shouldFireForegroundHandlers()) {
                notificationController.setFromBackgroundLogic(false);
                OneSignal.fireForegroundHandlers(notificationController);
                return androidNotificationId;
            }
            GenerateNotification.fromJsonPayload(notificationJob);
        }
        if (!notificationJob.isRestoring() && !notificationJob.isIamPreview()) {
            NotificationBundleProcessor.processNotification(notificationJob, opened);
            OneSignal.handleNotificationReceived(notificationJob);
        }
        return androidNotificationId;
    }

    private static boolean shouldDisplayNotif(OSNotificationGenerationJob notificationJob) {
        if (notificationJob.isIamPreview() && Build.VERSION.SDK_INT <= 18) {
            return false;
        }
        return notificationJob.hasExtender() || OSUtils.isStringEmpty(notificationJob.getJsonPayload().optString("alert"));
    }

    private static void saveAndProcessDupNotification(Context context, Bundle bundle) {
        JSONObject jsonPayload = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        OSNotification notification = new OSNotification(jsonPayload, -1);
        OSNotificationGenerationJob notificationJob = new OSNotificationGenerationJob(context, notification, jsonPayload);
        NotificationBundleProcessor.processNotification(notificationJob, true);
    }

    static void processNotification(OSNotificationGenerationJob notificationJob, boolean opened) {
        NotificationBundleProcessor.saveNotification(notificationJob, opened);
        if (!notificationJob.isNotificationToDisplay()) {
            return;
        }
        String notificationId = notificationJob.getApiNotificationId();
        OneSignal.getSessionManager().onNotificationReceived(notificationId);
        OSReceiveReceiptController.getInstance().sendReceiveReceipt(notificationId);
    }

    private static void saveNotification(OSNotificationGenerationJob notificationJob, boolean opened) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Saving Notification job: " + notificationJob.toString());
        Context context = notificationJob.getContext();
        JSONObject jsonPayload = notificationJob.getJsonPayload();
        try {
            JSONObject customJSON = NotificationBundleProcessor.getCustomJSONObject(notificationJob.getJsonPayload());
            OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notificationJob.getContext());
            if (notificationJob.isNotificationToDisplay()) {
                String whereStr = "android_notification_id = " + notificationJob.getAndroidIdWithoutCreate();
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                dbHelper.update("notification", values, whereStr, null);
                BadgeCountUpdater.update(dbHelper, context);
            }
            ContentValues values = new ContentValues();
            values.put("notification_id", customJSON.optString(PUSH_MINIFIED_BUTTON_ID));
            if (jsonPayload.has("grp")) {
                values.put("group_id", jsonPayload.optString("grp"));
            }
            if (jsonPayload.has("collapse_key") && !"do_not_collapse".equals(jsonPayload.optString("collapse_key"))) {
                values.put("collapse_id", jsonPayload.optString("collapse_key"));
            }
            values.put("opened", Integer.valueOf(opened ? 1 : 0));
            if (!opened) {
                values.put("android_notification_id", Integer.valueOf(notificationJob.getAndroidIdWithoutCreate()));
            }
            if (notificationJob.getTitle() != null) {
                values.put("title", notificationJob.getTitle().toString());
            }
            if (notificationJob.getBody() != null) {
                values.put("message", notificationJob.getBody().toString());
            }
            long sentTime = jsonPayload.optLong("google.sent_time", OneSignal.getTime().getCurrentThreadTimeMillis()) / 1000L;
            int ttl = jsonPayload.optInt("google.ttl", 259200);
            long expireTime = sentTime + (long)ttl;
            values.put("expire_time", Long.valueOf(expireTime));
            values.put("full_data", jsonPayload.toString());
            dbHelper.insertOrThrow("notification", null, values);
            if (!opened) {
                BadgeCountUpdater.update(dbHelper, context);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void markRestoredNotificationAsDismissed(OSNotificationGenerationJob notifiJob) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Marking restored notifications as dismissed: " + notifiJob.toString());
        if (notifiJob.getAndroidIdWithoutCreate() == -1) {
            return;
        }
        String whereStr = "android_notification_id = " + notifiJob.getAndroidIdWithoutCreate();
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notifiJob.getContext());
        ContentValues values = new ContentValues();
        values.put("dismissed", Integer.valueOf(1));
        dbHelper.update("notification", values, whereStr, null);
        BadgeCountUpdater.update(dbHelper, notifiJob.getContext());
    }

    @NonNull
    static JSONObject bundleAsJSONObject(Bundle bundle) {
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "bundleAsJSONObject error for key: " + key, e);
            }
        }
        return json;
    }

    private static void maximizeButtonsFromBundle(Bundle fcmBundle) {
        if (!fcmBundle.containsKey(PUSH_MINIFIED_BUTTONS_LIST)) {
            return;
        }
        try {
            JSONObject customJSON = new JSONObject(fcmBundle.getString("custom"));
            JSONObject additionalDataJSON = customJSON.has(PUSH_ADDITIONAL_DATA_KEY) ? customJSON.getJSONObject(PUSH_ADDITIONAL_DATA_KEY) : new JSONObject();
            JSONArray buttons = new JSONArray(fcmBundle.getString(PUSH_MINIFIED_BUTTONS_LIST));
            fcmBundle.remove(PUSH_MINIFIED_BUTTONS_LIST);
            for (int i = 0; i < buttons.length(); ++i) {
                String buttonId;
                JSONObject button = buttons.getJSONObject(i);
                String buttonText = button.getString(PUSH_MINIFIED_BUTTON_TEXT);
                button.remove(PUSH_MINIFIED_BUTTON_TEXT);
                if (button.has(PUSH_MINIFIED_BUTTON_ID)) {
                    buttonId = button.getString(PUSH_MINIFIED_BUTTON_ID);
                    button.remove(PUSH_MINIFIED_BUTTON_ID);
                } else {
                    buttonId = buttonText;
                }
                button.put("id", (Object)buttonId);
                button.put("text", (Object)buttonText);
                if (!button.has(PUSH_MINIFIED_BUTTON_ICON)) continue;
                button.put("icon", (Object)button.getString(PUSH_MINIFIED_BUTTON_ICON));
                button.remove(PUSH_MINIFIED_BUTTON_ICON);
            }
            additionalDataJSON.put("actionButtons", (Object)buttons);
            additionalDataJSON.put("actionId", (Object)DEFAULT_ACTION);
            if (!customJSON.has(PUSH_ADDITIONAL_DATA_KEY)) {
                customJSON.put(PUSH_ADDITIONAL_DATA_KEY, (Object)additionalDataJSON);
            }
            fcmBundle.putString("custom", customJSON.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void processCollapseKey(OSNotificationGenerationJob notificationJob) {
        if (notificationJob.isRestoring()) {
            return;
        }
        if (!notificationJob.getJsonPayload().has("collapse_key") || "do_not_collapse".equals(notificationJob.getJsonPayload().optString("collapse_key"))) {
            return;
        }
        String collapse_id = notificationJob.getJsonPayload().optString("collapse_key");
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notificationJob.getContext());
        Cursor cursor = dbHelper.query("notification", new String[]{"android_notification_id"}, "collapse_id = ? AND dismissed = 0 AND opened = 0 ", new String[]{collapse_id}, null, null, null);
        if (cursor.moveToFirst()) {
            int androidNotificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
            notificationJob.setAndroidIdWithoutOverriding(androidNotificationId);
        }
        cursor.close();
    }

    @NonNull
    static ProcessedBundleResult processBundleFromReceiver(Context context, Bundle bundle) {
        ProcessedBundleResult result = new ProcessedBundleResult();
        if (!OSNotificationFormatHelper.isOneSignalBundle(bundle)) {
            return result;
        }
        result.isOneSignalPayload = true;
        NotificationBundleProcessor.maximizeButtonsFromBundle(bundle);
        JSONObject pushPayloadJson = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        String previewUUID = NotificationBundleProcessor.inAppPreviewPushUUID(pushPayloadJson);
        if (previewUUID != null) {
            if (OneSignal.isAppActive()) {
                result.inAppPreviewShown = true;
                OneSignal.getInAppMessageController().displayPreviewMessage(previewUUID);
            }
            return result;
        }
        if (NotificationBundleProcessor.startNotificationProcessing(context, bundle, result)) {
            return result;
        }
        result.isDup = OneSignal.notValidOrDuplicated(context, pushPayloadJson);
        if (result.isDup) {
            return result;
        }
        JSONObject payload = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        final OSNotificationGenerationJob notificationJob = new OSNotificationGenerationJob(context, payload);
        String alert = bundle.getString("alert");
        boolean display = OSUtils.isStringEmpty(alert);
        if (!display) {
            NotificationBundleProcessor.saveAndProcessDupNotification(context, bundle);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.handleNotificationReceived(notificationJob);
                }
            }, OS_NOTIFICATION_PROCESSING_THREAD).start();
        }
        return result;
    }

    @Nullable
    static String inAppPreviewPushUUID(JSONObject payload) {
        JSONObject osCustom;
        try {
            osCustom = NotificationBundleProcessor.getCustomJSONObject(payload);
        }
        catch (JSONException e) {
            return null;
        }
        if (!osCustom.has(PUSH_ADDITIONAL_DATA_KEY)) {
            return null;
        }
        JSONObject additionalData = osCustom.optJSONObject(PUSH_ADDITIONAL_DATA_KEY);
        if (additionalData.has(IAM_PREVIEW_KEY)) {
            return additionalData.optString(IAM_PREVIEW_KEY);
        }
        return null;
    }

    private static boolean startNotificationProcessing(Context context, Bundle bundle, ProcessedBundleResult result) {
        if (bundle == null) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Notification bundle is null, not passing the notification to the work manager");
            return false;
        }
        JSONObject jsonPayload = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        boolean isRestoring = bundle.getBoolean("is_restoring", false);
        long timestamp = OneSignal.getTime().getCurrentTimeMillis() / 1000L;
        boolean isHighPriority = Integer.parseInt(bundle.getString("pri", "0")) > 9;
        int androidNotificationId = 0;
        if (bundle.containsKey("android_notif_id")) {
            androidNotificationId = bundle.getInt("android_notif_id");
        }
        if (!isRestoring && OneSignal.notValidOrDuplicated(context, jsonPayload)) {
            return false;
        }
        String osNotificationId = OSNotificationFormatHelper.getOSNotificationIdFromJson(jsonPayload);
        OSNotificationWorkManager.beginEnqueueingWork(context, osNotificationId, androidNotificationId, jsonPayload.toString(), isRestoring, timestamp, isHighPriority);
        result.isWorkManagerProcessing = true;
        return true;
    }

    @NonNull
    static JSONArray newJsonArray(JSONObject jsonObject) {
        return new JSONArray().put((Object)jsonObject);
    }

    static JSONObject getCustomJSONObject(JSONObject jsonObject) throws JSONException {
        return new JSONObject(jsonObject.optString("custom"));
    }

    static boolean hasRemoteResource(Bundle bundle) {
        return NotificationBundleProcessor.isBuildKeyRemote(bundle, "licon") || NotificationBundleProcessor.isBuildKeyRemote(bundle, "bicon") || bundle.getString("bg_img", null) != null;
    }

    private static boolean isBuildKeyRemote(Bundle bundle, String key) {
        String value = bundle.getString(key, "").trim();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    static class ProcessedBundleResult {
        boolean isOneSignalPayload;
        boolean isDup;
        boolean inAppPreviewShown;
        boolean isWorkManagerProcessing;

        ProcessedBundleResult() {
        }

        boolean processed() {
            return !this.isOneSignalPayload || this.isDup || this.inAppPreviewShown || this.isWorkManagerProcessing;
        }
    }
}

