/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import com.onesignal.OneSignal;

class OSTimeoutHandler
extends HandlerThread {
    private static final String TAG = OSTimeoutHandler.class.getCanonicalName();
    private static final Object SYNC_LOCK = new Object();
    private static OSTimeoutHandler timeoutHandler;
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OSTimeoutHandler getTimeoutHandler() {
        if (timeoutHandler == null) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                if (timeoutHandler == null) {
                    timeoutHandler = new OSTimeoutHandler();
                }
            }
        }
        return timeoutHandler;
    }

    private OSTimeoutHandler() {
        super(TAG);
        this.start();
        this.mHandler = new Handler(this.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimeout(long timeout, @NonNull Runnable runnable) {
        Object object = SYNC_LOCK;
        synchronized (object) {
            this.destroyTimeout(runnable);
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Running startTimeout with timeout: " + timeout + " and runnable: " + runnable.toString());
            this.mHandler.postDelayed(runnable, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyTimeout(Runnable runnable) {
        Object object = SYNC_LOCK;
        synchronized (object) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Running destroyTimeout with runnable: " + runnable.toString());
            this.mHandler.removeCallbacks(runnable);
        }
    }
}

