/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.OSLogWrapper;
import com.onesignal.OSLogger;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDb;
import com.onesignal.OneSignalPrefs;
import com.onesignal.outcomes.data.OSOutcomeTableProvider;
import java.util.ArrayList;

class OneSignalDbHelper
extends SQLiteOpenHelper
implements OneSignalDb {
    static final int DATABASE_VERSION = 8;
    private static final Object LOCK = new Object();
    private static final String DATABASE_NAME = "OneSignal.db";
    private static final String INTEGER_PRIMARY_KEY_TYPE = " INTEGER PRIMARY KEY";
    private static final String TEXT_TYPE = " TEXT";
    private static final String INT_TYPE = " INTEGER";
    private static final String FLOAT_TYPE = " FLOAT";
    private static final String TIMESTAMP_TYPE = " TIMESTAMP";
    private static final String COMMA_SEP = ",";
    private static final int DB_OPEN_RETRY_MAX = 5;
    private static final int DB_OPEN_RETRY_BACKOFF = 400;
    protected static final String SQL_CREATE_ENTRIES = "CREATE TABLE notification (_id INTEGER PRIMARY KEY,notification_id TEXT,android_notification_id INTEGER,group_id TEXT,collapse_id TEXT,is_summary INTEGER DEFAULT 0,opened INTEGER DEFAULT 0,dismissed INTEGER DEFAULT 0,title TEXT,message TEXT,full_data TEXT,created_time TIMESTAMP DEFAULT (strftime('%s', 'now')),expire_time TIMESTAMP);";
    private static final String SQL_CREATE_IN_APP_MESSAGE_ENTRIES = "CREATE TABLE in_app_message (_id INTEGER PRIMARY KEY,display_quantity INTEGER,last_display INTEGER,message_id TEXT,displayed_in_session INTEGER,click_ids TEXT);";
    protected static final String[] SQL_INDEX_ENTRIES = new String[]{"CREATE INDEX notification_notification_id_idx ON notification(notification_id); ", "CREATE INDEX notification_android_notification_id_idx ON notification(android_notification_id); ", "CREATE INDEX notification_group_id_idx ON notification(group_id); ", "CREATE INDEX notification_collapse_id_idx ON notification(collapse_id); ", "CREATE INDEX notification_created_time_idx ON notification(created_time); ", "CREATE INDEX notification_expire_time_idx ON notification(expire_time); "};
    private static OSLogger logger = new OSLogWrapper();
    private static OneSignalDbHelper sInstance;
    private static OSOutcomeTableProvider outcomeTableProvider;

    void setOutcomeTableProvider(OSOutcomeTableProvider outcomeTableProvider) {
        OneSignalDbHelper.outcomeTableProvider = outcomeTableProvider;
    }

    private static int getDbVersion() {
        return 8;
    }

    OneSignalDbHelper(Context context) {
        super(context, DATABASE_NAME, null, OneSignalDbHelper.getDbVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneSignalDbHelper getInstance(Context context) {
        if (sInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new OneSignalDbHelper(context.getApplicationContext());
                }
            }
        }
        return sInstance;
    }

    private SQLiteDatabase getSQLiteDatabase() {
        Object object = LOCK;
        synchronized (object) {
            return this.getWritableDatabase();
        }
    }

    private SQLiteDatabase getSQLiteDatabaseWithRetries() {
        Object object = LOCK;
        synchronized (object) {
            int count = 0;
            while (true) {
                try {
                    return this.getSQLiteDatabase();
                }
                catch (SQLiteCantOpenDatabaseException | SQLiteDatabaseLockedException e) {
                    if (++count >= 5) {
                        throw e;
                    }
                    SystemClock.sleep((long)(count * 400));
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor query(@NonNull String table, @Nullable String[] columns, @Nullable String selection, String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        Object object = LOCK;
        synchronized (object) {
            return this.getSQLiteDatabaseWithRetries().query(table, columns, selection, selectionArgs, groupBy, having, orderBy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor query(@NonNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        Object object = LOCK;
        synchronized (object) {
            return this.getSQLiteDatabaseWithRetries().query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) {
        Object object = LOCK;
        synchronized (object) {
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                writableDb.insert(table, nullColumnHack, values);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                logger.error("Error inserting on table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            catch (IllegalStateException e) {
                logger.error("Error under inserting transaction under table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            finally {
                if (writableDb != null) {
                    try {
                        writableDb.endTransaction();
                    }
                    catch (IllegalStateException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                    catch (SQLiteException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertOrThrow(@NonNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) throws SQLException {
        Object object = LOCK;
        synchronized (object) {
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                writableDb.insertOrThrow(table, nullColumnHack, values);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                logger.error("Error inserting or throw on table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            catch (IllegalStateException e) {
                logger.error("Error under inserting or throw transaction under table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            finally {
                if (writableDb != null) {
                    try {
                        writableDb.endTransaction();
                    }
                    catch (IllegalStateException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                    catch (SQLiteException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(@NonNull String table, @NonNull ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs) {
        int result = 0;
        if (values == null || values.toString().isEmpty()) {
            return result;
        }
        Object object = LOCK;
        synchronized (object) {
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                result = writableDb.update(table, values, whereClause, whereArgs);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                logger.error("Error updating on table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            catch (IllegalStateException e) {
                logger.error("Error under update transaction under table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            finally {
                if (writableDb != null) {
                    try {
                        writableDb.endTransaction();
                    }
                    catch (IllegalStateException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                    catch (SQLiteException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NonNull String table, @Nullable String whereClause, @Nullable String[] whereArgs) {
        Object object = LOCK;
        synchronized (object) {
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                writableDb.delete(table, whereClause, whereArgs);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                logger.error("Error deleting on table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            catch (IllegalStateException e) {
                logger.error("Error under delete transaction under table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            finally {
                if (writableDb != null) {
                    try {
                        writableDb.endTransaction();
                    }
                    catch (IllegalStateException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                    catch (SQLiteException e) {
                        logger.error("Error closing transaction! ", e);
                    }
                }
            }
        }
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(SQL_CREATE_ENTRIES);
        db.execSQL("CREATE TABLE outcome (_id INTEGER PRIMARY KEY,notification_influence_type TEXT,iam_influence_type TEXT,notification_ids TEXT,iam_ids TEXT,name TEXT,timestamp TIMESTAMP,weight FLOAT);");
        db.execSQL("CREATE TABLE cached_unique_outcome (_id INTEGER PRIMARY KEY,channel_influence_id TEXT,channel_type TEXT,name TEXT);");
        db.execSQL(SQL_CREATE_IN_APP_MESSAGE_ENTRIES);
        for (String ind : SQL_INDEX_ENTRIES) {
            db.execSQL(ind);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OneSignal Database onUpgrade from: " + oldVersion + " to: " + newVersion);
        try {
            this.internalOnUpgrade(db, oldVersion);
        }
        catch (SQLiteException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error in upgrade, migration may have already run! Skipping!", e);
        }
    }

    private synchronized void internalOnUpgrade(SQLiteDatabase db, int oldVersion) {
        if (oldVersion < 2) {
            OneSignalDbHelper.upgradeToV2(db);
        }
        if (oldVersion < 3) {
            OneSignalDbHelper.upgradeToV3(db);
        }
        if (oldVersion < 4) {
            OneSignalDbHelper.upgradeToV4(db);
        }
        if (oldVersion < 5) {
            OneSignalDbHelper.upgradeToV5(db);
        }
        if (oldVersion == 5) {
            OneSignalDbHelper.upgradeFromV5ToV6(db);
        }
        if (oldVersion < 7) {
            OneSignalDbHelper.upgradeToV7(db);
        }
        if (oldVersion < 8) {
            this.upgradeToV8(db);
        }
    }

    private static void upgradeToV2(SQLiteDatabase db) {
        OneSignalDbHelper.safeExecSQL(db, "ALTER TABLE notification ADD COLUMN collapse_id TEXT;");
        OneSignalDbHelper.safeExecSQL(db, "CREATE INDEX notification_group_id_idx ON notification(group_id); ");
    }

    private static void upgradeToV3(SQLiteDatabase db) {
        OneSignalDbHelper.safeExecSQL(db, "ALTER TABLE notification ADD COLUMN expire_time TIMESTAMP;");
        OneSignalDbHelper.safeExecSQL(db, "UPDATE notification SET expire_time = created_time + 259200;");
        OneSignalDbHelper.safeExecSQL(db, "CREATE INDEX notification_expire_time_idx ON notification(expire_time); ");
    }

    private static void upgradeToV4(SQLiteDatabase db) {
        OneSignalDbHelper.safeExecSQL(db, "CREATE TABLE outcome (_id INTEGER PRIMARY KEY,notification_ids TEXT,name TEXT,session TEXT,params TEXT,timestamp TIMESTAMP);");
    }

    private static void upgradeToV5(SQLiteDatabase db) {
        OneSignalDbHelper.safeExecSQL(db, "CREATE TABLE cached_unique_outcome_notification (_id INTEGER PRIMARY KEY,notification_id TEXT,name TEXT);");
        OneSignalDbHelper.upgradeFromV5ToV6(db);
    }

    private static void upgradeFromV5ToV6(SQLiteDatabase db) {
        outcomeTableProvider.upgradeOutcomeTableRevision1To2(db);
    }

    private static void upgradeToV7(SQLiteDatabase db) {
        OneSignalDbHelper.safeExecSQL(db, SQL_CREATE_IN_APP_MESSAGE_ENTRIES);
    }

    private synchronized void upgradeToV8(SQLiteDatabase db) {
        outcomeTableProvider.upgradeOutcomeTableRevision2To3(db);
        outcomeTableProvider.upgradeCacheOutcomeTableRevision1To2(db);
    }

    private static void safeExecSQL(SQLiteDatabase db, String sql) {
        try {
            db.execSQL(sql);
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "SDK version rolled back! Clearing OneSignal.db as it could be in an unexpected state.");
        try (Cursor cursor = db.rawQuery("SELECT name FROM sqlite_master WHERE type='table'", null);){
            ArrayList<String> tables = new ArrayList<String>(cursor.getCount());
            while (cursor.moveToNext()) {
                tables.add(cursor.getString(0));
            }
            for (String table : tables) {
                if (table.startsWith("sqlite_")) continue;
                db.execSQL("DROP TABLE IF EXISTS " + table);
            }
        }
        this.onCreate(db);
    }

    static StringBuilder recentUninteractedWithNotificationsWhere() {
        long currentTimeSec = OneSignal.getTime().getCurrentTimeMillis() / 1000L;
        long createdAtCutoff = currentTimeSec - 604800L;
        StringBuilder where = new StringBuilder("created_time > " + createdAtCutoff + " AND " + "dismissed" + " = 0 AND " + "opened" + " = 0 AND " + "is_summary" + " = 0");
        boolean useTtl = OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_RESTORE_TTL_FILTER", true);
        if (useTtl) {
            String expireTimeWhere = " AND expire_time > " + currentTimeSec;
            where.append(expireTimeWhere);
        }
        return where;
    }

    static {
        outcomeTableProvider = new OSOutcomeTableProvider();
    }
}

