/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.Nullable;
import com.onesignal.LocationController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.UserStateEmailSynchronizer;
import com.onesignal.UserStatePushSynchronizer;
import com.onesignal.UserStateSynchronizer;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class OneSignalStateSynchronizer {
    private static HashMap<UserStateSynchronizerType, UserStateSynchronizer> userStateSynchronizers = new HashMap();

    OneSignalStateSynchronizer() {
    }

    static UserStatePushSynchronizer getPushStateSynchronizer() {
        if (!userStateSynchronizers.containsKey((Object)UserStateSynchronizerType.PUSH) || userStateSynchronizers.get((Object)UserStateSynchronizerType.PUSH) == null) {
            userStateSynchronizers.put(UserStateSynchronizerType.PUSH, new UserStatePushSynchronizer());
        }
        return (UserStatePushSynchronizer)userStateSynchronizers.get((Object)UserStateSynchronizerType.PUSH);
    }

    static UserStateEmailSynchronizer getEmailStateSynchronizer() {
        if (!userStateSynchronizers.containsKey((Object)UserStateSynchronizerType.EMAIL) || userStateSynchronizers.get((Object)UserStateSynchronizerType.EMAIL) == null) {
            userStateSynchronizers.put(UserStateSynchronizerType.EMAIL, new UserStateEmailSynchronizer());
        }
        return (UserStateEmailSynchronizer)userStateSynchronizers.get((Object)UserStateSynchronizerType.EMAIL);
    }

    static boolean persist() {
        boolean pushPersisted = OneSignalStateSynchronizer.getPushStateSynchronizer().persist();
        boolean emailPersisted = OneSignalStateSynchronizer.getEmailStateSynchronizer().persist();
        if (emailPersisted) {
            emailPersisted = OneSignalStateSynchronizer.getEmailStateSynchronizer().getRegistrationId() != null;
        }
        return pushPersisted || emailPersisted;
    }

    static void clearLocation() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().clearLocation();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().clearLocation();
    }

    static void initUserState() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().initUserState();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().initUserState();
    }

    static void syncUserState(boolean fromSyncService) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().syncUserState(fromSyncService);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().syncUserState(fromSyncService);
    }

    static void sendTags(JSONObject newTags, @Nullable OneSignal.ChangeTagsUpdateHandler handler) {
        try {
            JSONObject jsonField = new JSONObject().put("tags", (Object)newTags);
            OneSignalStateSynchronizer.getPushStateSynchronizer().sendTags(jsonField, handler);
            OneSignalStateSynchronizer.getEmailStateSynchronizer().sendTags(jsonField, handler);
        }
        catch (JSONException e) {
            if (handler != null) {
                handler.onFailure(new OneSignal.SendTagsError(-1, "Encountered an error attempting to serialize your tags into JSON: " + e.getMessage() + "\n" + e.getStackTrace()));
            }
            e.printStackTrace();
        }
    }

    static void setEmail(String email, String emailAuthHash) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setEmail(email, emailAuthHash);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setEmail(email, emailAuthHash);
    }

    static void setSubscription(boolean enable) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setSubscription(enable);
    }

    static boolean getUserSubscribePreference() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getUserSubscribePreference();
    }

    static void setPermission(boolean enable) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setPermission(enable);
    }

    static void updateLocation(LocationController.LocationPoint point) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateLocation(point);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().updateLocation(point);
    }

    static boolean getSubscribed() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getSubscribed();
    }

    static String getRegistrationId() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getRegistrationId();
    }

    static UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getTags(fromServer);
    }

    static void resetCurrentState() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().resetCurrentState();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().resetCurrentState();
        OneSignal.saveUserId(null);
        OneSignal.saveEmailId(null);
        OneSignal.setLastSessionTime(-3660L);
    }

    static void updateDeviceInfo(JSONObject deviceInfo) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateDeviceInfo(deviceInfo);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().updateDeviceInfo(deviceInfo);
    }

    static void updatePushState(JSONObject pushState) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateState(pushState);
    }

    static void refreshEmailState() {
        OneSignalStateSynchronizer.getEmailStateSynchronizer().refresh();
    }

    static void setNewSession() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setNewSession();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setNewSession();
    }

    static boolean getSyncAsNewSession() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getSyncAsNewSession() || OneSignalStateSynchronizer.getEmailStateSynchronizer().getSyncAsNewSession();
    }

    static void setNewSessionForEmail() {
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setNewSession();
    }

    static void logoutEmail() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().logoutEmail();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().logoutEmail();
    }

    static void setExternalUserId(String externalId, final OneSignal.OSExternalUserIdUpdateCompletionHandler completionHandler) throws JSONException {
        final JSONObject responses = new JSONObject();
        OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler = new OneSignal.OSInternalExternalUserIdUpdateCompletionHandler(){

            @Override
            public void onComplete(String channel, boolean success) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "Completed request to update external user id for channel: " + channel + " and success: " + success);
                try {
                    responses.put(channel, (Object)new JSONObject().put("success", success));
                }
                catch (JSONException e) {
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Error while adding the success status of external id for channel: " + channel);
                    e.printStackTrace();
                }
                for (UserStateSynchronizer userStateSynchronizer : userStateSynchronizers.values()) {
                    if (!userStateSynchronizer.hasQueuedHandlers()) continue;
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "External user id handlers are still being processed for channel: " + userStateSynchronizer.getChannelString() + " , wait until finished before proceeding");
                    return;
                }
                OSUtils.runOnMainUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (completionHandler != null) {
                            completionHandler.onComplete(responses);
                        }
                    }
                });
            }
        };
        OneSignalStateSynchronizer.getPushStateSynchronizer().setExternalUserId(externalId, handler);
        if (OneSignal.hasEmailId()) {
            OneSignalStateSynchronizer.getEmailStateSynchronizer().setExternalUserId(externalId, handler);
        }
    }

    static void readyToUpdate(boolean canMakeUpdates) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().readyToUpdate(canMakeUpdates);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().readyToUpdate(canMakeUpdates);
    }

    static enum UserStateSynchronizerType {
        PUSH,
        EMAIL;


        public boolean isPush() {
            return this.equals((Object)PUSH);
        }

        public boolean isEmail() {
            return this.equals((Object)EMAIL);
        }
    }
}

