/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import com.onesignal.GooglePlayServicesUpgradePrompt;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistrator;
import java.io.IOException;

abstract class PushRegistratorAbstractGoogle
implements PushRegistrator {
    private PushRegistrator.RegisteredHandler registeredHandler;
    private static int REGISTRATION_RETRY_COUNT = 5;
    private static int REGISTRATION_RETRY_BACKOFF_MS = 10000;
    private Thread registerThread;
    private boolean firedCallback;

    PushRegistratorAbstractGoogle() {
    }

    abstract String getProviderName();

    abstract String getToken(String var1) throws Throwable;

    @Override
    public void registerForPush(Context context, String senderId, PushRegistrator.RegisteredHandler callback) {
        this.registeredHandler = callback;
        if (this.isValidProjectNumber(senderId, callback)) {
            this.internalRegisterForPush(senderId);
        }
    }

    private void internalRegisterForPush(String senderId) {
        try {
            if (OSUtils.isGMSInstalledAndEnabled()) {
                this.registerInBackground(senderId);
            } else {
                GooglePlayServicesUpgradePrompt.showUpdateGPSDialog();
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "'Google Play services' app not installed or disabled on the device.");
                this.registeredHandler.complete(null, -7);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not register with " + this.getProviderName() + " due to an issue with your AndroidManifest.xml or with 'Google Play services'.", t);
            this.registeredHandler.complete(null, -8);
        }
    }

    private synchronized void registerInBackground(final String senderId) {
        if (this.registerThread != null && this.registerThread.isAlive()) {
            return;
        }
        this.registerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int currentRetry = 0; currentRetry < REGISTRATION_RETRY_COUNT; ++currentRetry) {
                    boolean finished = PushRegistratorAbstractGoogle.this.attemptRegistration(senderId, currentRetry);
                    if (finished) {
                        return;
                    }
                    OSUtils.sleep(REGISTRATION_RETRY_BACKOFF_MS * (currentRetry + 1));
                }
            }
        });
        this.registerThread.start();
    }

    private boolean attemptRegistration(String senderId, int currentRetry) {
        try {
            String registrationId = this.getToken(senderId);
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered, push token = " + registrationId);
            this.registeredHandler.complete(registrationId, 1);
            return true;
        }
        catch (IOException e) {
            if (!"SERVICE_NOT_AVAILABLE".equals(e.getMessage())) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error Getting " + this.getProviderName() + " Token", e);
                if (!this.firedCallback) {
                    this.registeredHandler.complete(null, -11);
                }
                return true;
            }
            if (currentRetry >= REGISTRATION_RETRY_COUNT - 1) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Retry count of " + REGISTRATION_RETRY_COUNT + " exceed! Could not get a " + this.getProviderName() + " Token.", e);
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "'Google Play services' returned SERVICE_NOT_AVAILABLE error. Current retry count: " + currentRetry, e);
                if (currentRetry == 2) {
                    this.registeredHandler.complete(null, -9);
                    this.firedCallback = true;
                    return true;
                }
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Unknown error getting " + this.getProviderName() + " Token", t);
            this.registeredHandler.complete(null, -12);
            return true;
        }
        return false;
    }

    private boolean isValidProjectNumber(String senderId, PushRegistrator.RegisteredHandler callback) {
        boolean isProjectNumberValidFormat;
        try {
            Float.parseFloat(senderId);
            isProjectNumberValidFormat = true;
        }
        catch (Throwable t) {
            isProjectNumberValidFormat = false;
        }
        if (!isProjectNumberValidFormat) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Missing Google Project number!\nPlease enter a Google Project number / Sender ID on under App Settings > Android > Configuration on the OneSignal dashboard.");
            callback.complete(null, -6);
            return false;
        }
        return true;
    }
}

