/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.onesignal.OSInAppMessageInternal;
import com.onesignal.OSInAppMessageRedisplayStats;
import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessageRepository {
    static final String IAM_DATA_RESPONSE_RETRY_KEY = "retry";
    static final long IAM_CACHE_DATA_LIFETIME = 15552000L;
    private final OneSignalDbHelper dbHelper;
    private final OSLogger logger;
    private final OSSharedPreferences sharedPreferences;
    private int htmlNetworkRequestAttemptCount = 0;

    OSInAppMessageRepository(OneSignalDbHelper dbHelper, OSLogger logger, OSSharedPreferences sharedPreferences) {
        this.dbHelper = dbHelper;
        this.logger = logger;
        this.sharedPreferences = sharedPreferences;
    }

    void sendIAMClick(final String appId, final String userId, final String variantId, final int deviceType, String messageId, final String clickId, final boolean isFirstClick, final Set<String> clickedMessagesId, final OSInAppMessageRequestResponse requestResponse) {
        try {
            JSONObject json = new JSONObject(){
                {
                    this.put("app_id", appId);
                    this.put("device_type", deviceType);
                    this.put("player_id", userId);
                    this.put("click_id", clickId);
                    this.put("variant_id", variantId);
                    if (isFirstClick) {
                        this.put("first_click", true);
                    }
                }
            };
            OneSignalRestClient.post("in_app_messages/" + messageId + "/click", json, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OSInAppMessageRepository.this.printHttpSuccessForInAppMessageRequest("engagement", response);
                    OSInAppMessageRepository.this.saveClickedMessagesId(clickedMessagesId);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OSInAppMessageRepository.this.printHttpErrorForInAppMessageRequest("engagement", statusCode, response);
                    requestResponse.onFailure(response);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logger.error("Unable to execute in-app message action HTTP request due to invalid JSON");
        }
    }

    void sendIAMPageImpression(final String appId, final String userId, final String variantId, final int deviceType, String messageId, final String pageId, final Set<String> viewedPageIds, final OSInAppMessageRequestResponse requestResponse) {
        try {
            JSONObject json = new JSONObject(){
                {
                    this.put("app_id", appId);
                    this.put("player_id", userId);
                    this.put("variant_id", variantId);
                    this.put("device_type", deviceType);
                    this.put("page_id", pageId);
                }
            };
            OneSignalRestClient.post("in_app_messages/" + messageId + "/pageImpression", json, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OSInAppMessageRepository.this.printHttpSuccessForInAppMessageRequest("page impression", response);
                    OSInAppMessageRepository.this.saveViewPageImpressionedIds(viewedPageIds);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OSInAppMessageRepository.this.printHttpErrorForInAppMessageRequest("page impression", statusCode, response);
                    requestResponse.onFailure(response);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logger.error("Unable to execute in-app message impression HTTP request due to invalid JSON");
        }
    }

    void sendIAMImpression(final String appId, final String userId, final String variantId, final int deviceType, String messageId, final Set<String> impressionedMessages, final OSInAppMessageRequestResponse requestResponse) {
        try {
            JSONObject json = new JSONObject(){
                {
                    this.put("app_id", appId);
                    this.put("player_id", userId);
                    this.put("variant_id", variantId);
                    this.put("device_type", deviceType);
                    this.put("first_impression", true);
                }
            };
            OneSignalRestClient.post("in_app_messages/" + messageId + "/impression", json, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OSInAppMessageRepository.this.printHttpSuccessForInAppMessageRequest("impression", response);
                    OSInAppMessageRepository.this.saveImpressionedMessages(impressionedMessages);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OSInAppMessageRepository.this.printHttpErrorForInAppMessageRequest("impression", statusCode, response);
                    requestResponse.onFailure(response);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logger.error("Unable to execute in-app message impression HTTP request due to invalid JSON");
        }
    }

    void getIAMPreviewData(String appId, String previewUUID, final OSInAppMessageRequestResponse requestResponse) {
        String htmlPath = "in_app_messages/device_preview?preview_id=" + previewUUID + "&app_id=" + appId;
        OneSignalRestClient.get(htmlPath, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OSInAppMessageRepository.this.printHttpErrorForInAppMessageRequest("html", statusCode, response);
                requestResponse.onFailure(response);
            }

            @Override
            void onSuccess(String response) {
                requestResponse.onSuccess(response);
            }
        }, null);
    }

    void getIAMData(String appId, String messageId, String variantId, final OSInAppMessageRequestResponse requestResponse) {
        String htmlPath = this.htmlPathForMessage(messageId, variantId, appId);
        OneSignalRestClient.get(htmlPath, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OSInAppMessageRepository.this.printHttpErrorForInAppMessageRequest("html", statusCode, response);
                JSONObject jsonObject = new JSONObject();
                if (!OSUtils.shouldRetryNetworkRequest(statusCode) || OSInAppMessageRepository.this.htmlNetworkRequestAttemptCount >= OSUtils.MAX_NETWORK_REQUEST_ATTEMPT_COUNT) {
                    OSInAppMessageRepository.this.htmlNetworkRequestAttemptCount = 0;
                    try {
                        jsonObject.put(OSInAppMessageRepository.IAM_DATA_RESPONSE_RETRY_KEY, false);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    OSInAppMessageRepository.this.htmlNetworkRequestAttemptCount++;
                    try {
                        jsonObject.put(OSInAppMessageRepository.IAM_DATA_RESPONSE_RETRY_KEY, true);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                requestResponse.onFailure(jsonObject.toString());
            }

            @Override
            void onSuccess(String response) {
                OSInAppMessageRepository.this.htmlNetworkRequestAttemptCount = 0;
                requestResponse.onSuccess(response);
            }
        }, null);
    }

    @WorkerThread
    synchronized void saveInAppMessage(OSInAppMessageInternal inAppMessage) {
        ContentValues values = new ContentValues();
        values.put("message_id", inAppMessage.messageId);
        values.put("display_quantity", Integer.valueOf(inAppMessage.getRedisplayStats().getDisplayQuantity()));
        values.put("last_display", Long.valueOf(inAppMessage.getRedisplayStats().getLastDisplayTime()));
        values.put("click_ids", inAppMessage.getClickedClickIds().toString());
        values.put("displayed_in_session", Boolean.valueOf(inAppMessage.isDisplayedInSession()));
        int rowsUpdated = this.dbHelper.update("in_app_message", values, "message_id = ?", new String[]{inAppMessage.messageId});
        if (rowsUpdated == 0) {
            this.dbHelper.insert("in_app_message", null, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized List<OSInAppMessageInternal> getCachedInAppMessages() {
        ArrayList<OSInAppMessageInternal> inAppMessages = new ArrayList<OSInAppMessageInternal>();
        Cursor cursor = null;
        try {
            cursor = this.dbHelper.query("in_app_message", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    String messageId = cursor.getString(cursor.getColumnIndex("message_id"));
                    String clickIds = cursor.getString(cursor.getColumnIndex("click_ids"));
                    int displayQuantity = cursor.getInt(cursor.getColumnIndex("display_quantity"));
                    long lastDisplay = cursor.getLong(cursor.getColumnIndex("last_display"));
                    boolean displayed = cursor.getInt(cursor.getColumnIndex("displayed_in_session")) == 1;
                    Set<String> clickIdsSet = OSUtils.newStringSetFromJSONArray(new JSONArray(clickIds));
                    OSInAppMessageInternal inAppMessage = new OSInAppMessageInternal(messageId, clickIdsSet, displayed, new OSInAppMessageRedisplayStats(displayQuantity, lastDisplay));
                    inAppMessages.add(inAppMessage);
                } while (cursor.moveToNext());
            }
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating JSONArray from iam click ids:JSON Failed.", e);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return inAppMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized void cleanCachedInAppMessages() {
        String[] retColumns = new String[]{"message_id", "click_ids"};
        String whereStr = "last_display < ?";
        String sixMonthsAgoInSeconds = String.valueOf(System.currentTimeMillis() / 1000L - 15552000L);
        String[] whereArgs = new String[]{sixMonthsAgoInSeconds};
        Set<String> oldMessageIds = OSUtils.newConcurrentSet();
        Set<String> oldClickedClickIds = OSUtils.newConcurrentSet();
        Cursor cursor = null;
        try {
            cursor = this.dbHelper.query("in_app_message", retColumns, whereStr, whereArgs, null, null, null);
            if (cursor == null || cursor.getCount() == 0) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Attempted to clean 6 month old IAM data, but none exists!");
                return;
            }
            if (cursor.moveToFirst()) {
                do {
                    String oldMessageId = cursor.getString(cursor.getColumnIndex("message_id"));
                    String oldClickIds = cursor.getString(cursor.getColumnIndex("click_ids"));
                    oldMessageIds.add(oldMessageId);
                    oldClickedClickIds.addAll(OSUtils.newStringSetFromJSONArray(new JSONArray(oldClickIds)));
                } while (cursor.moveToNext());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        this.dbHelper.delete("in_app_message", whereStr, whereArgs);
        this.cleanInAppMessageIds(oldMessageIds);
        this.cleanInAppMessageClickedClickIds(oldClickedClickIds);
    }

    private void cleanInAppMessageIds(Set<String> oldMessageIds) {
        if (oldMessageIds != null && oldMessageIds.size() > 0) {
            Set<String> dismissedMessages = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", null);
            Set<String> impressionedMessages = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", null);
            if (dismissedMessages != null && dismissedMessages.size() > 0) {
                dismissedMessages.removeAll(oldMessageIds);
                OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", dismissedMessages);
            }
            if (impressionedMessages != null && impressionedMessages.size() > 0) {
                impressionedMessages.removeAll(oldMessageIds);
                OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", impressionedMessages);
            }
        }
    }

    private void cleanInAppMessageClickedClickIds(Set<String> oldClickedClickIds) {
        Set<String> clickedClickIds;
        if (oldClickedClickIds != null && oldClickedClickIds.size() > 0 && (clickedClickIds = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", null)) != null && clickedClickIds.size() > 0) {
            clickedClickIds.removeAll(oldClickedClickIds);
            OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", clickedClickIds);
        }
    }

    @Nullable
    private String htmlPathForMessage(String messageId, String variantId, String appId) {
        if (variantId == null) {
            this.logger.error("Unable to find a variant for in-app message " + messageId);
            return null;
        }
        return "in_app_messages/" + messageId + "/variants/" + variantId + "/html?app_id=" + appId;
    }

    Set<String> getClickedMessagesId() {
        return this.sharedPreferences.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", null);
    }

    private void saveClickedMessagesId(Set<String> clickedClickIds) {
        this.sharedPreferences.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", clickedClickIds);
    }

    Set<String> getImpressionesMessagesId() {
        return this.sharedPreferences.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", null);
    }

    private void saveImpressionedMessages(Set<String> impressionedMessages) {
        this.sharedPreferences.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", impressionedMessages);
    }

    Set<String> getViewPageImpressionedIds() {
        return this.sharedPreferences.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_PAGE_IMPRESSIONED_IAMS", null);
    }

    void saveViewPageImpressionedIds(Set<String> viewedPageIds) {
        this.sharedPreferences.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_PAGE_IMPRESSIONED_IAMS", viewedPageIds);
    }

    Set<String> getDismissedMessagesId() {
        return this.sharedPreferences.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", null);
    }

    void saveDismissedMessagesId(Set<String> dismissedMessages) {
        this.sharedPreferences.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", dismissedMessages);
    }

    String getSavedIAMs() {
        return this.sharedPreferences.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CACHED_IAMS", null);
    }

    void saveIAMs(String inAppMessages) {
        this.sharedPreferences.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CACHED_IAMS", inAppMessages);
    }

    private void printHttpSuccessForInAppMessageRequest(String requestType, String response) {
        this.logger.debug("Successful post for in-app message " + requestType + " request: " + response);
    }

    private void printHttpErrorForInAppMessageRequest(String requestType, int statusCode, String response) {
        this.logger.error("Encountered a " + statusCode + " error while attempting in-app message " + requestType + " request: " + response);
    }

    static interface OSInAppMessageRequestResponse {
        public void onSuccess(String var1);

        public void onFailure(String var1);
    }
}

