/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.onesignal.OSReceiveReceiptRepository;
import com.onesignal.OSRemoteParamController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import java.util.concurrent.TimeUnit;

class OSReceiveReceiptController {
    private static final String OS_NOTIFICATION_ID = "os_notification_id";
    private int minDelay = 0;
    private int maxDelay = 25;
    private final OSRemoteParamController remoteParamController = OneSignal.getRemoteParamController();
    private static OSReceiveReceiptController sInstance;

    private OSReceiveReceiptController() {
    }

    public static synchronized OSReceiveReceiptController getInstance() {
        if (sInstance == null) {
            sInstance = new OSReceiveReceiptController();
        }
        return sInstance;
    }

    void beginEnqueueingWork(Context context, String osNotificationId) {
        if (!this.remoteParamController.isReceiveReceiptEnabled()) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "sendReceiveReceipt disabled");
            return;
        }
        int delay = OSUtils.getRandomDelay(this.minDelay, this.maxDelay);
        Data inputData = new Data.Builder().putString(OS_NOTIFICATION_ID, osNotificationId).build();
        Constraints constraints = this.buildConstraints();
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ReceiveReceiptWorker.class).setConstraints(constraints)).setInitialDelay((long)delay, TimeUnit.SECONDS)).setInputData(inputData)).build();
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OSReceiveReceiptController enqueueing send receive receipt work with notificationId: " + osNotificationId + " and delay: " + delay + " seconds");
        WorkManager.getInstance((Context)context).enqueueUniqueWork(osNotificationId + "_receive_receipt", ExistingWorkPolicy.KEEP, workRequest);
    }

    Constraints buildConstraints() {
        return new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
    }

    public static class ReceiveReceiptWorker
    extends Worker {
        public ReceiveReceiptWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
            super(context, workerParams);
        }

        @NonNull
        public ListenableWorker.Result doWork() {
            Data inputData = this.getInputData();
            String notificationId = inputData.getString(OSReceiveReceiptController.OS_NOTIFICATION_ID);
            this.sendReceiveReceipt(notificationId);
            return ListenableWorker.Result.success();
        }

        void sendReceiveReceipt(final @NonNull String notificationId) {
            String appId = OneSignal.appId == null || OneSignal.appId.isEmpty() ? OneSignal.getSavedAppId() : OneSignal.appId;
            String playerId = OneSignal.getUserId();
            Integer deviceType = null;
            OSReceiveReceiptRepository repository = new OSReceiveReceiptRepository();
            try {
                deviceType = new OSUtils().getDeviceType();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            Integer finalDeviceType = deviceType;
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "ReceiveReceiptWorker: Device Type is: " + finalDeviceType);
            repository.sendReceiveReceipt(appId, playerId, finalDeviceType, notificationId, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Receive receipt sent for notificationID: " + notificationId);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Receive receipt failed with statusCode: " + statusCode + " response: " + response);
                }
            });
        }
    }
}

