/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence.data;

import com.onesignal.OSLogger;
import com.onesignal.OSTime;
import com.onesignal.influence.data.OSInfluenceDataRepository;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceChannel;
import com.onesignal.influence.domain.OSInfluenceType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0012H&J\b\u0010A\u001a\u00020=H&J\u0013\u0010B\u001a\u0002002\b\u0010C\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0012\u0010D\u001a\u00020$2\b\u0010E\u001a\u0004\u0018\u00010\u001aH&J\b\u0010F\u001a\u00020\nH\u0016J\b\u0010G\u001a\u00020=H&J\u0006\u0010H\u001a\u00020=J\u0010\u0010I\u001a\u00020=2\u0006\u0010J\u001a\u00020$H&J\u0010\u0010K\u001a\u00020=2\b\u0010E\u001a\u0004\u0018\u00010\u001aJ\b\u0010L\u001a\u00020\u001aH\u0016R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0012\u0010!\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\fR\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u0014\u00102\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00101R\u0014\u00103\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00101R\u0014\u00104\u001a\u00020$8fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010&R\u0011\u00106\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010&R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/onesignal/influence/data/OSChannelTracker;", "", "dataRepository", "Lcom/onesignal/influence/data/OSInfluenceDataRepository;", "logger", "Lcom/onesignal/OSLogger;", "timeProvider", "Lcom/onesignal/OSTime;", "(Lcom/onesignal/influence/data/OSInfluenceDataRepository;Lcom/onesignal/OSLogger;Lcom/onesignal/OSTime;)V", "channelLimit", "", "getChannelLimit", "()I", "channelType", "Lcom/onesignal/influence/domain/OSInfluenceChannel;", "getChannelType", "()Lcom/onesignal/influence/domain/OSInfluenceChannel;", "currentSessionInfluence", "Lcom/onesignal/influence/domain/OSInfluence;", "getCurrentSessionInfluence", "()Lcom/onesignal/influence/domain/OSInfluence;", "getDataRepository", "()Lcom/onesignal/influence/data/OSInfluenceDataRepository;", "setDataRepository", "(Lcom/onesignal/influence/data/OSInfluenceDataRepository;)V", "directId", "", "getDirectId", "()Ljava/lang/String;", "setDirectId", "(Ljava/lang/String;)V", "idTag", "getIdTag", "indirectAttributionWindow", "getIndirectAttributionWindow", "indirectIds", "Lorg/json/JSONArray;", "getIndirectIds", "()Lorg/json/JSONArray;", "setIndirectIds", "(Lorg/json/JSONArray;)V", "influenceType", "Lcom/onesignal/influence/domain/OSInfluenceType;", "getInfluenceType", "()Lcom/onesignal/influence/domain/OSInfluenceType;", "setInfluenceType", "(Lcom/onesignal/influence/domain/OSInfluenceType;)V", "isDirectSessionEnabled", "", "()Z", "isIndirectSessionEnabled", "isUnattributedSessionEnabled", "lastChannelObjects", "getLastChannelObjects", "lastReceivedIds", "getLastReceivedIds", "getLogger", "()Lcom/onesignal/OSLogger;", "setLogger", "(Lcom/onesignal/OSLogger;)V", "addSessionData", "", "jsonObject", "Lorg/json/JSONObject;", "influence", "cacheState", "equals", "other", "getLastChannelObjectsReceivedByNewId", "id", "hashCode", "initInfluencedTypeFromCache", "resetAndInitInfluence", "saveChannelObjects", "channelObjects", "saveLastId", "toString", "onesignal_release"})
public abstract class OSChannelTracker {
    @Nullable
    private OSInfluenceType influenceType;
    @Nullable
    private JSONArray indirectIds;
    @Nullable
    private String directId;
    @NotNull
    private OSInfluenceDataRepository dataRepository;
    @NotNull
    private OSLogger logger;
    private OSTime timeProvider;

    @Nullable
    public final OSInfluenceType getInfluenceType() {
        return this.influenceType;
    }

    public final void setInfluenceType(@Nullable OSInfluenceType oSInfluenceType) {
        this.influenceType = oSInfluenceType;
    }

    @Nullable
    public final JSONArray getIndirectIds() {
        return this.indirectIds;
    }

    public final void setIndirectIds(@Nullable JSONArray jSONArray) {
        this.indirectIds = jSONArray;
    }

    @Nullable
    public final String getDirectId() {
        return this.directId;
    }

    public final void setDirectId(@Nullable String string2) {
        this.directId = string2;
    }

    @NotNull
    public abstract String getIdTag();

    @NotNull
    public abstract OSInfluenceChannel getChannelType();

    @NotNull
    public abstract JSONArray getLastChannelObjects() throws JSONException;

    public abstract int getChannelLimit();

    public abstract int getIndirectAttributionWindow();

    @NotNull
    public abstract JSONArray getLastChannelObjectsReceivedByNewId(@Nullable String var1);

    public abstract void saveChannelObjects(@NotNull JSONArray var1);

    public abstract void initInfluencedTypeFromCache();

    public abstract void cacheState();

    public abstract void addSessionData(@NotNull JSONObject var1, @NotNull OSInfluence var2);

    private final boolean isDirectSessionEnabled() {
        return this.dataRepository.isDirectInfluenceEnabled();
    }

    private final boolean isIndirectSessionEnabled() {
        return this.dataRepository.isIndirectInfluenceEnabled();
    }

    private final boolean isUnattributedSessionEnabled() {
        return this.dataRepository.isUnattributedInfluenceEnabled();
    }

    @NotNull
    public final OSInfluence getCurrentSessionInfluence() {
        OSInfluenceType currentInfluenceType;
        OSInfluenceType oSInfluenceType;
        OSInfluence sessionInfluence = new OSInfluence(this.getChannelType(), OSInfluenceType.DISABLED, null);
        if (this.influenceType == null) {
            this.initInfluencedTypeFromCache();
        }
        if ((oSInfluenceType = this.influenceType) == null) {
            oSInfluenceType = currentInfluenceType = OSInfluenceType.DISABLED;
        }
        if (currentInfluenceType.isDirect()) {
            if (this.isDirectSessionEnabled()) {
                OSInfluence oSInfluence = sessionInfluence;
                boolean bl = false;
                boolean bl2 = false;
                OSInfluence $this$apply = oSInfluence;
                boolean bl3 = false;
                $this$apply.setIds(new JSONArray().put((Object)this.directId));
                $this$apply.setInfluenceType(OSInfluenceType.DIRECT);
            }
        } else if (currentInfluenceType.isIndirect()) {
            if (this.isIndirectSessionEnabled()) {
                OSInfluence oSInfluence = sessionInfluence;
                boolean bl = false;
                boolean bl4 = false;
                OSInfluence $this$apply = oSInfluence;
                boolean bl5 = false;
                $this$apply.setIds(this.indirectIds);
                $this$apply.setInfluenceType(OSInfluenceType.INDIRECT);
            }
        } else if (this.isUnattributedSessionEnabled()) {
            OSInfluence oSInfluence = sessionInfluence;
            boolean bl = false;
            boolean bl6 = false;
            OSInfluence $this$apply = oSInfluence;
            boolean bl7 = false;
            $this$apply.setInfluenceType(OSInfluenceType.UNATTRIBUTED);
        }
        return sessionInfluence;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONArray getLastReceivedIds() {
        JSONArray ids = new JSONArray();
        try {
            JSONArray lastChannelObjectReceived = this.getLastChannelObjects();
            this.logger.debug("OneSignal ChannelTracker getLastReceivedIds lastChannelObjectReceived: " + lastChannelObjectReceived);
            long attributionWindow = (long)(this.getIndirectAttributionWindow() * 60) * 1000L;
            long currentTime = this.timeProvider.getCurrentTimeMillis();
            int n = 0;
            int n2 = lastChannelObjectReceived.length();
            while (n < n2) {
                void i;
                JSONObject jsonObject = lastChannelObjectReceived.getJSONObject((int)i);
                long time = jsonObject.getLong("time");
                long difference = currentTime - time;
                if (difference <= attributionWindow) {
                    String id2 = jsonObject.getString(this.getIdTag());
                    ids.put((Object)id2);
                }
                ++i;
            }
        }
        catch (JSONException exception) {
            this.logger.error("Generating tracker getLastReceivedIds JSONObject ", exception);
        }
        return ids;
    }

    public final void resetAndInitInfluence() {
        this.directId = null;
        JSONArray jSONArray = this.indirectIds = this.getLastReceivedIds();
        this.influenceType = (jSONArray != null ? jSONArray.length() : 0) > 0 ? OSInfluenceType.INDIRECT : OSInfluenceType.UNATTRIBUTED;
        this.cacheState();
        this.logger.debug("OneSignal OSChannelTracker resetAndInitInfluence: " + this.getIdTag() + " finish with influenceType: " + (Object)((Object)this.influenceType));
    }

    /*
     * WARNING - void declaration
     */
    public final void saveLastId(@Nullable String id2) {
        int n;
        block10: {
            block9: {
                this.logger.debug("OneSignal OSChannelTracker for: " + this.getIdTag() + " saveLastId: " + id2);
                if (id2 == null) break block9;
                CharSequence charSequence = id2;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block10;
            }
            return;
        }
        JSONArray lastChannelObjectsReceived = this.getLastChannelObjectsReceivedByNewId(id2);
        this.logger.debug("OneSignal OSChannelTracker for: " + this.getIdTag() + " saveLastId with lastChannelObjectsReceived: " + lastChannelObjectsReceived);
        try {
            OSTime oSTime = this.timeProvider;
            boolean bl = false;
            n = 0;
            OSTime $this$run = oSTime;
            boolean bl2 = false;
            oSTime = new JSONObject().put(this.getIdTag(), (Object)id2).put("time", $this$run.getCurrentTimeMillis());
            bl = false;
            n = 0;
            OSTime newInfluenceId = oSTime;
            boolean bl3 = false;
            lastChannelObjectsReceived.put((Object)newInfluenceId);
        }
        catch (JSONException exception) {
            this.logger.error("Generating tracker newInfluenceId JSONObject ", exception);
            return;
        }
        JSONArray channelObjectToSave = lastChannelObjectsReceived;
        if (lastChannelObjectsReceived.length() > this.getChannelLimit()) {
            int lengthDifference = lastChannelObjectsReceived.length() - this.getChannelLimit();
            channelObjectToSave = new JSONArray();
            n = lengthDifference;
            int n2 = lastChannelObjectsReceived.length();
            while (n < n2) {
                void i;
                try {
                    channelObjectToSave.put(lastChannelObjectsReceived.get((int)i));
                }
                catch (JSONException exception) {
                    this.logger.error("Generating tracker lastChannelObjectsReceived get JSONObject ", exception);
                }
                ++i;
            }
        }
        this.logger.debug("OneSignal OSChannelTracker for: " + this.getIdTag() + " with channelObjectToSave: " + channelObjectToSave);
        this.saveChannelObjects(channelObjectToSave);
    }

    @NotNull
    public String toString() {
        return "OSChannelTracker{tag=" + this.getIdTag() + ", influenceType=" + (Object)((Object)this.influenceType) + ", indirectIds=" + this.indirectIds + ", directId=" + this.directId + '}';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        OSChannelTracker tracker = (OSChannelTracker)other;
        return this.influenceType == tracker.influenceType && Intrinsics.areEqual((Object)tracker.getIdTag(), (Object)this.getIdTag());
    }

    public int hashCode() {
        OSInfluenceType oSInfluenceType = this.influenceType;
        boolean bl = false;
        OSInfluenceType oSInfluenceType2 = oSInfluenceType;
        int result = oSInfluenceType2 != null ? ((Object)((Object)oSInfluenceType2)).hashCode() : 0;
        result = 31 * result + this.getIdTag().hashCode();
        return result;
    }

    @NotNull
    protected final OSInfluenceDataRepository getDataRepository() {
        return this.dataRepository;
    }

    protected final void setDataRepository(@NotNull OSInfluenceDataRepository oSInfluenceDataRepository) {
        Intrinsics.checkNotNullParameter((Object)oSInfluenceDataRepository, (String)"<set-?>");
        this.dataRepository = oSInfluenceDataRepository;
    }

    @NotNull
    public final OSLogger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull OSLogger oSLogger) {
        Intrinsics.checkNotNullParameter((Object)oSLogger, (String)"<set-?>");
        this.logger = oSLogger;
    }

    public OSChannelTracker(@NotNull OSInfluenceDataRepository dataRepository, @NotNull OSLogger logger, @NotNull OSTime timeProvider) {
        Intrinsics.checkNotNullParameter((Object)dataRepository, (String)"dataRepository");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.dataRepository = dataRepository;
        this.logger = logger;
        this.timeProvider = timeProvider;
    }
}

