/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.os.Bundle;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationOpenedResult;
import com.onesignal.OneSignal;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;

class TrackFirebaseAnalytics {
    private static Class<?> FirebaseAnalyticsClass;
    private Object mFirebaseAnalyticsInstance;
    private Context appContext;
    private static AtomicLong lastReceivedTime;
    private static AtomicLong lastOpenedTime;
    private static OSNotification lastReceivedNotification;
    private static final String EVENT_NOTIFICATION_OPENED = "os_notification_opened";
    private static final String EVENT_NOTIFICATION_INFLUENCE_OPEN = "os_notification_influence_open";
    private static final String EVENT_NOTIFICATION_RECEIVED = "os_notification_received";

    TrackFirebaseAnalytics(Context activity) {
        this.appContext = activity;
    }

    static boolean CanTrack() {
        try {
            FirebaseAnalyticsClass = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    void trackInfluenceOpenEvent() {
        if (lastReceivedTime == null || lastReceivedNotification == null) {
            return;
        }
        long now = OneSignal.getTime().getCurrentTimeMillis();
        if (now - lastReceivedTime.get() > 120000L) {
            return;
        }
        if (lastOpenedTime != null && now - lastOpenedTime.get() < 30000L) {
            return;
        }
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance(this.appContext);
            Method trackMethod = TrackFirebaseAnalytics.getTrackMethod(FirebaseAnalyticsClass);
            String event = EVENT_NOTIFICATION_INFLUENCE_OPEN;
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            bundle.putString("notification_id", lastReceivedNotification.getNotificationId());
            bundle.putString("campaign", this.getCampaignNameFromNotification(lastReceivedNotification));
            trackMethod.invoke(firebaseAnalyticsInstance, event, bundle);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void trackOpenedEvent(OSNotificationOpenedResult openResult) {
        if (lastOpenedTime == null) {
            lastOpenedTime = new AtomicLong();
        }
        lastOpenedTime.set(OneSignal.getTime().getCurrentTimeMillis());
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance(this.appContext);
            Method trackMethod = TrackFirebaseAnalytics.getTrackMethod(FirebaseAnalyticsClass);
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            bundle.putString("notification_id", openResult.getNotification().getNotificationId());
            bundle.putString("campaign", this.getCampaignNameFromNotification(openResult.getNotification()));
            trackMethod.invoke(firebaseAnalyticsInstance, EVENT_NOTIFICATION_OPENED, bundle);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void trackReceivedEvent(OSNotificationOpenedResult receivedResult) {
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance(this.appContext);
            Method trackMethod = TrackFirebaseAnalytics.getTrackMethod(FirebaseAnalyticsClass);
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            bundle.putString("notification_id", receivedResult.getNotification().getNotificationId());
            bundle.putString("campaign", this.getCampaignNameFromNotification(receivedResult.getNotification()));
            trackMethod.invoke(firebaseAnalyticsInstance, EVENT_NOTIFICATION_RECEIVED, bundle);
            if (lastReceivedTime == null) {
                lastReceivedTime = new AtomicLong();
            }
            lastReceivedTime.set(OneSignal.getTime().getCurrentTimeMillis());
            lastReceivedNotification = receivedResult.getNotification();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String getCampaignNameFromNotification(OSNotification notification) {
        if (!notification.getTemplateName().isEmpty() && !notification.getTemplateId().isEmpty()) {
            return notification.getTemplateName() + " - " + notification.getTemplateId();
        }
        if (notification.getTitle() != null) {
            return notification.getTitle().substring(0, Math.min(10, notification.getTitle().length()));
        }
        return "";
    }

    private Object getFirebaseAnalyticsInstance(Context context) {
        if (this.mFirebaseAnalyticsInstance == null) {
            Method getInstanceMethod = TrackFirebaseAnalytics.getInstanceMethod(FirebaseAnalyticsClass);
            try {
                this.mFirebaseAnalyticsInstance = getInstanceMethod.invoke(null, context);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.mFirebaseAnalyticsInstance;
    }

    private static Method getTrackMethod(Class clazz) {
        try {
            return clazz.getMethod("logEvent", String.class, Bundle.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Method getInstanceMethod(Class clazz) {
        try {
            return clazz.getMethod("getInstance", Context.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }
}

