/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.OSViewUtils;
import com.onesignal.OneSignal;
import java.lang.ref.WeakReference;
import java.util.List;

class OSSystemConditionController {
    private static final String TAG = OSSystemConditionController.class.getCanonicalName();
    private final OSSystemConditionObserver systemConditionObserver;

    OSSystemConditionController(OSSystemConditionObserver systemConditionObserver) {
        this.systemConditionObserver = systemConditionObserver;
    }

    boolean systemConditionsAvailable() {
        if (OneSignal.getCurrentActivity() == null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "OSSystemConditionObserver curActivity null");
            return false;
        }
        try {
            if (this.isDialogFragmentShowing((Context)OneSignal.getCurrentActivity())) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "OSSystemConditionObserver dialog fragment detected");
                return false;
            }
        }
        catch (NoClassDefFoundError exception) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.INFO, "AppCompatActivity is not used in this app, skipping 'isDialogFragmentShowing' check: " + exception);
        }
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        boolean keyboardUp = OSViewUtils.isKeyboardUp(new WeakReference<Activity>(OneSignal.getCurrentActivity()));
        if (keyboardUp && activityLifecycleHandler != null) {
            activityLifecycleHandler.addSystemConditionObserver(TAG, this.systemConditionObserver);
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "OSSystemConditionObserver keyboard up detected");
        }
        return !keyboardUp;
    }

    boolean isDialogFragmentShowing(Context context) throws NoClassDefFoundError {
        if (context instanceof AppCompatActivity) {
            final FragmentManager manager = ((AppCompatActivity)context).getSupportFragmentManager();
            manager.registerFragmentLifecycleCallbacks(new FragmentManager.FragmentLifecycleCallbacks(){

                public void onFragmentDetached(@NonNull FragmentManager fm, @NonNull Fragment fragmentDetached) {
                    super.onFragmentDetached(fm, fragmentDetached);
                    if (fragmentDetached instanceof DialogFragment) {
                        manager.unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this);
                        OSSystemConditionController.this.systemConditionObserver.systemConditionChanged();
                    }
                }
            }, true);
            List fragments = manager.getFragments();
            int size = fragments.size();
            if (size > 0) {
                Fragment fragment = (Fragment)fragments.get(size - 1);
                return fragment.isVisible() && fragment instanceof DialogFragment;
            }
        }
        return false;
    }

    static interface OSSystemConditionObserver {
        public void systemConditionChanged();
    }

    static interface OSSystemConditionHandler {
        public void removeSystemConditionObserver(@NonNull String var1, @NonNull ActivityLifecycleHandler.KeyboardListener var2);
    }
}

