/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common.services;

import com.onesignal.common.services.IServiceProvider;
import com.onesignal.common.services.ServiceRegistration;
import com.onesignal.debug.internal.logging.Logging;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0003\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000bH\u0080\b\u00a2\u0006\u0002\b\fJ\"\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0003\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\bH\u0016J\u001c\u0010\u000e\u001a\u0002H\n\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000bH\u0080\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u000e\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u0004\u0018\u0001H\n\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000bH\u0080\b\u00a2\u0006\u0004\b\u0013\u0010\u0010J#\u0010\u0012\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u0015\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000bH\u0080\b\u00a2\u0006\u0002\b\u0016J\u001c\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\bH\u0016R(\u0010\u0006\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00030\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/onesignal/common/services/ServiceProvider;", "Lcom/onesignal/common/services/IServiceProvider;", "registrations", "", "Lcom/onesignal/common/services/ServiceRegistration;", "(Ljava/util/List;)V", "_serviceMap", "", "Ljava/lang/Class;", "getAllServices", "T", "", "getAllServices$core_release", "c", "getService", "getService$core_release", "()Ljava/lang/Object;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getServiceOrNull", "getServiceOrNull$core_release", "hasService", "", "hasService$core_release", "Companion", "core_release"})
public final class ServiceProvider
implements IServiceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<Class<?>, ? extends List<? extends ServiceRegistration<?>>> _serviceMap;
    @NotNull
    private static String indent = "";

    public ServiceProvider(@NotNull List<? extends ServiceRegistration<?>> registrations) {
        Intrinsics.checkNotNullParameter(registrations, (String)"registrations");
        Map serviceMap = new LinkedHashMap();
        for (ServiceRegistration<?> reg : registrations) {
            for (Class<?> service : reg.getServices()) {
                if (!serviceMap.containsKey(service)) {
                    Map map = serviceMap;
                    Object object = new ServiceRegistration[]{reg};
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(service, object);
                    continue;
                }
                Object v = serviceMap.get(service);
                Intrinsics.checkNotNull(v);
                ((List)v).add(reg);
            }
        }
        this._serviceMap = serviceMap;
    }

    public final /* synthetic */ <T> boolean hasService$core_release() {
        boolean $i$f$hasService$core_release = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.hasService(Object.class);
    }

    public final /* synthetic */ <T> List<T> getAllServices$core_release() {
        boolean $i$f$getAllServices$core_release = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.getAllServices(Object.class);
    }

    public final /* synthetic */ <T> T getService$core_release() {
        boolean $i$f$getService$core_release = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.getService(Object.class);
    }

    public final /* synthetic */ <T> T getServiceOrNull$core_release() {
        boolean $i$f$getServiceOrNull$core_release = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.getServiceOrNull(Object.class);
    }

    @Override
    public <T> boolean hasService(@NotNull Class<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return this._serviceMap.containsKey(c);
    }

    @Override
    @NotNull
    public <T> List<T> getAllServices(@NotNull Class<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        List listOfServices = new ArrayList();
        if (this._serviceMap.containsKey(c)) {
            Map<Class<?>, List<ServiceRegistration<?>>> map = this._serviceMap;
            Intrinsics.checkNotNull(map);
            List<ServiceRegistration<?>> list = map.get(c);
            Intrinsics.checkNotNull(list);
            for (ServiceRegistration<?> serviceReg : list) {
                Object service;
                if (serviceReg.resolve(this) == null) {
                    throw new Exception("Could not instantiate service: " + serviceReg);
                }
                listOfServices.add(service);
            }
        }
        return listOfServices;
    }

    @Override
    public <T> T getService(@NotNull Class<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        T service = this.getServiceOrNull(c);
        if (service == null) {
            Logging.warn$default("Service not found: " + c, null, 2, null);
            throw new Exception("Service " + c + " could not be instantiated");
        }
        return service;
    }

    @Override
    @Nullable
    public <T> T getServiceOrNull(@NotNull Class<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Logging.debug$default(indent + "Retrieving service " + c, null, 2, null);
        List<? extends ServiceRegistration<?>> list = this._serviceMap.get(c);
        Object service = list != null && (list = (ServiceRegistration)CollectionsKt.last(list)) != null ? ((ServiceRegistration)((Object)list)).resolve(this) : null;
        return (T)service;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/onesignal/common/services/ServiceProvider$Companion;", "", "()V", "indent", "", "getIndent", "()Ljava/lang/String;", "setIndent", "(Ljava/lang/String;)V", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getIndent() {
            return indent;
        }

        public final void setIndent(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            indent = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

