/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import android.os.Bundle;
import com.onesignal.debug.internal.logging.Logging;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0004J\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0001J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/onesignal/common/JSONUtils;", "", "()V", "EXTERNAL_USER_ID", "", "bundleAsJSONObject", "Lorg/json/JSONObject;", "bundle", "Landroid/os/Bundle;", "compareJSONArrays", "", "jsonArray1", "Lorg/json/JSONArray;", "jsonArray2", "jsonStringToBundle", "data", "newStringMapFromJSONObject", "", "jsonObject", "newStringSetFromJSONArray", "", "jsonArray", "normalizeType", "object", "toUnescapedEUIDString", "json", "wrapInJsonArray", "com.onesignal.core"})
public final class JSONUtils {
    @NotNull
    public static final JSONUtils INSTANCE = new JSONUtils();
    @NotNull
    public static final String EXTERNAL_USER_ID = "external_user_id";

    private JSONUtils() {
    }

    @NotNull
    public final JSONArray wrapInJsonArray(@Nullable JSONObject jsonObject) {
        JSONArray jSONArray = new JSONArray().put((Object)jsonObject);
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"JSONArray().put(jsonObject)");
        return jSONArray;
    }

    @NotNull
    public final JSONObject bundleAsJSONObject(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                Logging.error("bundleAsJSONObject error for key: " + key, e);
            }
        }
        return json;
    }

    @Nullable
    public final Bundle jsonStringToBundle(@NotNull String data) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            JSONObject jsonObject = new JSONObject(data);
            Bundle bundle2 = new Bundle();
            Iterator iterator = jsonObject.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jsonObject.keys()");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                String key = (String)e;
                String value = jsonObject.getString(key);
                bundle2.putString(key, value);
            }
            bundle = bundle2;
        }
        catch (JSONException e) {
            e.printStackTrace();
            bundle = null;
        }
        return bundle;
    }

    @NotNull
    public final Map<String, String> newStringMapFromJSONObject(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Iterator iterator = jsonObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jsonObject.keys()");
        Iterator keys = iterator;
        Map result = new LinkedHashMap();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = jsonObject.opt(key);
                if (value instanceof JSONArray || value instanceof JSONObject) {
                    Logging.error$default("Omitting key '" + key + "'! sendTags DO NOT supported nested values!", null, 2, null);
                    continue;
                }
                if (jsonObject.isNull(key) || Intrinsics.areEqual((Object)"", (Object)value)) {
                    result.put(key, "");
                    continue;
                }
                result.put(key, value.toString());
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    @NotNull
    public final Set<String> newStringSetFromJSONArray(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        Set stringSet = new LinkedHashSet();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            String string = jsonArray.getString(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
            stringSet.add(string);
        }
        return stringSet;
    }

    @NotNull
    public final String toUnescapedEUIDString(@NotNull JSONObject json) {
        String matched;
        Pattern eidPattern;
        Matcher eidMatcher;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
        String strJsonBody = string;
        if (json.has(EXTERNAL_USER_ID) && (eidMatcher = (eidPattern = Pattern.compile("(?<=\"external_user_id\":\").*?(?=\")")).matcher(strJsonBody)).find() && (matched = eidMatcher.group(0)) != null) {
            String unescapedEID = StringsKt.replace$default((String)matched, (String)"\\/", (String)"/", (boolean)false, (int)4, null);
            unescapedEID = Matcher.quoteReplacement(unescapedEID);
            String string2 = eidMatcher.replaceAll(unescapedEID);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eidMatcher.replaceAll(unescapedEID)");
            strJsonBody = string2;
        }
        return strJsonBody;
    }

    public final boolean compareJSONArrays(@Nullable JSONArray jsonArray1, @Nullable JSONArray jsonArray2) {
        if (jsonArray1 == null && jsonArray2 == null) {
            return true;
        }
        if (jsonArray1 == null || jsonArray2 == null) {
            return false;
        }
        if (jsonArray1.length() != jsonArray2.length()) {
            return false;
        }
        try {
            int n = jsonArray1.length();
            block2: for (int i = 0; i < n; ++i) {
                int n2 = jsonArray2.length();
                for (int j = 0; j < n2; ++j) {
                    Object object = jsonArray1.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonArray1[i]");
                    Object obj1 = this.normalizeType(object);
                    Object object2 = jsonArray2.get(j);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"jsonArray2[j]");
                    Object obj2 = this.normalizeType(object2);
                    if (Intrinsics.areEqual((Object)obj1, (Object)obj2)) continue block2;
                }
                return false;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Nullable
    public final Object normalizeType(@NotNull Object object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        Class<?> clazz = object.getClass();
        if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            int it = ((Number)((Integer)object)).intValue();
            boolean bl = false;
            return (long)it;
        }
        if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            float it = ((Number)((Float)object)).floatValue();
            boolean bl = false;
            object2 = (double)it;
        } else {
            object2 = object;
        }
        return object2;
    }
}

