/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.purchases.impl;

import android.content.Context;
import com.amazon.device.iap.PurchasingListener;
import com.amazon.device.iap.PurchasingService;
import com.amazon.device.iap.model.Product;
import com.amazon.device.iap.model.ProductDataResponse;
import com.amazon.device.iap.model.PurchaseResponse;
import com.amazon.device.iap.model.PurchaseUpdatesResponse;
import com.amazon.device.iap.model.RequestId;
import com.amazon.device.iap.model.UserDataResponse;
import com.onesignal.common.threading.ThreadUtilsKt;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.operations.IOperationRepo;
import com.onesignal.core.internal.startup.IStartableService;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.user.internal.identity.IdentityModel;
import com.onesignal.user.internal.identity.IdentityModelStore;
import com.onesignal.user.internal.operations.PurchaseInfo;
import com.onesignal.user.internal.operations.TrackPurchaseOperation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0002\u001f B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/onesignal/core/internal/purchases/impl/TrackAmazonPurchase;", "Lcom/onesignal/core/internal/startup/IStartableService;", "Lcom/onesignal/core/internal/application/IApplicationLifecycleHandler;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_operationRepo", "Lcom/onesignal/core/internal/operations/IOperationRepo;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/operations/IOperationRepo;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/user/internal/identity/IdentityModelStore;)V", "canTrack", "", "listenerHandlerField", "Ljava/lang/reflect/Field;", "listenerHandlerObject", "", "osPurchasingListener", "Lcom/onesignal/core/internal/purchases/impl/TrackAmazonPurchase$OSPurchasingListener;", "registerListenerOnMainThread", "logAmazonIAPListenerError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onFocus", "firedOnSubscribe", "onUnfocused", "setListener", "start", "Companion", "OSPurchasingListener", "com.onesignal.core"})
public final class TrackAmazonPurchase
implements IStartableService,
IApplicationLifecycleHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final IOperationRepo _operationRepo;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final IdentityModelStore _identityModelStore;
    private boolean canTrack;
    @Nullable
    private OSPurchasingListener osPurchasingListener;
    @Nullable
    private Object listenerHandlerObject;
    @Nullable
    private Field listenerHandlerField;
    private boolean registerListenerOnMainThread;

    public TrackAmazonPurchase(@NotNull IApplicationService _applicationService, @NotNull IOperationRepo _operationRepo, @NotNull ConfigModelStore _configModelStore, @NotNull IdentityModelStore _identityModelStore) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_operationRepo, (String)"_operationRepo");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
        this._applicationService = _applicationService;
        this._operationRepo = _operationRepo;
        this._configModelStore = _configModelStore;
        this._identityModelStore = _identityModelStore;
    }

    @Override
    public void start() {
        if (!Companion.canTrack()) {
            return;
        }
        try {
            Class<?> listenerHandlerClass = Class.forName("com.amazon.device.iap.internal.d");
            try {
                this.listenerHandlerObject = listenerHandlerClass.getMethod("d", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NullPointerException e) {
                try {
                    this.listenerHandlerObject = listenerHandlerClass.getMethod("e", new Class[0]).invoke(null, new Object[0]);
                    this.registerListenerOnMainThread = true;
                }
                catch (NullPointerException err) {
                    this.listenerHandlerObject = listenerHandlerClass.getMethod("g", new Class[0]).invoke(null, new Object[0]);
                    this.registerListenerOnMainThread = true;
                }
            }
            Field locListenerHandlerField = listenerHandlerClass.getDeclaredField("f");
            locListenerHandlerField.setAccessible(true);
            OSPurchasingListener oSPurchasingListener = this.osPurchasingListener = new OSPurchasingListener(this._operationRepo, this._configModelStore, this._identityModelStore);
            Intrinsics.checkNotNull((Object)oSPurchasingListener);
            oSPurchasingListener.setOrgPurchasingListener((PurchasingListener)locListenerHandlerField.get(this.listenerHandlerObject));
            this.listenerHandlerField = locListenerHandlerField;
            this.canTrack = true;
            this.setListener();
        }
        catch (ClassNotFoundException e) {
            this.logAmazonIAPListenerError(e);
        }
        catch (IllegalAccessException e) {
            this.logAmazonIAPListenerError(e);
        }
        catch (InvocationTargetException e) {
            this.logAmazonIAPListenerError(e);
        }
        catch (NoSuchMethodException e) {
            this.logAmazonIAPListenerError(e);
        }
        catch (NoSuchFieldException e) {
            this.logAmazonIAPListenerError(e);
        }
        catch (ClassCastException e) {
            this.logAmazonIAPListenerError(e);
        }
        this._applicationService.addApplicationLifecycleHandler(this);
    }

    private final void logAmazonIAPListenerError(Exception e) {
        Logging.error("Error adding Amazon IAP listener.", e);
        e.printStackTrace();
    }

    @Override
    public void onFocus(boolean firedOnSubscribe) {
    }

    @Override
    public void onUnfocused() {
        if (!this.canTrack) {
            return;
        }
        try {
            Field field = this.listenerHandlerField;
            Intrinsics.checkNotNull((Object)field);
            PurchasingListener curPurchasingListener = (PurchasingListener)field.get(this.listenerHandlerObject);
            if (curPurchasingListener != this.osPurchasingListener) {
                OSPurchasingListener oSPurchasingListener = this.osPurchasingListener;
                Intrinsics.checkNotNull((Object)oSPurchasingListener);
                oSPurchasingListener.setOrgPurchasingListener(curPurchasingListener);
                this.setListener();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private final void setListener() {
        if (this.registerListenerOnMainThread) {
            ThreadUtilsKt.suspendifyOnMain((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ TrackAmazonPurchase this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PurchasingService.registerListener((Context)TrackAmazonPurchase.access$get_applicationService$p(this.this$0).getAppContext(), (PurchasingListener)TrackAmazonPurchase.access$getOsPurchasingListener$p(this.this$0));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            PurchasingService.registerListener((Context)this._applicationService.getAppContext(), (PurchasingListener)this.osPurchasingListener);
        }
    }

    public static final /* synthetic */ IApplicationService access$get_applicationService$p(TrackAmazonPurchase $this) {
        return $this._applicationService;
    }

    public static final /* synthetic */ OSPurchasingListener access$getOsPurchasingListener$p(TrackAmazonPurchase $this) {
        return $this.osPurchasingListener;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/onesignal/core/internal/purchases/impl/TrackAmazonPurchase$OSPurchasingListener;", "Lcom/amazon/device/iap/PurchasingListener;", "_operationRepo", "Lcom/onesignal/core/internal/operations/IOperationRepo;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "(Lcom/onesignal/core/internal/purchases/impl/TrackAmazonPurchase;Lcom/onesignal/core/internal/operations/IOperationRepo;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/user/internal/identity/IdentityModelStore;)V", "currentMarket", "", "lastRequestId", "Lcom/amazon/device/iap/model/RequestId;", "orgPurchasingListener", "getOrgPurchasingListener", "()Lcom/amazon/device/iap/PurchasingListener;", "setOrgPurchasingListener", "(Lcom/amazon/device/iap/PurchasingListener;)V", "marketToCurrencyCode", "market", "onProductDataResponse", "", "response", "Lcom/amazon/device/iap/model/ProductDataResponse;", "onPurchaseResponse", "Lcom/amazon/device/iap/model/PurchaseResponse;", "onPurchaseUpdatesResponse", "Lcom/amazon/device/iap/model/PurchaseUpdatesResponse;", "onUserDataResponse", "Lcom/amazon/device/iap/model/UserDataResponse;", "com.onesignal.core"})
    private final class OSPurchasingListener
    implements PurchasingListener {
        @NotNull
        private final IOperationRepo _operationRepo;
        @NotNull
        private final ConfigModelStore _configModelStore;
        @NotNull
        private final IdentityModelStore _identityModelStore;
        @Nullable
        private PurchasingListener orgPurchasingListener;
        @Nullable
        private RequestId lastRequestId;
        @Nullable
        private String currentMarket;

        public OSPurchasingListener(@NotNull IOperationRepo _operationRepo, @NotNull ConfigModelStore _configModelStore, IdentityModelStore _identityModelStore) {
            Intrinsics.checkNotNullParameter((Object)_operationRepo, (String)"_operationRepo");
            Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
            Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
            this._operationRepo = _operationRepo;
            this._configModelStore = _configModelStore;
            this._identityModelStore = _identityModelStore;
        }

        @Nullable
        public final PurchasingListener getOrgPurchasingListener() {
            return this.orgPurchasingListener;
        }

        public final void setOrgPurchasingListener(@Nullable PurchasingListener purchasingListener) {
            this.orgPurchasingListener = purchasingListener;
        }

        private final String marketToCurrencyCode(String market) {
            block31: {
                String string2 = market;
                if (string2 == null) break block31;
                int n = -1;
                switch (string2.hashCode()) {
                    case 2128: {
                        if (string2.equals("BR")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2177: {
                        if (string2.equals("DE")) {
                            n = 2;
                        }
                        break;
                    }
                    case 2100: {
                        if (string2.equals("AU")) {
                            n = 3;
                        }
                        break;
                    }
                    case 2374: {
                        if (string2.equals("JP")) {
                            n = 4;
                        }
                        break;
                    }
                    case 2267: {
                        if (string2.equals("GB")) {
                            n = 5;
                        }
                        break;
                    }
                    case 2347: {
                        if (string2.equals("IT")) {
                            n = 2;
                        }
                        break;
                    }
                    case 2252: {
                        if (string2.equals("FR")) {
                            n = 2;
                        }
                        break;
                    }
                    case 2718: {
                        if (string2.equals("US")) {
                            n = 6;
                        }
                        break;
                    }
                    case 2222: {
                        if (string2.equals("ES")) {
                            n = 2;
                        }
                        break;
                    }
                    case 2142: {
                        if (string2.equals("CA")) {
                            n = 7;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        return "USD";
                    }
                    case 5: {
                        return "GBP";
                    }
                    case 2: {
                        return "EUR";
                    }
                    case 4: {
                        return "JPY";
                    }
                    case 7: {
                        return "CDN";
                    }
                    case 1: {
                        return "BRL";
                    }
                    case 3: {
                        return "AUD";
                    }
                }
            }
            return "";
        }

        public void onProductDataResponse(@NotNull ProductDataResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (this.lastRequestId != null && Intrinsics.areEqual((Object)String.valueOf(this.lastRequestId), (Object)response.getRequestId().toString())) {
                ProductDataResponse.RequestStatus requestStatus = response.getRequestStatus();
                if ((requestStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[requestStatus.ordinal()]) == 1) {
                    List purchasesToReport = new ArrayList();
                    Map products = response.getProductData();
                    BigDecimal amountSpent = new BigDecimal(0);
                    for (String key : products.keySet()) {
                        String priceStr;
                        Product product;
                        Product product2 = product = (Product)products.get(key);
                        Intrinsics.checkNotNull((Object)product2);
                        String sku = product2.getSku();
                        String iso = this.marketToCurrencyCode(this.currentMarket);
                        String string2 = priceStr = product.getPrice();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"priceStr");
                        CharSequence charSequence = string2;
                        if (!new Regex("^[0-9]").matches(charSequence)) {
                            String string3 = priceStr;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"priceStr");
                            charSequence = string3;
                            int n = 1;
                            String string4 = ((String)charSequence).substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                            priceStr = string4;
                        }
                        BigDecimal price = new BigDecimal(priceStr);
                        Intrinsics.checkNotNullExpressionValue((Object)amountSpent.add(price), (String)"this.add(other)");
                        Intrinsics.checkNotNullExpressionValue((Object)sku, (String)"sku");
                        purchasesToReport.add(new PurchaseInfo(sku, iso, price));
                    }
                    IOperationRepo.DefaultImpls.enqueue$default(this._operationRepo, new TrackPurchaseOperation(((ConfigModel)this._configModelStore.getModel()).getAppId(), ((IdentityModel)this._identityModelStore.getModel()).getOnesignalId(), false, amountSpent, purchasesToReport), false, 2, null);
                }
            } else if (this.orgPurchasingListener != null) {
                PurchasingListener purchasingListener = this.orgPurchasingListener;
                Intrinsics.checkNotNull((Object)purchasingListener);
                purchasingListener.onProductDataResponse(response);
            }
        }

        public void onPurchaseResponse(@NotNull PurchaseResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            PurchaseResponse.RequestStatus status = response.getRequestStatus();
            if (status == PurchaseResponse.RequestStatus.SUCCESSFUL) {
                this.currentMarket = response.getUserData().getMarketplace();
                Set productSkus = new HashSet();
                String string2 = response.getReceipt().getSku();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.receipt.sku");
                productSkus.add(string2);
                this.lastRequestId = PurchasingService.getProductData((Set)productSkus);
            }
            if (this.orgPurchasingListener != null) {
                PurchasingListener purchasingListener = this.orgPurchasingListener;
                Intrinsics.checkNotNull((Object)purchasingListener);
                purchasingListener.onPurchaseResponse(response);
            }
        }

        public void onPurchaseUpdatesResponse(@NotNull PurchaseUpdatesResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (this.orgPurchasingListener != null) {
                PurchasingListener purchasingListener = this.orgPurchasingListener;
                Intrinsics.checkNotNull((Object)purchasingListener);
                purchasingListener.onPurchaseUpdatesResponse(response);
            }
        }

        public void onUserDataResponse(@NotNull UserDataResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (this.orgPurchasingListener != null) {
                PurchasingListener purchasingListener = this.orgPurchasingListener;
                Intrinsics.checkNotNull((Object)purchasingListener);
                purchasingListener.onUserDataResponse(response);
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProductDataResponse.RequestStatus.values().length];
                nArray[ProductDataResponse.RequestStatus.SUCCESSFUL.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/onesignal/core/internal/purchases/impl/TrackAmazonPurchase$Companion;", "", "()V", "canTrack", "", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canTrack() {
            try {
                Class.forName("com.amazon.device.iap.PurchasingListener");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

