/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import androidx.core.view.WindowInsetsCompat;
import com.onesignal.common.ViewUtils;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/onesignal/common/DeviceUtils;", "", "()V", "MARGIN_ERROR_PX_SIZE", "", "getCarrierName", "", "appContext", "Landroid/content/Context;", "getNetType", "(Landroid/content/Context;)Ljava/lang/Integer;", "isKeyboardUp", "", "activityWeakReference", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "com.onesignal.core"})
public final class DeviceUtils {
    @NotNull
    public static final DeviceUtils INSTANCE = new DeviceUtils();
    private static final int MARGIN_ERROR_PX_SIZE = ViewUtils.INSTANCE.dpToPx(24);

    private DeviceUtils() {
    }

    public final boolean isKeyboardUp(@NotNull WeakReference<Activity> activityWeakReference) {
        Intrinsics.checkNotNullParameter(activityWeakReference, (String)"activityWeakReference");
        DisplayMetrics metrics = new DisplayMetrics();
        Rect visibleBounds = new Rect();
        View view = null;
        boolean isOpen = false;
        if (activityWeakReference.get() != null) {
            Object t = activityWeakReference.get();
            Intrinsics.checkNotNull(t);
            Window window = ((Activity)t).getWindow();
            view = window.getDecorView();
            view.getWindowVisibleDisplayFrame(visibleBounds);
            window.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        }
        if (view != null) {
            boolean bl;
            if (Build.VERSION.SDK_INT >= 30) {
                WindowInsets imeInsets = view.getRootWindowInsets();
                bl = imeInsets.isVisible(WindowInsetsCompat.Type.ime());
            } else {
                int heightDiff = metrics.heightPixels - visibleBounds.bottom;
                bl = heightDiff > MARGIN_ERROR_PX_SIZE;
            }
            isOpen = bl;
        }
        return isOpen;
    }

    @Nullable
    public final Integer getNetType(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Object object = appContext.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        if (netInfo != null) {
            Integer n;
            int networkType = netInfo.getType();
            switch (networkType) {
                case 1: 
                case 9: {
                    n = 0;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            return n;
        }
        return null;
    }

    @Nullable
    public final String getCarrierName(@NotNull Context appContext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        try {
            Object object = appContext.getSystemService("phone");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
            TelephonyManager manager = (TelephonyManager)object;
            String carrierName = manager.getNetworkOperatorName();
            string = Intrinsics.areEqual((Object)"", (Object)carrierName) ? null : carrierName;
        }
        catch (Throwable t) {
            t.printStackTrace();
            string = null;
        }
        return string;
    }
}

