/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.session.internal.influence.impl;

import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.preferences.IPreferencesService;
import com.onesignal.session.internal.influence.InfluenceType;
import com.onesignal.session.internal.influence.impl.IInfluenceDataRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\fH\u0016J\u0010\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020\fH\u0016J\u0012\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u001bH\u0016J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR\u0014\u0010\"\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0012R\u0014\u0010$\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;", "Lcom/onesignal/session/internal/influence/impl/IInfluenceDataRepository;", "preferences", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "(Lcom/onesignal/core/internal/preferences/IPreferencesService;Lcom/onesignal/core/internal/config/ConfigModelStore;)V", "cachedNotificationOpenId", "", "getCachedNotificationOpenId", "()Ljava/lang/String;", "iamCachedInfluenceType", "Lcom/onesignal/session/internal/influence/InfluenceType;", "getIamCachedInfluenceType", "()Lcom/onesignal/session/internal/influence/InfluenceType;", "iamIndirectAttributionWindow", "", "getIamIndirectAttributionWindow", "()I", "iamLimit", "getIamLimit", "isDirectInfluenceEnabled", "", "()Z", "isIndirectInfluenceEnabled", "isUnattributedInfluenceEnabled", "lastIAMsReceivedData", "Lorg/json/JSONArray;", "getLastIAMsReceivedData", "()Lorg/json/JSONArray;", "lastNotificationsReceivedData", "getLastNotificationsReceivedData", "notificationCachedInfluenceType", "getNotificationCachedInfluenceType", "notificationIndirectAttributionWindow", "getNotificationIndirectAttributionWindow", "notificationLimit", "getNotificationLimit", "cacheIAMInfluenceType", "", "influenceType", "cacheNotificationInfluenceType", "cacheNotificationOpenId", "id", "saveIAMs", "iams", "saveNotifications", "notifications", "com.onesignal.core"})
public final class InfluenceDataRepository
implements IInfluenceDataRepository {
    @NotNull
    private final IPreferencesService preferences;
    @NotNull
    private final ConfigModelStore _configModelStore;

    public InfluenceDataRepository(@NotNull IPreferencesService preferences, @NotNull ConfigModelStore _configModelStore) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        this.preferences = preferences;
        this._configModelStore = _configModelStore;
    }

    @Override
    public void cacheNotificationInfluenceType(@NotNull InfluenceType influenceType) {
        Intrinsics.checkNotNullParameter((Object)((Object)influenceType), (String)"influenceType");
        this.preferences.saveString("OneSignal", "PREFS_OS_OUTCOMES_CURRENT_SESSION", influenceType.toString());
    }

    @Override
    @NotNull
    public InfluenceType getNotificationCachedInfluenceType() {
        String influenceType = this.preferences.getString("OneSignal", "PREFS_OS_OUTCOMES_CURRENT_SESSION", InfluenceType.UNATTRIBUTED.toString());
        return InfluenceType.Companion.fromString(influenceType);
    }

    @Override
    public void cacheIAMInfluenceType(@NotNull InfluenceType influenceType) {
        Intrinsics.checkNotNullParameter((Object)((Object)influenceType), (String)"influenceType");
        this.preferences.saveString("OneSignal", "PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE", influenceType.toString());
    }

    @Override
    @NotNull
    public InfluenceType getIamCachedInfluenceType() {
        String defaultValue = InfluenceType.UNATTRIBUTED.toString();
        String influenceType = this.preferences.getString("OneSignal", "PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE", defaultValue);
        return InfluenceType.Companion.fromString(influenceType);
    }

    @Override
    public void cacheNotificationOpenId(@Nullable String id) {
        this.preferences.saveString("OneSignal", "PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN", id);
    }

    @Override
    @Nullable
    public String getCachedNotificationOpenId() {
        return this.preferences.getString("OneSignal", "PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN", null);
    }

    @Override
    public void saveNotifications(@NotNull JSONArray notifications2) {
        Intrinsics.checkNotNullParameter((Object)notifications2, (String)"notifications");
        this.preferences.saveString("OneSignal", "PREFS_OS_LAST_NOTIFICATIONS_RECEIVED", notifications2.toString());
    }

    @Override
    public void saveIAMs(@NotNull JSONArray iams) {
        Intrinsics.checkNotNullParameter((Object)iams, (String)"iams");
        this.preferences.saveString("OneSignal", "PREFS_OS_LAST_IAMS_RECEIVED", iams.toString());
    }

    @Override
    @NotNull
    public JSONArray getLastNotificationsReceivedData() throws JSONException {
        JSONArray jSONArray;
        String notificationsReceived;
        String string2 = notificationsReceived = this.preferences.getString("OneSignal", "PREFS_OS_LAST_NOTIFICATIONS_RECEIVED", "[]");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            jSONArray = new JSONArray(it);
        } else {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    @Override
    @NotNull
    public JSONArray getLastIAMsReceivedData() throws JSONException {
        JSONArray jSONArray;
        String iamReceived;
        String string2 = iamReceived = this.preferences.getString("OneSignal", "PREFS_OS_LAST_IAMS_RECEIVED", "[]");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            jSONArray = new JSONArray(it);
        } else {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    @Override
    public int getNotificationLimit() {
        return ((ConfigModel)this._configModelStore.getModel()).getInfluenceParams().getNotificationLimit();
    }

    @Override
    public int getIamLimit() {
        return ((ConfigModel)this._configModelStore.getModel()).getInfluenceParams().getIamLimit();
    }

    @Override
    public int getNotificationIndirectAttributionWindow() {
        return ((ConfigModel)this._configModelStore.getModel()).getInfluenceParams().getIndirectNotificationAttributionWindow();
    }

    @Override
    public int getIamIndirectAttributionWindow() {
        return ((ConfigModel)this._configModelStore.getModel()).getInfluenceParams().getIndirectIAMAttributionWindow();
    }

    @Override
    public boolean isDirectInfluenceEnabled() {
        return ((ConfigModel)this._configModelStore.getModel()).getInfluenceParams().isDirectEnabled();
    }

    @Override
    public boolean isIndirectInfluenceEnabled() {
        return ((ConfigModel)this._configModelStore.getModel()).getInfluenceParams().isIndirectEnabled();
    }

    @Override
    public boolean isUnattributedInfluenceEnabled() {
        return ((ConfigModel)this._configModelStore.getModel()).getInfluenceParams().isUnattributedEnabled();
    }
}

