/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common.threading;

import com.onesignal.common.AndroidUtils;
import com.onesignal.common.threading.OneSignalDispatchers;
import com.onesignal.debug.internal.logging.Logging;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/onesignal/common/threading/CompletionAwaiter;", "", "componentName", "", "(Ljava/lang/String;)V", "latch", "Ljava/util/concurrent/CountDownLatch;", "suspendCompletion", "Lkotlinx/coroutines/CompletableDeferred;", "", "await", "", "timeoutMs", "", "awaitSuspend", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "complete", "createTimeoutMessage", "getDefaultTimeout", "logAllThreads", "Companion", "com.onesignal.core"})
public final class CompletionAwaiter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String componentName;
    @NotNull
    private final CountDownLatch latch;
    @NotNull
    private final CompletableDeferred<Unit> suspendCompletion;
    public static final long DEFAULT_TIMEOUT_MS = 30000L;
    public static final long ANDROID_ANR_TIMEOUT_MS = 4800L;

    public CompletionAwaiter(@NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        this.latch = new CountDownLatch(1);
        this.suspendCompletion = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    public /* synthetic */ CompletionAwaiter(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Component";
        }
        this(string);
    }

    public final void complete() {
        this.latch.countDown();
        this.suspendCompletion.complete((Object)Unit.INSTANCE);
    }

    public final boolean await(long timeoutMs) {
        boolean bl;
        try {
            bl = this.latch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Logging.warn("Interrupted while waiting for " + this.componentName, e);
            this.logAllThreads();
            bl = false;
        }
        boolean completed = bl;
        if (!completed) {
            String message = this.createTimeoutMessage(timeoutMs);
            Logging.warn$default(message, null, 2, null);
        }
        return completed;
    }

    public static /* synthetic */ boolean await$default(CompletionAwaiter completionAwaiter, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = completionAwaiter.getDefaultTimeout();
        }
        return completionAwaiter.await(l);
    }

    @Nullable
    public final Object awaitSuspend(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.suspendCompletion.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final long getDefaultTimeout() {
        return AndroidUtils.INSTANCE.isRunningOnMainThread() ? 4800L : 30000L;
    }

    private final String createTimeoutMessage(long timeoutMs) {
        return AndroidUtils.INSTANCE.isRunningOnMainThread() ? "Timeout waiting for " + this.componentName + " after " + timeoutMs + "ms on the main thread. This can cause ANRs. Consider calling from a background thread." : "Timeout waiting for " + this.componentName + " after " + timeoutMs + "ms.";
    }

    private final String logAllThreads() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== OneSignal Dispatchers Status ===\n");
        sb.append(OneSignalDispatchers.INSTANCE.getStatus$com_onesignal_core());
        sb.append("=== OneSignal Dispatchers Performance ===\n");
        sb.append(OneSignalDispatchers.INSTANCE.getPerformanceMetrics$com_onesignal_core());
        sb.append("\n\n");
        sb.append("=== All Threads Summary ===\n");
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread entry : threads) {
            sb.append("Thread: " + entry.getName() + " [" + (Object)((Object)entry.getState()) + "] " + (entry.isDaemon() ? "(daemon)" : "") + '\n');
        }
        sb.append("\n=== OneSignal Thread Details ===\n");
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getAllStackTraces(...)");
        for (Map.Entry entry : map.entrySet()) {
            Thread thread = (Thread)entry.getKey();
            Object[] stack = (StackTraceElement[])entry.getValue();
            String string = thread.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"OneSignal", (boolean)false, (int)2, null)) continue;
            sb.append("Thread: " + thread.getName() + " [" + (Object)((Object)thread.getState()) + "]\n");
            Intrinsics.checkNotNull((Object)stack);
            for (StackTraceElement element : ArraysKt.take((Object[])stack, (int)10)) {
                sb.append("\tat " + element + '\n');
            }
            sb.append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public CompletionAwaiter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/onesignal/common/threading/CompletionAwaiter$Companion;", "", "()V", "ANDROID_ANR_TIMEOUT_MS", "", "DEFAULT_TIMEOUT_MS", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

