/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import android.os.Bundle;
import com.onesignal.debug.internal.logging.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001J\u0010\u0010\u0010\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0004J\u001a\u0010\u0013\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0015J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0017\u001a\u00020\u0006J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\fJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u0001J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/onesignal/common/JSONUtils;", "", "()V", "EXTERNAL_USER_ID", "", "bundleAsJSONObject", "Lorg/json/JSONObject;", "bundle", "Landroid/os/Bundle;", "compareJSONArrays", "", "jsonArray1", "Lorg/json/JSONArray;", "jsonArray2", "convertToJson", "value", "isValidJsonObject", "jsonStringToBundle", "data", "mapToJson", "map", "", "newStringMapFromJSONObject", "jsonObject", "newStringSetFromJSONArray", "", "jsonArray", "normalizeType", "object", "toUnescapedEUIDString", "json", "wrapInJsonArray", "com.onesignal.core"})
@SourceDebugExtension(value={"SMAP\nJSONUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONUtils.kt\ncom/onesignal/common/JSONUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1#2:223\n1726#3,3:224\n1726#3,3:227\n766#3:230\n857#3,2:231\n1179#3,2:233\n1253#3,4:235\n1855#3,2:239\n*S KotlinDebug\n*F\n+ 1 JSONUtils.kt\ncom/onesignal/common/JSONUtils\n*L\n180#1:224,3\n181#1:227,3\n207#1:230\n207#1:231,2\n208#1:233,2\n208#1:235,4\n215#1:239,2\n*E\n"})
public final class JSONUtils {
    @NotNull
    public static final JSONUtils INSTANCE = new JSONUtils();
    @NotNull
    public static final String EXTERNAL_USER_ID = "external_user_id";

    private JSONUtils() {
    }

    @NotNull
    public final JSONArray wrapInJsonArray(@Nullable JSONObject jsonObject) {
        JSONArray jSONArray = new JSONArray().put((Object)jsonObject);
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"put(...)");
        return jSONArray;
    }

    @NotNull
    public final JSONObject bundleAsJSONObject(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                Logging.error("bundleAsJSONObject error for key: " + key, e);
            }
        }
        return json;
    }

    @Nullable
    public final Bundle jsonStringToBundle(@NotNull String data) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            JSONObject jsonObject = new JSONObject(data);
            Bundle bundle2 = new Bundle();
            Iterator iterator = jsonObject.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                String key = (String)e;
                String value = jsonObject.getString(key);
                bundle2.putString(key, value);
            }
            bundle = bundle2;
        }
        catch (JSONException e) {
            e.printStackTrace();
            bundle = null;
        }
        return bundle;
    }

    @NotNull
    public final Map<String, String> newStringMapFromJSONObject(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Iterator iterator = jsonObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator keys = iterator;
        Map result = new LinkedHashMap();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = jsonObject.opt(key);
                if (value instanceof JSONArray || value instanceof JSONObject) {
                    Logging.error$default("Omitting key '" + key + "'! sendTags DO NOT supported nested values!", null, 2, null);
                    continue;
                }
                if (jsonObject.isNull(key) || Intrinsics.areEqual((Object)"", (Object)value)) {
                    result.put(key, "");
                    continue;
                }
                result.put(key, value.toString());
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    @NotNull
    public final Set<String> newStringSetFromJSONArray(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        Set stringSet = new LinkedHashSet();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            String string = jsonArray.getString(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            stringSet.add(string);
        }
        return stringSet;
    }

    @NotNull
    public final String toUnescapedEUIDString(@NotNull JSONObject json) {
        String matched;
        Pattern eidPattern;
        Matcher eidMatcher;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String strJsonBody = string;
        if (json.has(EXTERNAL_USER_ID) && (eidMatcher = (eidPattern = Pattern.compile("(?<=\"external_user_id\":\").*?(?=\")")).matcher(strJsonBody)).find() && (matched = eidMatcher.group(0)) != null) {
            String unescapedEID = StringsKt.replace$default((String)matched, (String)"\\/", (String)"/", (boolean)false, (int)4, null);
            unescapedEID = Matcher.quoteReplacement(unescapedEID);
            String string2 = eidMatcher.replaceAll(unescapedEID);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replaceAll(...)");
            strJsonBody = string2;
        }
        return strJsonBody;
    }

    public final boolean compareJSONArrays(@Nullable JSONArray jsonArray1, @Nullable JSONArray jsonArray2) {
        if (jsonArray1 == null && jsonArray2 == null) {
            return true;
        }
        if (jsonArray1 == null || jsonArray2 == null) {
            return false;
        }
        if (jsonArray1.length() != jsonArray2.length()) {
            return false;
        }
        try {
            int n = jsonArray1.length();
            block2: for (int i = 0; i < n; ++i) {
                int n2 = jsonArray2.length();
                for (int j = 0; j < n2; ++j) {
                    Object object = jsonArray1.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    Object obj1 = this.normalizeType(object);
                    Object object2 = jsonArray2.get(j);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                    Object obj2 = this.normalizeType(object2);
                    if (Intrinsics.areEqual((Object)obj1, (Object)obj2)) continue block2;
                }
                return false;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Nullable
    public final Object normalizeType(@NotNull Object object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        Class<?> clazz = object.getClass();
        if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            int it = ((Number)((Integer)object)).intValue();
            boolean bl = false;
            return (long)it;
        }
        if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            float it = ((Number)((Float)object)).floatValue();
            boolean bl = false;
            object2 = (double)it;
        } else {
            object2 = object;
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidJsonObject(@Nullable Object value) {
        Object it;
        Object object = value;
        if (object == null) {
            return true;
        }
        boolean bl = object instanceof Boolean;
        if (bl) {
            return true;
        }
        boolean bl2 = object instanceof Number;
        if (bl2) {
            return true;
        }
        boolean bl3 = object instanceof String;
        if (bl3) {
            return true;
        }
        boolean bl4 = object instanceof JSONObject;
        if (bl4) {
            return true;
        }
        boolean bl5 = object instanceof JSONArray;
        if (bl5) {
            return true;
        }
        if (object instanceof Map) {
            Object it2;
            Object element$iv;
            Iterator iterator;
            boolean bl6;
            Iterable $this$all$iv = ((Map)value).keySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl6 = true;
            } else {
                iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    it2 = element$iv = iterator.next();
                    boolean bl7 = false;
                    if (it2 instanceof String) continue;
                    return false;
                }
                bl6 = true;
            }
            if (!bl6) return false;
            $this$all$iv = ((Map)value).values();
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                it2 = element$iv = iterator.next();
                boolean bl8 = false;
            } while (INSTANCE.isValidJsonObject(it2));
            return false;
        }
        if (!(object instanceof List)) return false;
        Iterable $this$all$iv = (Iterable)value;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return true;
            it = element$iv = iterator.next();
            boolean bl9 = false;
        } while (INSTANCE.isValidJsonObject(it));
        return false;
    }

    @NotNull
    public final JSONObject mapToJson(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        JSONObject json = new JSONObject();
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            json.put(key, this.convertToJson(value));
        }
        return json;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object convertToJson(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof Map) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = ((Map)value).entrySet();
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(it.getKey() instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                String string = (String)k;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v);
                Pair pair = TuplesKt.to((Object)string, (Object)INSTANCE.convertToJson(v));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map subMap = destination$iv$iv2;
            object = this.mapToJson(subMap);
        } else if (object2 instanceof List) {
            void var3_25;
            JSONArray array = new JSONArray();
            Iterable $this$forEach$iv = (Iterable)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Object t = it;
                Intrinsics.checkNotNull(t);
                array.put(INSTANCE.convertToJson(t));
            }
            object = var3_25;
        } else {
            object = value;
        }
        return object;
    }
}

