/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.location.internal.controller.impl;

import android.location.Location;
import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.location.internal.controller.impl.IFusedLocationApiWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/onesignal/location/internal/controller/impl/FusedLocationApiWrapperImpl;", "Lcom/onesignal/location/internal/controller/impl/IFusedLocationApiWrapper;", "()V", "cancelLocationUpdates", "", "googleApiClient", "Lcom/google/android/gms/common/api/GoogleApiClient;", "locationListener", "Lcom/google/android/gms/location/LocationListener;", "getLastLocation", "Landroid/location/Location;", "requestLocationUpdates", "locationRequest", "Lcom/google/android/gms/location/LocationRequest;", "com.onesignal.location"})
public final class FusedLocationApiWrapperImpl
implements IFusedLocationApiWrapper {
    @Override
    public void cancelLocationUpdates(@NotNull GoogleApiClient googleApiClient, @NotNull LocationListener locationListener) {
        Intrinsics.checkNotNullParameter((Object)googleApiClient, (String)"googleApiClient");
        Intrinsics.checkNotNullParameter((Object)locationListener, (String)"locationListener");
        if (googleApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(googleApiClient, locationListener);
        } else {
            Logging.warn$default((String)"GoogleApiClient is not connected. Unable to cancel location updates.", null, (int)2, null);
        }
    }

    @Override
    public void requestLocationUpdates(@NotNull GoogleApiClient googleApiClient, @NotNull LocationRequest locationRequest, @NotNull LocationListener locationListener) {
        Intrinsics.checkNotNullParameter((Object)googleApiClient, (String)"googleApiClient");
        Intrinsics.checkNotNullParameter((Object)locationRequest, (String)"locationRequest");
        Intrinsics.checkNotNullParameter((Object)locationListener, (String)"locationListener");
        try {
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            if (googleApiClient.isConnected()) {
                LocationServices.FusedLocationApi.requestLocationUpdates(googleApiClient, locationRequest, locationListener);
            }
        }
        catch (Throwable t) {
            Logging.warn((String)"FusedLocationApi.requestLocationUpdates failed!", (Throwable)t);
        }
    }

    @Override
    @Nullable
    public Location getLastLocation(@NotNull GoogleApiClient googleApiClient) {
        Intrinsics.checkNotNullParameter((Object)googleApiClient, (String)"googleApiClient");
        if (googleApiClient.isConnected()) {
            return LocationServices.FusedLocationApi.getLastLocation(googleApiClient);
        }
        return null;
    }
}

