/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.listeners;

import com.onesignal.common.modeling.ISingletonModelStoreChangeHandler;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.common.threading.ThreadUtilsKt;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.startup.IStartableService;
import com.onesignal.notifications.INotificationsManager;
import com.onesignal.notifications.IPermissionChangedHandler;
import com.onesignal.notifications.internal.channels.INotificationChannelManager;
import com.onesignal.notifications.internal.pushtoken.IPushTokenManager;
import com.onesignal.notifications.internal.pushtoken.PushTokenResponse;
import com.onesignal.user.internal.subscriptions.ISubscriptionChangedHandler;
import com.onesignal.user.internal.subscriptions.ISubscriptionManager;
import com.onesignal.user.internal.subscriptions.SubscriptionStatus;
import com.onesignal.user.subscriptions.IPushSubscription;
import com.onesignal.user.subscriptions.ISubscription;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/onesignal/notifications/internal/listeners/DeviceRegistrationListener;", "Lcom/onesignal/core/internal/startup/IStartableService;", "Lcom/onesignal/common/modeling/ISingletonModelStoreChangeHandler;", "Lcom/onesignal/core/internal/config/ConfigModel;", "Lcom/onesignal/notifications/IPermissionChangedHandler;", "Lcom/onesignal/user/internal/subscriptions/ISubscriptionChangedHandler;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_channelManager", "Lcom/onesignal/notifications/internal/channels/INotificationChannelManager;", "_pushTokenManager", "Lcom/onesignal/notifications/internal/pushtoken/IPushTokenManager;", "_notificationsManager", "Lcom/onesignal/notifications/INotificationsManager;", "_subscriptionManager", "Lcom/onesignal/user/internal/subscriptions/ISubscriptionManager;", "(Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/notifications/internal/channels/INotificationChannelManager;Lcom/onesignal/notifications/internal/pushtoken/IPushTokenManager;Lcom/onesignal/notifications/INotificationsManager;Lcom/onesignal/user/internal/subscriptions/ISubscriptionManager;)V", "onModelReplaced", "", "model", "tag", "", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "onPermissionChanged", "permission", "", "onSubscriptionAdded", "subscription", "Lcom/onesignal/user/subscriptions/ISubscription;", "onSubscriptionChanged", "onSubscriptionRemoved", "retrievePushTokenAndUpdateSubscription", "start", "notifications_release"})
public final class DeviceRegistrationListener
implements IStartableService,
ISingletonModelStoreChangeHandler<ConfigModel>,
IPermissionChangedHandler,
ISubscriptionChangedHandler {
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final INotificationChannelManager _channelManager;
    @NotNull
    private final IPushTokenManager _pushTokenManager;
    @NotNull
    private final INotificationsManager _notificationsManager;
    @NotNull
    private final ISubscriptionManager _subscriptionManager;

    public DeviceRegistrationListener(@NotNull ConfigModelStore _configModelStore, @NotNull INotificationChannelManager _channelManager, @NotNull IPushTokenManager _pushTokenManager, @NotNull INotificationsManager _notificationsManager, @NotNull ISubscriptionManager _subscriptionManager) {
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_channelManager, (String)"_channelManager");
        Intrinsics.checkNotNullParameter((Object)_pushTokenManager, (String)"_pushTokenManager");
        Intrinsics.checkNotNullParameter((Object)_notificationsManager, (String)"_notificationsManager");
        Intrinsics.checkNotNullParameter((Object)_subscriptionManager, (String)"_subscriptionManager");
        this._configModelStore = _configModelStore;
        this._channelManager = _channelManager;
        this._pushTokenManager = _pushTokenManager;
        this._notificationsManager = _notificationsManager;
        this._subscriptionManager = _subscriptionManager;
    }

    public void start() {
        this._configModelStore.subscribe((ISingletonModelStoreChangeHandler)this);
        this._notificationsManager.addPermissionChangedHandler((IPermissionChangedHandler)this);
        this._subscriptionManager.subscribe((Object)this);
        this.retrievePushTokenAndUpdateSubscription();
    }

    public void onModelReplaced(@NotNull ConfigModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!Intrinsics.areEqual((Object)tag, (Object)"HYDRATE")) {
            return;
        }
        this._channelManager.processChannelList(model.getNotificationChannels());
        this.retrievePushTokenAndUpdateSubscription();
    }

    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    public void onPermissionChanged(boolean permission) {
        this.retrievePushTokenAndUpdateSubscription();
    }

    private final void retrievePushTokenAndUpdateSubscription() {
        IPushSubscription pushSubscription = this._subscriptionManager.getSubscriptions().getPush();
        if (((CharSequence)pushSubscription.getToken()).length() > 0) {
            boolean permission = this._notificationsManager.getPermission();
            this._subscriptionManager.addOrUpdatePushSubscription(null, permission ? SubscriptionStatus.SUBSCRIBED : SubscriptionStatus.NO_PERMISSION);
        } else {
            ThreadUtilsKt.suspendifyOnThread$default((int)0, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DeviceRegistrationListener this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DeviceRegistrationListener.access$get_pushTokenManager$p(this.this$0).retrievePushToken((Continuation<? super PushTokenResponse>)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            pushTokenAndStatus = (PushTokenResponse)v0;
                            permission = DeviceRegistrationListener.access$get_notificationsManager$p(this.this$0).getPermission();
                            DeviceRegistrationListener.access$get_subscriptionManager$p(this.this$0).addOrUpdatePushSubscription(pushTokenAndStatus.getToken(), permission != false ? pushTokenAndStatus.getStatus() : SubscriptionStatus.NO_PERMISSION);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
    }

    public void onSubscriptionRemoved(@NotNull ISubscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
    }

    public void onSubscriptionAdded(@NotNull ISubscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
    }

    public void onSubscriptionChanged(@NotNull ISubscription subscription, @NotNull ModelChangedArgs args) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (Intrinsics.areEqual((Object)args.getPath(), (Object)"optedIn") && Intrinsics.areEqual((Object)args.getNewValue(), (Object)true) && !this._notificationsManager.getPermission()) {
            ThreadUtilsKt.suspendifyOnThread$default((int)0, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DeviceRegistrationListener this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DeviceRegistrationListener.access$get_notificationsManager$p(this.this$0).requestPermission(true, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
    }

    public static final /* synthetic */ IPushTokenManager access$get_pushTokenManager$p(DeviceRegistrationListener $this) {
        return $this._pushTokenManager;
    }

    public static final /* synthetic */ INotificationsManager access$get_notificationsManager$p(DeviceRegistrationListener $this) {
        return $this._notificationsManager;
    }

    public static final /* synthetic */ ISubscriptionManager access$get_subscriptionManager$p(DeviceRegistrationListener $this) {
        return $this._subscriptionManager;
    }
}

