/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.permissions.impl;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.ChecksSdkIntAtLeast;
import com.onesignal.common.AndroidUtils;
import com.onesignal.common.events.EventProducer;
import com.onesignal.common.threading.WaiterWithValue;
import com.onesignal.core.internal.application.ApplicationLifecycleHandlerBase;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.permissions.AlertDialogPrepromptForAndroidSettings;
import com.onesignal.core.internal.permissions.IRequestPermissionService;
import com.onesignal.core.internal.preferences.IPreferencesService;
import com.onesignal.notifications.R;
import com.onesignal.notifications.internal.common.NotificationHelper;
import com.onesignal.notifications.internal.permissions.INotificationPermissionChangedHandler;
import com.onesignal.notifications.internal.permissions.INotificationPermissionController;
import com.onesignal.notifications.internal.permissions.impl.NavigateToAndroidSettingsForNotifications;
import com.onesignal.notifications.internal.permissions.impl.NotificationPermissionController;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0010H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0019\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\rH\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0016\u0010\u0016\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lcom/onesignal/notifications/internal/permissions/impl/NotificationPermissionController;", "Lcom/onesignal/core/internal/permissions/IRequestPermissionService$PermissionCallback;", "Lcom/onesignal/notifications/internal/permissions/INotificationPermissionController;", "_application", "Lcom/onesignal/core/internal/application/IApplicationService;", "_requestPermission", "Lcom/onesignal/core/internal/permissions/IRequestPermissionService;", "_applicationService", "_preferenceService", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/permissions/IRequestPermissionService;Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/preferences/IPreferencesService;)V", "_events", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/notifications/internal/permissions/INotificationPermissionChangedHandler;", "_waiter", "Lcom/onesignal/common/threading/WaiterWithValue;", "", "canRequestPermission", "getCanRequestPermission", "()Z", "hasSubscribers", "getHasSubscribers", "supportsNativePrompt", "getSupportsNativePrompt", "notificationsEnabled", "onAccept", "", "onReject", "fallbackToSettings", "prompt", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showFallbackAlertDialog", "subscribe", "handler", "unsubscribe", "Companion", "notifications_release"})
public final class NotificationPermissionController
implements IRequestPermissionService.PermissionCallback,
INotificationPermissionController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _application;
    @NotNull
    private final IRequestPermissionService _requestPermission;
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final IPreferencesService _preferenceService;
    @NotNull
    private final WaiterWithValue<Boolean> _waiter;
    @NotNull
    private final EventProducer<INotificationPermissionChangedHandler> _events;
    @ChecksSdkIntAtLeast(api=33)
    private final boolean supportsNativePrompt;
    @NotNull
    private static final String PERMISSION_TYPE = "NOTIFICATION";
    @NotNull
    private static final String ANDROID_PERMISSION_STRING = "android.permission.POST_NOTIFICATIONS";

    public NotificationPermissionController(@NotNull IApplicationService _application, @NotNull IRequestPermissionService _requestPermission, @NotNull IApplicationService _applicationService, @NotNull IPreferencesService _preferenceService) {
        Intrinsics.checkNotNullParameter((Object)_application, (String)"_application");
        Intrinsics.checkNotNullParameter((Object)_requestPermission, (String)"_requestPermission");
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_preferenceService, (String)"_preferenceService");
        this._application = _application;
        this._requestPermission = _requestPermission;
        this._applicationService = _applicationService;
        this._preferenceService = _preferenceService;
        this._waiter = new WaiterWithValue();
        this._events = new EventProducer();
        this._requestPermission.registerAsCallback(PERMISSION_TYPE, (IRequestPermissionService.PermissionCallback)this);
        this.supportsNativePrompt = Build.VERSION.SDK_INT > 32 && AndroidUtils.INSTANCE.getTargetSdkVersion(this._application.getAppContext()) > 32;
    }

    @Override
    public boolean getCanRequestPermission() {
        Boolean bl = this._preferenceService.getBool("OneSignal", "USER_REJECTED_PERMISSION_android.permission.POST_NOTIFICATIONS", Boolean.valueOf(false));
        Intrinsics.checkNotNull((Object)bl);
        return bl == false;
    }

    public final boolean getSupportsNativePrompt() {
        return this.supportsNativePrompt;
    }

    @Override
    @Nullable
    public Object prompt(boolean fallbackToSettings, @NotNull Continuation<? super Boolean> $completion) {
        if (this.notificationsEnabled()) {
            return Boxing.boxBoolean((boolean)true);
        }
        if (this.supportsNativePrompt) {
            this._requestPermission.startPrompt(fallbackToSettings, PERMISSION_TYPE, ANDROID_PERMISSION_STRING, this.getClass());
        } else if (fallbackToSettings) {
            this.showFallbackAlertDialog();
        } else {
            return Boxing.boxBoolean((boolean)false);
        }
        return this._waiter.waitForWake($completion);
    }

    public void subscribe(@NotNull INotificationPermissionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._events.subscribe((Object)handler);
    }

    public void unsubscribe(@NotNull INotificationPermissionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._events.subscribe((Object)handler);
    }

    public boolean getHasSubscribers() {
        return this._events.getHasSubscribers();
    }

    public void onAccept() {
        this._waiter.wake((Object)true);
        this._events.fire((Function1)onAccept.1.INSTANCE);
    }

    public void onReject(boolean fallbackToSettings) {
        boolean fallbackShown;
        boolean bl = fallbackShown = fallbackToSettings ? this.showFallbackAlertDialog() : false;
        if (!fallbackShown) {
            this._waiter.wake((Object)false);
            this._events.fire((Function1)onReject.1.INSTANCE);
        }
    }

    private final boolean showFallbackAlertDialog() {
        Activity activity = this._application.getCurrent();
        if (activity == null) {
            return false;
        }
        Activity activity2 = activity;
        String string2 = activity2.getString(R.string.notification_permission_name_for_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026ermission_name_for_title)");
        String string3 = activity2.getString(R.string.notification_permission_settings_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026mission_settings_message)");
        AlertDialogPrepromptForAndroidSettings.INSTANCE.show(activity2, string2, string3, new AlertDialogPrepromptForAndroidSettings.Callback(this, activity2){
            final /* synthetic */ NotificationPermissionController this$0;
            final /* synthetic */ Activity $activity;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
            }

            public void onAccept() {
                NotificationPermissionController.access$get_applicationService$p(this.this$0).addApplicationLifecycleHandler((IApplicationLifecycleHandler)new ApplicationLifecycleHandlerBase(this.this$0){
                    final /* synthetic */ NotificationPermissionController this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onFocus() {
                        super.onFocus();
                        NotificationPermissionController.access$get_applicationService$p(this.this$0).removeApplicationLifecycleHandler((IApplicationLifecycleHandler)this);
                        boolean hasPermission = AndroidUtils.INSTANCE.hasPermission("android.permission.POST_NOTIFICATIONS", true, NotificationPermissionController.access$get_applicationService$p(this.this$0));
                        NotificationPermissionController.access$get_waiter$p(this.this$0).wake((Object)hasPermission);
                        NotificationPermissionController.access$get_events$p(this.this$0).fire((Function1)new Function1<INotificationPermissionChangedHandler, Unit>(hasPermission){
                            final /* synthetic */ boolean $hasPermission;
                            {
                                this.$hasPermission = $hasPermission;
                                super(1);
                            }

                            public final void invoke(@NotNull INotificationPermissionChangedHandler it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onNotificationPermissionChanged(this.$hasPermission);
                            }
                        });
                    }
                });
                NavigateToAndroidSettingsForNotifications.INSTANCE.show((Context)this.$activity);
            }

            public void onDecline() {
                NotificationPermissionController.access$get_waiter$p(this.this$0).wake((Object)false);
                NotificationPermissionController.access$get_events$p(this.this$0).fire((Function1)showFallbackAlertDialog.onDecline.1.INSTANCE);
            }
        });
        return true;
    }

    private final boolean notificationsEnabled() {
        return NotificationHelper.areNotificationsEnabled$default(NotificationHelper.INSTANCE, this._application.getAppContext(), null, 2, null);
    }

    public static final /* synthetic */ IApplicationService access$get_applicationService$p(NotificationPermissionController $this) {
        return $this._applicationService;
    }

    public static final /* synthetic */ WaiterWithValue access$get_waiter$p(NotificationPermissionController $this) {
        return $this._waiter;
    }

    public static final /* synthetic */ EventProducer access$get_events$p(NotificationPermissionController $this) {
        return $this._events;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/onesignal/notifications/internal/permissions/impl/NotificationPermissionController$Companion;", "", "()V", "ANDROID_PERMISSION_STRING", "", "PERMISSION_TYPE", "notifications_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

