/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.display.impl;

import android.R;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import com.onesignal.common.AndroidUtils;
import com.onesignal.common.JSONObjectExtensionsKt;
import com.onesignal.common.exceptions.MainThreadException;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.R;
import com.onesignal.notifications.internal.Notification;
import com.onesignal.notifications.internal.common.NotificationGenerationJob;
import com.onesignal.notifications.internal.common.NotificationHelper;
import com.onesignal.notifications.internal.display.INotificationDisplayBuilder;
import com.onesignal.notifications.internal.display.INotificationDisplayer;
import com.onesignal.notifications.internal.display.ISummaryNotificationDisplayer;
import com.onesignal.notifications.internal.display.impl.IntentGeneratorForAttachingToNotifications;
import com.onesignal.notifications.internal.display.impl.NotificationDisplayBuilder;
import com.onesignal.notifications.internal.display.impl.NotificationDisplayer;
import com.onesignal.notifications.internal.limiting.INotificationLimitManager;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001eH\u0002J*\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J\u0019\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0014\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u00020\u0017H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010.2\u0006\u00103\u001a\u00020\u0017H\u0002J\u0010\u00104\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0017H\u0002J\u0012\u00105\u001a\u00020)2\b\u00106\u001a\u0004\u0018\u00010\u0017H\u0002J!\u00107\u001a\u0004\u0018\u00010)2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u00108\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u00109J2\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020<2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u0017H\u0002J\u0019\u0010@\u001a\u00020+2\u0006\u0010 \u001a\u00020!H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Lcom/onesignal/notifications/internal/display/impl/NotificationDisplayer;", "Lcom/onesignal/notifications/internal/display/INotificationDisplayer;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_notificationLimitManager", "Lcom/onesignal/notifications/internal/limiting/INotificationLimitManager;", "_summaryNotificationDisplayer", "Lcom/onesignal/notifications/internal/display/ISummaryNotificationDisplayer;", "_notificationDisplayBuilder", "Lcom/onesignal/notifications/internal/display/INotificationDisplayBuilder;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/notifications/internal/limiting/INotificationLimitManager;Lcom/onesignal/notifications/internal/display/ISummaryNotificationDisplayer;Lcom/onesignal/notifications/internal/display/INotificationDisplayBuilder;)V", "contextResources", "Landroid/content/res/Resources;", "getContextResources", "()Landroid/content/res/Resources;", "currentContext", "Landroid/content/Context;", "getCurrentContext", "()Landroid/content/Context;", "isRunningOnMainThreadCheck", "", "()Lkotlin/Unit;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "addBackgroundImage", "fcmJson", "Lorg/json/JSONObject;", "notifBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "applyNotificationExtender", "notificationJob", "Lcom/onesignal/notifications/internal/common/NotificationGenerationJob;", "notificationBuilder", "createGenericPendingIntentsForNotif", "Landroid/app/Notification;", "intentGenerator", "Lcom/onesignal/notifications/internal/display/impl/IntentGeneratorForAttachingToNotifications;", "gcmBundle", "notificationId", "", "displayNotification", "", "(Lcom/onesignal/notifications/internal/common/NotificationGenerationJob;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBitmap", "Landroid/graphics/Bitmap;", "name", "getBitmapFromAssetsOrResourceName", "bitmapStr", "getBitmapFromURL", "location", "getDrawableId", "getResourceIcon", "iconName", "safeGetColorFromHex", "colorKey", "(Lorg/json/JSONObject;Ljava/lang/String;)Ljava/lang/Integer;", "setTextColor", "customView", "Landroid/widget/RemoteViews;", "viewId", "colorPayloadKey", "colorDefaultResource", "showNotification", "com.onesignal.notifications"})
public final class NotificationDisplayer
implements INotificationDisplayer {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final INotificationLimitManager _notificationLimitManager;
    @NotNull
    private final ISummaryNotificationDisplayer _summaryNotificationDisplayer;
    @NotNull
    private final INotificationDisplayBuilder _notificationDisplayBuilder;

    public NotificationDisplayer(@NotNull IApplicationService _applicationService, @NotNull INotificationLimitManager _notificationLimitManager, @NotNull ISummaryNotificationDisplayer _summaryNotificationDisplayer, @NotNull INotificationDisplayBuilder _notificationDisplayBuilder) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_notificationLimitManager, (String)"_notificationLimitManager");
        Intrinsics.checkNotNullParameter((Object)_summaryNotificationDisplayer, (String)"_summaryNotificationDisplayer");
        Intrinsics.checkNotNullParameter((Object)_notificationDisplayBuilder, (String)"_notificationDisplayBuilder");
        this._applicationService = _applicationService;
        this._notificationLimitManager = _notificationLimitManager;
        this._summaryNotificationDisplayer = _summaryNotificationDisplayer;
        this._notificationDisplayBuilder = _notificationDisplayBuilder;
    }

    private final Resources getContextResources() {
        return this._applicationService.getAppContext().getResources();
    }

    private final Context getCurrentContext() {
        return this._applicationService.getAppContext();
    }

    private final String getPackageName() {
        return this._applicationService.getAppContext().getPackageName();
    }

    @Override
    @Nullable
    public Object displayNotification(@NotNull NotificationGenerationJob notificationJob, @NotNull Continuation<? super Boolean> $completion) {
        this.isRunningOnMainThreadCheck();
        return this.showNotification(notificationJob, $completion);
    }

    @NotNull
    public final Unit isRunningOnMainThreadCheck() {
        if (AndroidUtils.INSTANCE.isRunningOnMainThread()) {
            throw new MainThreadException("Process for showing a notification should never been done on Main Thread!");
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object showNotification(NotificationGenerationJob var1_1, Continuation<? super Boolean> var2_2) {
        block18: {
            if (!(var2_2 instanceof showNotification.1)) ** GOTO lbl-1000
            var13_3 = var2_2;
            if ((var13_3.label & -2147483648) != 0) {
                var13_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ NotificationDisplayer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return NotificationDisplayer.access$showNotification(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    notificationId = notificationJob.getAndroidId();
                    v0 = notificationJob.getJsonPayload();
                    Intrinsics.checkNotNull((Object)v0);
                    fcmJson = v0;
                    group = JSONObjectExtensionsKt.safeString((JSONObject)fcmJson, (String)"grp");
                    intentGenerator = new IntentGeneratorForAttachingToNotifications(this.getCurrentContext());
                    grouplessNotifs = new ArrayList<E>();
                    if (Build.VERSION.SDK_INT >= 24) {
                        grouplessNotifs = NotificationHelper.INSTANCE.getActiveGrouplessNotifications(this.getCurrentContext());
                        if (group == null && grouplessNotifs.size() >= 3) {
                            group = "os_group_undefined";
                            NotificationHelper.INSTANCE.assignGrouplessNotifications(this.getCurrentContext(), grouplessNotifs);
                        }
                    }
                    oneSignalNotificationBuilder = this._notificationDisplayBuilder.getBaseOneSignalNotificationBuilder(notificationJob);
                    notifBuilder = oneSignalNotificationBuilder.getCompatBuilder();
                    this._notificationDisplayBuilder.addNotificationActionButtons(fcmJson, intentGenerator, notifBuilder, notificationId, null);
                    try {
                        this.addBackgroundImage(fcmJson, notifBuilder);
                    }
                    catch (Throwable t) {
                        Logging.error((String)"Could not set background notification image!", (Throwable)t);
                    }
                    this.applyNotificationExtender(notificationJob, notifBuilder);
                    if (notificationJob.isRestoring()) {
                        this._notificationDisplayBuilder.removeNotifyOptions(notifBuilder);
                    }
                    makeRoomFor = group == null ? 1 : 2;
                    $continuation.L$0 = this;
                    $continuation.L$1 = notificationJob;
                    $continuation.L$2 = fcmJson;
                    $continuation.L$3 = group;
                    $continuation.L$4 = intentGenerator;
                    $continuation.L$5 = grouplessNotifs;
                    $continuation.L$6 = oneSignalNotificationBuilder;
                    $continuation.L$7 = notifBuilder;
                    $continuation.I$0 = notificationId;
                    $continuation.label = 1;
                    v1 = this._notificationLimitManager.clearOldestOverLimit(makeRoomFor, (Continuation<? super Unit>)$continuation);
                    if (v1 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl63
                }
                case 1: {
                    notificationId = $continuation.I$0;
                    notifBuilder = (NotificationCompat.Builder)$continuation.L$7;
                    oneSignalNotificationBuilder = (NotificationDisplayBuilder.OneSignalNotificationBuilder)$continuation.L$6;
                    grouplessNotifs = (ArrayList<E>)$continuation.L$5;
                    intentGenerator = (IntentGeneratorForAttachingToNotifications)$continuation.L$4;
                    group = (String)$continuation.L$3;
                    fcmJson = (JSONObject)$continuation.L$2;
                    notificationJob = (NotificationGenerationJob)$continuation.L$1;
                    this = (NotificationDisplayer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl63:
                    // 2 sources

                    if (group == null) break;
                    this._summaryNotificationDisplayer.createGenericPendingIntentsForGroup(notifBuilder, intentGenerator, fcmJson, group, notificationId);
                    notification = this._summaryNotificationDisplayer.createSingleNotificationBeforeSummaryBuilder(notificationJob, notifBuilder);
                    if (Build.VERSION.SDK_INT < 24 || !Intrinsics.areEqual((Object)group, (Object)"os_group_undefined")) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = oneSignalNotificationBuilder;
                    $continuation.L$2 = notification;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.L$6 = null;
                    $continuation.L$7 = null;
                    $continuation.I$0 = notificationId;
                    $continuation.label = 2;
                    v2 = this._summaryNotificationDisplayer.createGrouplessSummaryNotification(notificationJob, intentGenerator, grouplessNotifs.size() + 1, this._notificationDisplayBuilder.getGroupAlertBehavior(), (Continuation<? super Unit>)$continuation);
                    if (v2 == var14_5) {
                        return var14_5;
                    }
                    break block18;
                }
                case 2: {
                    notificationId = $continuation.I$0;
                    notification = (android.app.Notification)$continuation.L$2;
                    oneSignalNotificationBuilder = (NotificationDisplayBuilder.OneSignalNotificationBuilder)$continuation.L$1;
                    this = (NotificationDisplayer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    break block18;
                }
            }
            $continuation.L$0 = this;
            $continuation.L$1 = oneSignalNotificationBuilder;
            $continuation.L$2 = notification;
            $continuation.L$3 = null;
            $continuation.L$4 = null;
            $continuation.L$5 = null;
            $continuation.L$6 = null;
            $continuation.L$7 = null;
            $continuation.I$0 = notificationId;
            $continuation.label = 3;
            v3 = this._summaryNotificationDisplayer.createSummaryNotification(var1_1, oneSignalNotificationBuilder, this._notificationDisplayBuilder.getGroupAlertBehavior(), (Continuation<? super Unit>)$continuation);
            if (v3 == var14_5) {
                return var14_5;
            }
            break block18;
            {
                case 3: {
                    notificationId = $continuation.I$0;
                    notification = (android.app.Notification)$continuation.L$2;
                    oneSignalNotificationBuilder = (NotificationDisplayBuilder.OneSignalNotificationBuilder)$continuation.L$1;
                    this = (NotificationDisplayer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                    break block18;
                }
            }
            notification = this.createGenericPendingIntentsForNotif(notifBuilder, intentGenerator, fcmJson, notificationId);
        }
        this._notificationDisplayBuilder.addXiaomiSettings(oneSignalNotificationBuilder, notification);
        v4 = this.getCurrentContext();
        Intrinsics.checkNotNull((Object)v4);
        NotificationManagerCompat.from((Context)v4).notify(notificationId, notification);
        if (Build.VERSION.SDK_INT >= 26) {
            v5 = this.getCurrentContext();
            Intrinsics.checkNotNull((Object)v5);
            v6 = NotificationHelper.INSTANCE.areNotificationsEnabled(v5, notification.getChannelId());
        } else {
            v6 = true;
        }
        return Boxing.boxBoolean((boolean)v6);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final android.app.Notification createGenericPendingIntentsForNotif(NotificationCompat.Builder notifBuilder, IntentGeneratorForAttachingToNotifications intentGenerator, JSONObject gcmBundle, int notificationId) {
        Random random = new SecureRandom();
        int n = random.nextInt();
        Intent intent = intentGenerator.getNewBaseIntent(notificationId).putExtra("onesignalData", gcmBundle.toString());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intentGenerator.getNewBa\u2026TA, gcmBundle.toString())");
        PendingIntent contentIntent = intentGenerator.getNewActionPendingIntent(n, intent);
        NotificationCompat.Builder builder = notifBuilder;
        Intrinsics.checkNotNull((Object)builder);
        builder.setContentIntent(contentIntent);
        PendingIntent deleteIntent = this._notificationDisplayBuilder.getNewDismissActionPendingIntent(random.nextInt(), this._notificationDisplayBuilder.getNewBaseDismissIntent(notificationId));
        notifBuilder.setDeleteIntent(deleteIntent);
        android.app.Notification notification = notifBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"notifBuilder.build()");
        return notification;
    }

    private final void applyNotificationExtender(NotificationGenerationJob notificationJob, NotificationCompat.Builder notificationBuilder) {
        if (!notificationJob.hasExtender()) {
            return;
        }
        try {
            Field mNotificationField = NotificationCompat.Builder.class.getDeclaredField("mNotification");
            mNotificationField.setAccessible(true);
            Object object = mNotificationField.get(notificationBuilder);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.Notification");
            android.app.Notification mNotification = (android.app.Notification)object;
            notificationJob.setOrgFlags(mNotification.flags);
            notificationJob.setOrgSound(mNotification.sound);
            NotificationCompat.Builder builder = notificationBuilder;
            Intrinsics.checkNotNull((Object)builder);
            Notification notification = notificationJob.getNotification();
            Intrinsics.checkNotNull((Object)notification);
            NotificationCompat.Extender extender = notification.getNotificationExtender();
            Intrinsics.checkNotNull((Object)extender);
            builder.extend(extender);
            Object object2 = mNotificationField.get(notificationBuilder);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.app.Notification");
            mNotification = (android.app.Notification)object2;
            Field mContentTextField = NotificationCompat.Builder.class.getDeclaredField("mContentText");
            mContentTextField.setAccessible(true);
            CharSequence mContentText = (CharSequence)mContentTextField.get(notificationBuilder);
            Field mContentTitleField = NotificationCompat.Builder.class.getDeclaredField("mContentTitle");
            mContentTitleField.setAccessible(true);
            CharSequence mContentTitle = (CharSequence)mContentTitleField.get(notificationBuilder);
            notificationJob.setOverriddenBodyFromExtender(mContentText);
            notificationJob.setOverriddenTitleFromExtender(mContentTitle);
            if (!notificationJob.isRestoring()) {
                notificationJob.setOverriddenFlags(mNotification.flags);
                notificationJob.setOverriddenSound(mNotification.sound);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final void addBackgroundImage(JSONObject fcmJson, NotificationCompat.Builder notifBuilder) throws Throwable {
        if (Build.VERSION.SDK_INT >= 31) {
            Logging.verbose$default((String)("Cannot use background images in notifications for device on version: " + Build.VERSION.SDK_INT), null, (int)2, null);
            return;
        }
        Bitmap bgImage = null;
        JSONObject jsonBgImage = null;
        String jsonStrBgImage = fcmJson.optString("bg_img", null);
        if (jsonStrBgImage != null) {
            jsonBgImage = new JSONObject(jsonStrBgImage);
            bgImage = this.getBitmap(jsonBgImage.optString("img", null));
        }
        if (bgImage == null) {
            bgImage = this.getBitmapFromAssetsOrResourceName("onesignal_bgimage_default_image");
        }
        if (bgImage != null) {
            Context context = this.getCurrentContext();
            Intrinsics.checkNotNull((Object)context);
            RemoteViews customView = new RemoteViews(context.getPackageName(), R.layout.onesignal_bgimage_notif_layout);
            customView.setTextViewText(R.id.os_bgimage_notif_title, this._notificationDisplayBuilder.getTitle(fcmJson));
            customView.setTextViewText(R.id.os_bgimage_notif_body, (CharSequence)fcmJson.optString("alert"));
            this.setTextColor(customView, jsonBgImage, R.id.os_bgimage_notif_title, "tc", "onesignal_bgimage_notif_title_color");
            this.setTextColor(customView, jsonBgImage, R.id.os_bgimage_notif_body, "bc", "onesignal_bgimage_notif_body_color");
            String alignSetting = null;
            if (jsonBgImage != null && jsonBgImage.has("img_align")) {
                alignSetting = jsonBgImage.getString("img_align");
            } else {
                Resources resources = this.getContextResources();
                Intrinsics.checkNotNull((Object)resources);
                int iAlignSetting = resources.getIdentifier("onesignal_bgimage_notif_image_align", "string", this.getPackageName());
                if (iAlignSetting != 0) {
                    Resources resources2 = this.getContextResources();
                    Intrinsics.checkNotNull((Object)resources2);
                    alignSetting = resources2.getString(iAlignSetting);
                }
            }
            if (Intrinsics.areEqual((Object)"right", (Object)alignSetting)) {
                customView.setViewPadding(R.id.os_bgimage_notif_bgimage_align_layout, -5000, 0, 0, 0);
                customView.setImageViewBitmap(R.id.os_bgimage_notif_bgimage_right_aligned, bgImage);
                customView.setViewVisibility(R.id.os_bgimage_notif_bgimage_right_aligned, 0);
                customView.setViewVisibility(R.id.os_bgimage_notif_bgimage, 8);
            } else {
                customView.setImageViewBitmap(R.id.os_bgimage_notif_bgimage, bgImage);
            }
            NotificationCompat.Builder builder = notifBuilder;
            Intrinsics.checkNotNull((Object)builder);
            builder.setContent(customView);
            notifBuilder.setStyle(null);
        }
    }

    private final void setTextColor(RemoteViews customView, JSONObject fcmJson, int viewId, String colorPayloadKey, String colorDefaultResource) {
        Integer color = this.safeGetColorFromHex(fcmJson, colorPayloadKey);
        if (color != null) {
            customView.setTextColor(viewId, color.intValue());
        } else {
            Resources resources = this.getContextResources();
            Intrinsics.checkNotNull((Object)resources);
            int colorId = resources.getIdentifier(colorDefaultResource, "color", this.getPackageName());
            if (colorId != 0) {
                customView.setTextColor(viewId, ContextCompat.getColor((Context)this.getCurrentContext(), (int)colorId));
            }
        }
    }

    private final Integer safeGetColorFromHex(JSONObject fcmJson, String colorKey) {
        try {
            if (fcmJson != null && fcmJson.has(colorKey)) {
                return new BigInteger(fcmJson.optString(colorKey), 16).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private final Bitmap getBitmapFromAssetsOrResourceName(String bitmapStr) {
        try {
            Bitmap bitmap = null;
            try {
                Context context = this.getCurrentContext();
                Intrinsics.checkNotNull((Object)context);
                bitmap = BitmapFactory.decodeStream((InputStream)context.getAssets().open(bitmapStr));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Bitmap bitmap2 = bitmap;
            if (bitmap2 != null) {
                return bitmap2;
            }
            String[] stringArray = new String[]{".png", ".webp", ".jpg", ".gif", ".bmp"};
            List<String> imageExtensions = Arrays.asList(stringArray);
            for (String extension : imageExtensions) {
                try {
                    Context context = this.getCurrentContext();
                    Intrinsics.checkNotNull((Object)context);
                    bitmap = BitmapFactory.decodeStream((InputStream)context.getAssets().open(bitmapStr + extension));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Bitmap bitmap3 = bitmap;
                if (bitmap3 == null) continue;
                return bitmap3;
            }
            int bitmapId = this.getResourceIcon(bitmapStr);
            if (bitmapId != 0) {
                return BitmapFactory.decodeResource((Resources)this.getContextResources(), (int)bitmapId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private final Bitmap getBitmapFromURL(String location) {
        try {
            return BitmapFactory.decodeStream((InputStream)new URL(location).openConnection().getInputStream());
        }
        catch (Throwable t) {
            Logging.warn((String)"Could not download image!", (Throwable)t);
            return null;
        }
    }

    private final Bitmap getBitmap(String name) {
        String trimmedName;
        if (name == null) {
            return null;
        }
        String $this$trim$iv = name;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return StringsKt.startsWith$default((String)(trimmedName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)trimmedName, (String)"https://", (boolean)false, (int)2, null) ? this.getBitmapFromURL(trimmedName) : this.getBitmapFromAssetsOrResourceName(name);
    }

    private final int getResourceIcon(String iconName) {
        String trimmedIconName;
        if (iconName == null) {
            return 0;
        }
        String $this$trim$iv = iconName;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (!AndroidUtils.INSTANCE.isValidResourceName(trimmedIconName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
            return 0;
        }
        int notificationIcon = this.getDrawableId(trimmedIconName);
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        try {
            return R.drawable.class.getField(iconName).getInt(null);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private final int getDrawableId(String name) {
        Resources resources = this.getContextResources();
        Intrinsics.checkNotNull((Object)resources);
        return resources.getIdentifier(name, "drawable", this.getPackageName());
    }

    public static final /* synthetic */ Object access$showNotification(NotificationDisplayer $this, NotificationGenerationJob notificationJob, Continuation $completion) {
        return $this.showNotification(notificationJob, (Continuation<? super Boolean>)$completion);
    }
}

