/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.bundle.impl;

import android.content.Context;
import android.os.Bundle;
import com.onesignal.common.JSONUtils;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.notifications.internal.bundle.INotificationBundleProcessor;
import com.onesignal.notifications.internal.common.NotificationFormatHelper;
import com.onesignal.notifications.internal.generation.INotificationGenerationWorkManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/onesignal/notifications/internal/bundle/impl/NotificationBundleProcessor;", "Lcom/onesignal/notifications/internal/bundle/INotificationBundleProcessor;", "_workManager", "Lcom/onesignal/notifications/internal/generation/INotificationGenerationWorkManager;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/notifications/internal/generation/INotificationGenerationWorkManager;Lcom/onesignal/core/internal/time/ITime;)V", "maximizeButtonsFromBundle", "", "fcmBundle", "Landroid/os/Bundle;", "processBundleFromReceiver", "Lcom/onesignal/notifications/internal/bundle/INotificationBundleProcessor$ProcessedBundleResult;", "context", "Landroid/content/Context;", "bundle", "Companion", "com.onesignal.notifications"})
public final class NotificationBundleProcessor
implements INotificationBundleProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final INotificationGenerationWorkManager _workManager;
    @NotNull
    private final ITime _time;
    @NotNull
    public static final String PUSH_ADDITIONAL_DATA_KEY = "a";
    @NotNull
    public static final String PUSH_MINIFIED_BUTTONS_LIST = "o";
    @NotNull
    public static final String PUSH_MINIFIED_BUTTON_ID = "i";
    @NotNull
    public static final String PUSH_MINIFIED_BUTTON_TEXT = "n";
    @NotNull
    public static final String PUSH_MINIFIED_BUTTON_ICON = "p";
    @NotNull
    private static final String ANDROID_NOTIFICATION_ID = "android_notif_id";
    @NotNull
    public static final String DEFAULT_ACTION = "__DEFAULT__";

    public NotificationBundleProcessor(@NotNull INotificationGenerationWorkManager _workManager, @NotNull ITime _time) {
        Intrinsics.checkNotNullParameter((Object)_workManager, (String)"_workManager");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        this._workManager = _workManager;
        this._time = _time;
    }

    private final void maximizeButtonsFromBundle(Bundle fcmBundle) {
        if (!fcmBundle.containsKey(PUSH_MINIFIED_BUTTONS_LIST)) {
            return;
        }
        try {
            JSONObject jSONObject;
            JSONObject customJSON = new JSONObject(fcmBundle.getString("custom"));
            JSONObject additionalDataJSON = null;
            if (customJSON.has(PUSH_ADDITIONAL_DATA_KEY)) {
                JSONObject jSONObject2 = customJSON.getJSONObject(PUSH_ADDITIONAL_DATA_KEY);
                Intrinsics.checkNotNull((Object)jSONObject2);
                jSONObject = jSONObject2;
            } else {
                jSONObject = new JSONObject();
            }
            additionalDataJSON = jSONObject;
            JSONArray buttons = new JSONArray(fcmBundle.getString(PUSH_MINIFIED_BUTTONS_LIST));
            fcmBundle.remove(PUSH_MINIFIED_BUTTONS_LIST);
            int n = buttons.length();
            for (int i = 0; i < n; ++i) {
                JSONObject button = buttons.getJSONObject(i);
                String buttonText = button.getString(PUSH_MINIFIED_BUTTON_TEXT);
                button.remove(PUSH_MINIFIED_BUTTON_TEXT);
                String buttonId = null;
                if (button.has(PUSH_MINIFIED_BUTTON_ID)) {
                    buttonId = button.getString(PUSH_MINIFIED_BUTTON_ID);
                    button.remove(PUSH_MINIFIED_BUTTON_ID);
                } else {
                    buttonId = buttonText;
                }
                button.put("id", (Object)buttonId);
                button.put("text", (Object)buttonText);
                if (!button.has(PUSH_MINIFIED_BUTTON_ICON)) continue;
                button.put("icon", (Object)button.getString(PUSH_MINIFIED_BUTTON_ICON));
                button.remove(PUSH_MINIFIED_BUTTON_ICON);
            }
            additionalDataJSON.put("actionButtons", (Object)buttons);
            additionalDataJSON.put("actionId", (Object)DEFAULT_ACTION);
            if (!customJSON.has(PUSH_ADDITIONAL_DATA_KEY)) {
                customJSON.put(PUSH_ADDITIONAL_DATA_KEY, (Object)additionalDataJSON);
            }
            fcmBundle.putString("custom", customJSON.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public INotificationBundleProcessor.ProcessedBundleResult processBundleFromReceiver(@NotNull Context context, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        INotificationBundleProcessor.ProcessedBundleResult bundleResult = new INotificationBundleProcessor.ProcessedBundleResult();
        if (!NotificationFormatHelper.INSTANCE.isOneSignalBundle(bundle)) {
            return bundleResult;
        }
        bundleResult.setOneSignalPayload(true);
        this.maximizeButtonsFromBundle(bundle);
        JSONObject jsonPayload = JSONUtils.INSTANCE.bundleAsJSONObject(bundle);
        long timestamp = this._time.getCurrentTimeMillis() / 1000L;
        boolean isRestoring = bundle.getBoolean("is_restoring", false);
        String string = bundle.getString("pri", "0");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        boolean isHighPriority = Integer.parseInt(string) > 9;
        String osNotificationId = NotificationFormatHelper.INSTANCE.getOSNotificationIdFromJson(jsonPayload);
        int androidNotificationId = 0;
        if (bundle.containsKey(ANDROID_NOTIFICATION_ID)) {
            androidNotificationId = bundle.getInt(ANDROID_NOTIFICATION_ID);
        }
        String string2 = osNotificationId;
        Intrinsics.checkNotNull((Object)string2);
        boolean processed = this._workManager.beginEnqueueingWork(context, string2, androidNotificationId, jsonPayload, timestamp, isRestoring, isHighPriority);
        bundleResult.setWorkManagerProcessing(processed);
        return bundleResult;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/onesignal/notifications/internal/bundle/impl/NotificationBundleProcessor$Companion;", "", "()V", "ANDROID_NOTIFICATION_ID", "", "DEFAULT_ACTION", "PUSH_ADDITIONAL_DATA_KEY", "PUSH_MINIFIED_BUTTONS_LIST", "PUSH_MINIFIED_BUTTON_ICON", "PUSH_MINIFIED_BUTTON_ID", "PUSH_MINIFIED_BUTTON_TEXT", "com.onesignal.notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

