/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.common;

import android.net.Uri;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.notifications.internal.Notification;
import com.onesignal.notifications.internal.common.NotificationHelper;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0006\u0010H\u001a\u00020\u001aJ\b\u0010I\u001a\u00020\u0012H\u0016J\f\u0010J\u001a\u00020\b*\u00020\bH\u0002R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\f\"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001e\u0010&\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0018\"\u0004\b4\u00105R\u001e\u00106\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b7\u0010(\"\u0004\b8\u0010*R\u001c\u00109\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010/\"\u0004\b;\u00101R\u001c\u0010<\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0018\"\u0004\b>\u00105R\u001e\u0010?\u001a\u0004\u0018\u00010@X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010E\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0013\u0010F\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0018\u00a8\u0006K"}, d2={"Lcom/onesignal/notifications/internal/common/NotificationGenerationJob;", "", "jsonPayload", "Lorg/json/JSONObject;", "time", "Lcom/onesignal/core/internal/time/ITime;", "(Lorg/json/JSONObject;Lcom/onesignal/core/internal/time/ITime;)V", "inNotification", "Lcom/onesignal/notifications/internal/Notification;", "(Lcom/onesignal/notifications/internal/Notification;Lorg/json/JSONObject;)V", "additionalData", "getAdditionalData", "()Lorg/json/JSONObject;", "androidId", "", "getAndroidId", "()I", "apiNotificationId", "", "getApiNotificationId", "()Ljava/lang/String;", "body", "", "getBody", "()Ljava/lang/CharSequence;", "isNotificationToDisplay", "", "()Z", "setNotificationToDisplay", "(Z)V", "isRestoring", "setRestoring", "getJsonPayload", "setJsonPayload", "(Lorg/json/JSONObject;)V", "notification", "getNotification", "()Lcom/onesignal/notifications/internal/Notification;", "orgFlags", "getOrgFlags", "()Ljava/lang/Integer;", "setOrgFlags", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "orgSound", "Landroid/net/Uri;", "getOrgSound", "()Landroid/net/Uri;", "setOrgSound", "(Landroid/net/Uri;)V", "overriddenBodyFromExtender", "getOverriddenBodyFromExtender", "setOverriddenBodyFromExtender", "(Ljava/lang/CharSequence;)V", "overriddenFlags", "getOverriddenFlags", "setOverriddenFlags", "overriddenSound", "getOverriddenSound", "setOverriddenSound", "overriddenTitleFromExtender", "getOverriddenTitleFromExtender", "setOverriddenTitleFromExtender", "shownTimeStamp", "", "getShownTimeStamp", "()Ljava/lang/Long;", "setShownTimeStamp", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "title", "getTitle", "hasExtender", "toString", "setAndroidNotificationId", "com.onesignal.notifications"})
public final class NotificationGenerationJob {
    @NotNull
    private JSONObject jsonPayload;
    @NotNull
    private final Notification notification;
    private boolean isRestoring;
    private boolean isNotificationToDisplay;
    @Nullable
    private Long shownTimeStamp;
    @Nullable
    private CharSequence overriddenBodyFromExtender;
    @Nullable
    private CharSequence overriddenTitleFromExtender;
    @Nullable
    private Uri overriddenSound;
    @Nullable
    private Integer overriddenFlags;
    @Nullable
    private Integer orgFlags;
    @Nullable
    private Uri orgSound;

    public NotificationGenerationJob(@NotNull Notification inNotification, @NotNull JSONObject jsonPayload) {
        Intrinsics.checkNotNullParameter((Object)inNotification, (String)"inNotification");
        Intrinsics.checkNotNullParameter((Object)jsonPayload, (String)"jsonPayload");
        this.jsonPayload = jsonPayload;
        this.notification = this.setAndroidNotificationId(inNotification);
    }

    @NotNull
    public final JSONObject getJsonPayload() {
        return this.jsonPayload;
    }

    public final void setJsonPayload(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"<set-?>");
        this.jsonPayload = jSONObject;
    }

    @NotNull
    public final Notification getNotification() {
        return this.notification;
    }

    private final Notification setAndroidNotificationId(Notification $this$setAndroidNotificationId) {
        Notification notification;
        Notification it = notification = $this$setAndroidNotificationId;
        boolean bl = false;
        if (it != null && !it.hasNotificationId()) {
            it.setAndroidNotificationId(new SecureRandom().nextInt());
        }
        return notification;
    }

    public final boolean isRestoring() {
        return this.isRestoring;
    }

    public final void setRestoring(boolean bl) {
        this.isRestoring = bl;
    }

    public final boolean isNotificationToDisplay() {
        return this.isNotificationToDisplay;
    }

    public final void setNotificationToDisplay(boolean bl) {
        this.isNotificationToDisplay = bl;
    }

    @Nullable
    public final Long getShownTimeStamp() {
        return this.shownTimeStamp;
    }

    public final void setShownTimeStamp(@Nullable Long l) {
        this.shownTimeStamp = l;
    }

    @Nullable
    public final CharSequence getOverriddenBodyFromExtender() {
        return this.overriddenBodyFromExtender;
    }

    public final void setOverriddenBodyFromExtender(@Nullable CharSequence charSequence) {
        this.overriddenBodyFromExtender = charSequence;
    }

    @Nullable
    public final CharSequence getOverriddenTitleFromExtender() {
        return this.overriddenTitleFromExtender;
    }

    public final void setOverriddenTitleFromExtender(@Nullable CharSequence charSequence) {
        this.overriddenTitleFromExtender = charSequence;
    }

    @Nullable
    public final Uri getOverriddenSound() {
        return this.overriddenSound;
    }

    public final void setOverriddenSound(@Nullable Uri uri) {
        this.overriddenSound = uri;
    }

    @Nullable
    public final Integer getOverriddenFlags() {
        return this.overriddenFlags;
    }

    public final void setOverriddenFlags(@Nullable Integer n) {
        this.overriddenFlags = n;
    }

    @Nullable
    public final Integer getOrgFlags() {
        return this.orgFlags;
    }

    public final void setOrgFlags(@Nullable Integer n) {
        this.orgFlags = n;
    }

    @Nullable
    public final Uri getOrgSound() {
        return this.orgSound;
    }

    public final void setOrgSound(@Nullable Uri uri) {
        this.orgSound = uri;
    }

    public NotificationGenerationJob(@NotNull JSONObject jsonPayload, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)jsonPayload, (String)"jsonPayload");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(new Notification(jsonPayload, time), jsonPayload);
    }

    @Nullable
    public final CharSequence getTitle() {
        CharSequence charSequence = this.overriddenTitleFromExtender;
        if (charSequence == null) {
            Notification notification = this.notification;
            Intrinsics.checkNotNull((Object)notification);
            charSequence = notification.getTitle();
        }
        return charSequence;
    }

    @Nullable
    public final CharSequence getBody() {
        CharSequence charSequence = this.overriddenBodyFromExtender;
        if (charSequence == null) {
            Notification notification = this.notification;
            Intrinsics.checkNotNull((Object)notification);
            charSequence = notification.getBody();
        }
        return charSequence;
    }

    @NotNull
    public final JSONObject getAdditionalData() {
        Notification notification = this.notification;
        Intrinsics.checkNotNull((Object)notification);
        JSONObject jSONObject = notification.getAdditionalData();
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    public final boolean hasExtender() {
        Notification notification = this.notification;
        Intrinsics.checkNotNull((Object)notification);
        return notification.getNotificationExtender() != null;
    }

    @NotNull
    public final String getApiNotificationId() {
        String string = NotificationHelper.INSTANCE.getNotificationIdFromFCMJson(this.jsonPayload);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final int getAndroidId() {
        Notification notification = this.notification;
        Intrinsics.checkNotNull((Object)notification);
        return notification.getAndroidNotificationId();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NotificationGenerationJob{jsonPayload=").append(this.jsonPayload).append(", isRestoring=").append(this.isRestoring).append(", isNotificationToDisplay=").append(this.isNotificationToDisplay).append(", shownTimeStamp=").append(this.shownTimeStamp).append(", overriddenBodyFromExtender=").append((Object)this.overriddenBodyFromExtender).append(", overriddenTitleFromExtender=").append((Object)this.overriddenTitleFromExtender).append(", overriddenSound=").append(this.overriddenSound).append(", overriddenFlags=").append(this.overriddenFlags).append(", orgFlags=").append(this.orgFlags).append(", orgSound=").append(this.orgSound).append(", notification=").append(this.notification).append('}');
        return stringBuilder.toString();
    }
}

