/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.util.XRLog;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfRendererBuilder
extends BaseRendererBuilder<PdfRendererBuilder> {
    private final List<AddedFont> _fonts = new ArrayList<AddedFont>();
    private OutputStream _os;
    private float _pdfVersion = 1.7f;
    private String _producer;
    private PDDocument pddocument;

    public void run() throws Exception {
        PdfBoxRenderer renderer = null;
        try {
            renderer = this.buildPdfRenderer();
            renderer.layout();
            renderer.createPDF();
        }
        finally {
            if (renderer != null) {
                renderer.close();
            }
        }
    }

    public PdfBoxRenderer buildPdfRenderer() {
        UnicodeImplementation unicode = new UnicodeImplementation(this._reorderer, this._splitter, this._lineBreaker, this._unicodeToLowerTransformer, this._unicodeToUpperTransformer, this._unicodeToTitleTransformer, this._textDirection, this._charBreaker);
        PageDimensions pageSize = new PageDimensions(this._pageWidth, this._pageHeight, this._isPageSizeInches);
        BaseDocument doc = new BaseDocument(this._baseUri, this._html, this._document, this._file, this._uri);
        PdfBoxRenderer renderer = new PdfBoxRenderer(doc, unicode, this._httpStreamFactory, this._os, this._resolver, this._cache, this._svgImpl, pageSize, this._pdfVersion, this._replacementText, this._testMode, this._objectDrawerFactory, this._preferredTransformerFactoryImplementationClass, this._preferredDocumentBuilderFactoryImplementationClass, this._producer, this._mathmlImpl, this._domMutators, this.pddocument);
        PdfBoxFontResolver resolver = renderer.getFontResolver();
        for (AddedFont font : this._fonts) {
            IdentValue fontStyle = null;
            if (font.style == BaseRendererBuilder.FontStyle.NORMAL) {
                fontStyle = IdentValue.NORMAL;
            } else if (font.style == BaseRendererBuilder.FontStyle.ITALIC) {
                fontStyle = IdentValue.ITALIC;
            } else if (font.style == BaseRendererBuilder.FontStyle.OBLIQUE) {
                fontStyle = IdentValue.OBLIQUE;
            }
            if (font.supplier != null) {
                resolver.addFont((FSSupplier<InputStream>)font.supplier, font.family, font.weight, fontStyle, font.subset);
                continue;
            }
            try {
                resolver.addFont(font.fontFile, font.family, font.weight, fontStyle, font.subset);
            }
            catch (Exception e) {
                XRLog.init((Level)Level.WARNING, (String)("Font " + font.fontFile + " could not be loaded"), (Throwable)e);
            }
        }
        return renderer;
    }

    public PdfRendererBuilder toStream(OutputStream out) {
        this._os = out;
        return this;
    }

    public PdfRendererBuilder usePdfVersion(float version) {
        this._pdfVersion = version;
        return this;
    }

    public PdfRendererBuilder usePDDocument(PDDocument doc) {
        this.pddocument = doc;
        return this;
    }

    public PdfRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily, Integer fontWeight, BaseRendererBuilder.FontStyle fontStyle, boolean subset) {
        this._fonts.add(new AddedFont(supplier, null, fontWeight, fontFamily, subset, fontStyle));
        return this;
    }

    public PdfRendererBuilder useFont(FSSupplier<InputStream> supplier, String fontFamily) {
        return this.useFont(supplier, fontFamily, (Integer)400, BaseRendererBuilder.FontStyle.NORMAL, true);
    }

    public PdfRendererBuilder useFont(File fontFile, String fontFamily, Integer fontWeight, BaseRendererBuilder.FontStyle fontStyle, boolean subset) {
        this._fonts.add(new AddedFont(null, fontFile, fontWeight, fontFamily, subset, fontStyle));
        return this;
    }

    public PdfRendererBuilder useFont(File fontFile, String fontFamily) {
        return this.useFont(fontFile, fontFamily, (Integer)400, BaseRendererBuilder.FontStyle.NORMAL, true);
    }

    public PdfRendererBuilder withProducer(String producer) {
        this._producer = producer;
        return this;
    }

    private static class AddedFont {
        private final FSSupplier<InputStream> supplier;
        private final File fontFile;
        private final Integer weight;
        private final String family;
        private final boolean subset;
        private final BaseRendererBuilder.FontStyle style;

        private AddedFont(FSSupplier<InputStream> supplier, File fontFile, Integer weight, String family, boolean subset, BaseRendererBuilder.FontStyle style) {
            this.supplier = supplier;
            this.fontFile = fontFile;
            this.weight = weight;
            this.family = family;
            this.subset = subset;
            this.style = style;
        }
    }
}

