/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import oracle.ons.BodyElement;
import oracle.ons.BodySegment;

public class BodyBlock {
    private static final byte Body_Begin = 0;
    private static final byte Body_Segment = 1;
    private static final byte Body_Element = 2;
    private static final byte Body_Unknown = 3;
    private static final int Length_Size = 2;
    private static final int Rec_Header_Size = 3;
    private static final int Dat_Header_Size = 2;
    private static final int Body_Sign_Size = 12;
    private static final byte[] Body_Sign = new byte[]{0, -93, 124, 8, -25, 120, -18, 36, 95, -45, -74, 78};
    private BodySegment rootSeg = new BodySegment("root", -1);
    private List segList = this.rootSeg.getSegmentList();

    public byte[] generateBody() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Iterator segIterator = null;
        buffer.write(Body_Sign, 0, Body_Sign.length);
        segIterator = this.segList.iterator();
        while (segIterator.hasNext()) {
            try {
                BodyBlock.encodeSegment(buffer, (BodySegment)segIterator.next(), 0);
            }
            catch (IOException e) {
                return null;
            }
        }
        byte[] body = buffer.toByteArray();
        return body;
    }

    private static void encodeSegment(OutputStream out, BodySegment seg, int level) throws IOException {
        BodyElement elt2 = null;
        out.write(1);
        BodyBlock.writeLength(out, seg.getNameLength() + 1);
        out.write(seg.getName().getBytes(), 0, seg.getNameLength());
        out.write(0);
        out.write(level);
        for (BodyElement elt2 : seg.getElementList()) {
            out.write(2);
            BodyBlock.writeLength(out, elt2.getNameLength());
            out.write(elt2.getName().getBytes(), 0, elt2.getNameLength());
            out.write(0);
            BodyBlock.writeLength(out, elt2.getValueLength());
            out.write(elt2.getValue().getBytes(), 0, elt2.getValueLength());
            out.write(0);
        }
        Iterator segIterator = seg.getSegmentList().iterator();
        while (segIterator.hasNext()) {
            BodyBlock.encodeSegment(out, (BodySegment)segIterator.next(), level + 1);
        }
    }

    public static BodyBlock generateBodyBlock(byte[] body) {
        BodyBlock blk = null;
        Object seg = null;
        Object elt = null;
        Object str = null;
        int pos = 0;
        boolean len = false;
        if (body == null || body.length < 12) {
            return null;
        }
        int remain = body.length;
        --pos;
        ++remain;
        while (true) {
            if (body[++pos] != 0 && --remain >= 12) {
                continue;
            }
            if (remain < 12) {
                return null;
            }
            if (BodyBlock.bytesCmp(body, Body_Sign, pos, 12)) break;
        }
        blk = new BodyBlock();
        ByteArrayInputStream bb = new ByteArrayInputStream(body, pos += 12, remain -= 12);
        try {
            int type = ((InputStream)bb).read();
            if (type == -1) {
                throw new IllegalArgumentException("Notification missing data");
            }
            BodySegment bs = BodyBlock.readSegment(bb);
            BodyBlock.generateSegment(bb, blk.rootSeg, bs);
        }
        catch (IOException e) {
            return null;
        }
        return blk;
    }

    private static BodySegment generateSegment(InputStream bb, BodySegment segParent, BodySegment segChild) throws IOException {
        BodySegment segCur = segChild;
        while (segCur.getLevel() == segParent.getLevel() + 1) {
            segParent.addSegment(segCur);
            int type = bb.read();
            while (type == 2) {
                BodyElement elem = BodyBlock.readElement(bb);
                segCur.addElement(elem);
                type = bb.read();
            }
            if (type == -1) break;
            BodySegment segPrev = segCur;
            segCur = BodyBlock.readSegment(bb);
            if (segCur == null) {
                return null;
            }
            if (segCur.getLevel() <= segParent.getLevel() + 1) continue;
            segCur = BodyBlock.generateSegment(bb, segPrev, segCur);
        }
        return segCur;
    }

    private static BodySegment readSegment(InputStream bb) throws IOException {
        int level;
        int len = BodyBlock.getLength(bb);
        byte[] name = BodyBlock.getIdentifier(bb, len);
        if (name[len - 1] == 0) {
            --len;
        }
        if ((level = bb.read()) == -1) {
            throw new IllegalArgumentException("Notification missing data");
        }
        String segmentName = new String(name, 0, len);
        return new BodySegment(segmentName, level);
    }

    private static BodyElement readElement(InputStream bb) throws IOException {
        int len = BodyBlock.getLength(bb);
        byte[] ident = BodyBlock.getIdentifier(bb, len);
        String nameStr = new String(ident);
        BodyBlock.eatNullByte(bb);
        len = BodyBlock.getLength(bb);
        ident = BodyBlock.getIdentifier(bb, len);
        String valueStr = new String(ident);
        BodyBlock.eatNullByte(bb);
        return new BodyElement(nameStr, valueStr);
    }

    public void putBodyElement(String segName, String eltName, String eltValue) {
        BodySegment bodySegment = null;
        BodyElement bodyElement = null;
        Iterator iterator = null;
        iterator = this.segList.iterator();
        while (iterator.hasNext() && ((bodySegment = (BodySegment)iterator.next()).getNameLength() != segName.length() || !bodySegment.getName().equals(segName))) {
            bodySegment = null;
        }
        if (bodySegment == null) {
            bodySegment = new BodySegment(segName);
            if (bodySegment == null) {
                return;
            }
            this.segList.add(bodySegment);
        }
        if ((bodyElement = new BodyElement(eltName, eltValue)) == null) {
            return;
        }
        bodySegment.addElement(bodyElement);
    }

    public String getBodyElementValue(String segName, String eltName) {
        BodySegment bodySegment = null;
        Iterator iterator = null;
        iterator = this.segList.iterator();
        while (iterator.hasNext() && ((bodySegment = (BodySegment)iterator.next()).getNameLength() != segName.length() || !bodySegment.getName().equals(segName))) {
            bodySegment = null;
        }
        if (bodySegment == null) {
            return null;
        }
        return bodySegment.getElementValue(eltName);
    }

    public List getSegmentList() {
        return this.segList;
    }

    public void addSegment(BodySegment seg) {
        if (seg == null) {
            return;
        }
        this.segList.add(seg);
    }

    public List getElementList(String segName) {
        BodySegment bodySegment = null;
        Iterator iterator = null;
        iterator = this.segList.iterator();
        while (iterator.hasNext() && ((bodySegment = (BodySegment)iterator.next()).getNameLength() != segName.length() || !bodySegment.getName().equals(segName))) {
            bodySegment = null;
        }
        if (bodySegment == null) {
            return null;
        }
        return bodySegment.getElementList();
    }

    public void putOldSegment(String segData) {
    }

    public static void writeLength(OutputStream buffer, int length) throws IOException {
        buffer.write((byte)(length >>> 8));
        buffer.write((byte)length);
    }

    public static int getLength(InputStream buffer) throws IOException {
        int byte1 = buffer.read();
        int byte2 = buffer.read();
        if (byte1 == -1 || byte2 == -1) {
            throw new IllegalArgumentException("Notification missing data");
        }
        return (byte1 << 8) + byte2;
    }

    public static boolean bytesCmp(byte[] src, byte[] dest, int pos, int len) {
        int i = pos;
        for (int j = 0; j < len; ++j) {
            if (src[i] != dest[j]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static byte[] getIdentifier(InputStream s, int len) throws IOException {
        byte[] identifier = new byte[len];
        int nb = s.read(identifier, 0, len);
        if (nb != len) {
            throw new IllegalArgumentException("Notification missing data");
        }
        return identifier;
    }

    private static void eatNullByte(InputStream s) throws IOException {
        int nullbyte = s.read();
        if (nullbyte != 0) {
            throw new IllegalArgumentException("Notification bad data");
        }
    }
}

