/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import oracle.ons.Connection;
import oracle.ons.InputBuffer;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.SubscriptionNotification;

public class ReceiverThread
extends Thread {
    private ONS oems;
    private Connection connection;
    private boolean shutdown = false;
    private Socket s;
    private String id;
    private static byte[] connectmessage3 = new String("POST /connect HTTP/1.1\r\nVersion: 3\r\nFormFactor: ").getBytes();
    private static byte[] connectmessage = new String("POST /connect HTTP/1.1\r\nVersion: 4\r\nFormFactor: ").getBytes();
    private static byte[] selfid = new String("\r\nSelfId: java; Home=").getBytes();
    private static byte[] endconnect = new String("\r\n\r\n").getBytes();

    protected ReceiverThread(ONS o, Connection co) {
        this.setDaemon(true);
        this.oems = o;
        this.connection = co;
        this.s = null;
        this.connection.setClientReceiver(this);
        this.id = new String("ReceiverThread[" + this.connection.getId() + "]");
    }

    private boolean establishConnection() {
        Socket sock;
        try {
            sock = this.connection.connect();
        }
        catch (SocketTimeoutException stoe) {
            if (ONS.debug) {
                ONS.errstream.println(this.id + "::establishConnection ==> connection timeout");
            }
            return true;
        }
        if (sock == null) {
            if (ONS.debug) {
                ONS.errstream.println(this.id + "::establishConnection ==> failed to establish connection");
            }
            return false;
        }
        boolean timeout = false;
        try {
            int serverVersion;
            OutputStream ostr = sock.getOutputStream();
            OutputBuffer obuf = new OutputBuffer(ostr);
            if (this.connection.getServerVersion() == 3) {
                obuf.putBytes(connectmessage3, connectmessage3.length);
            } else {
                obuf.putBytes(connectmessage, connectmessage.length);
            }
            if (ONS.localConn) {
                obuf.putString(this.oems.getFormFactor(this.oems.oraclehome));
            }
            obuf.putBytes(selfid, selfid.length);
            obuf.putString(this.oems.oraclehome);
            obuf.putBytes(endconnect, endconnect.length);
            obuf.flush();
            InputBuffer ibuf = new InputBuffer(new BufferedInputStream(sock.getInputStream()));
            ibuf.getNextString();
            String v = ibuf.getNextString();
            if (v.charAt(0) != 'V' || v.charAt(1) != 'e' || v.charAt(2) != 'r' || v.charAt(3) != 's' || v.charAt(4) != 'i' || v.charAt(5) != 'o' || v.charAt(6) != 'n') {
                ONS.errstream.println(this.id + ": unexpected server version string: " + v);
                sock.close();
                return false;
            }
            try {
                serverVersion = Integer.parseInt(v.substring(9, 10));
            }
            catch (NumberFormatException e) {
                ONS.errstream.println(this.id + ": failed to parse server version number: '" + v.substring(9, 10) + "'");
                sock.close();
                return false;
            }
            if (serverVersion != this.connection.getServerVersion()) {
                this.connection.setServerVersion(serverVersion);
                sock.close();
                return false;
            }
            ibuf.getNextString();
            ibuf.getNextString();
            ibuf.getNextString();
            ibuf.getNextString();
            ibuf.skipBytes(Notification.clusteridheader.length);
            this.oems.clusterid = ibuf.getNextString();
            ibuf.skipBytes(Notification.clusternameheader.length);
            this.oems.clustername = ibuf.getNextString();
            ibuf.skipBytes(Notification.instanceidheader.length);
            this.oems.instanceid = ibuf.getNextString();
            ibuf.skipBytes(Notification.instancenameheader.length);
            this.oems.instancename = ibuf.getNextString();
            ibuf.getNextString();
        }
        catch (SocketTimeoutException stoe) {
            if (ONS.debug) {
                ONS.errstream.println(this.id + "::establishConnection ==> timeout reading InputStream");
                stoe.printStackTrace(ONS.errstream);
            }
            try {
                sock.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            sock = null;
            timeout = true;
        }
        catch (IOException e) {
            if (ONS.debug) {
                ONS.errstream.println(this.id + "::establishConnection ==> exception reading InputStream");
                e.printStackTrace(ONS.errstream);
            }
            try {
                sock.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            sock = null;
        }
        if (sock != null) {
            if (!ONS.localConn) {
                this.connection.sender.flushSenderQueue();
            }
            this.connection.setClientSocket(sock);
            this.s = sock;
            this.oems.resendSubscriptions(this.connection.sender);
            this.connection.sender.quiescent(false);
        }
        return timeout;
    }

    public void run() {
        SubscriptionNotification se = null;
        InputStream istr = null;
        InputBuffer ibuf = null;
        boolean pingServer = false;
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::run ==> start");
        }
        if (!ONS.localConn) {
            if (ONS.remoteIOtimeout != 0) {
                se = new SubscriptionNotification(99, "(", false);
            }
        }
        block9: while (!this.shutdown) {
            if (this.s != null) {
                try {
                    istr = this.s.getInputStream();
                    ibuf = new InputBuffer(istr);
                }
                catch (Exception e) {
                    if (ONS.debug) {
                        ONS.errstream.println(this.id + "::run ==> exception getting InputStream");
                        e.printStackTrace(ONS.errstream);
                    }
                    return;
                }
            }
            while (!this.shutdown && this.s != null) {
                String line;
                try {
                    line = ibuf.getNextString();
                    if (pingServer) {
                        pingServer = false;
                    }
                    if (ONS.debug) {
                        ONS.outstream.println(this.id + "::run ==> getNextString: line=" + line);
                    }
                    if (line == null || line.charAt(0) != 'P' || line.charAt(1) != 'O' || line.charAt(2) != 'S' || line.charAt(3) != 'T' || line.charAt(4) != ' ') {
                        if (!ONS.debug) continue;
                        ONS.errstream.println(this.id + "::run ==> unexpected message syntax");
                        continue;
                    }
                }
                catch (SocketTimeoutException stoe) {
                    if (pingServer || se == null) {
                        if (ONS.debug) {
                            ONS.errstream.println(this.id + "::run ==> timeout reading from InputStream");
                            stoe.printStackTrace(ONS.errstream);
                        }
                        this.s = null;
                        line = null;
                        this.connection.closeClientSocket();
                    } else {
                        if (ONS.debug) {
                            ONS.outstream.println(this.id + "::run ==> ping server");
                        }
                        pingServer = true;
                        line = null;
                        this.connection.sender.send(se);
                    }
                }
                catch (IOException e) {
                    if (ONS.debug) {
                        ONS.errstream.println(this.id + "::run ==> exception reading InputStream");
                        e.printStackTrace(ONS.errstream);
                    }
                    this.s = null;
                    line = null;
                    this.connection.closeClientSocket();
                }
                if (line == null) continue;
                if (line.charAt(6) == 'e' && line.charAt(7) == 'v' && line.charAt(8) == 'e' && line.charAt(9) == 'n' && line.charAt(10) == 't') {
                    Notification ev = this.readNotificationMessage(ibuf);
                    if (ONS.debug) {
                        ONS.outstream.println(this.id + "::run ==> event:\n" + ev);
                    }
                    if (ev != null) {
                        if (ONS.debug) {
                            ONS.outstream.println(this.id + "::run ==> deliver event");
                        }
                        this.oems.deliver(ev);
                        continue;
                    }
                    this.s = null;
                    this.connection.closeClientSocket();
                    continue;
                }
                if (line.charAt(6) == 's' && line.charAt(7) == 't' && line.charAt(8) == 'a' && line.charAt(9) == 't' && line.charAt(10) == 'u' && line.charAt(11) == 's') {
                    if (this.readStatusMessage(ibuf)) continue;
                    this.s = null;
                    continue;
                }
                if (line.charAt(6) == 'q' && line.charAt(7) == 'u' && line.charAt(8) == 'i' && line.charAt(9) == 'e' && line.charAt(10) == 's' && line.charAt(11) == 'c') {
                    while (line != null) {
                        try {
                            line = ibuf.getNextString();
                        }
                        catch (IOException e) {
                            if (ONS.debug) {
                                ONS.errstream.println(this.id + "::run ==> exception reading InputStream (quiescent)");
                                e.printStackTrace(ONS.errstream);
                            }
                            this.s = null;
                            line = null;
                            this.connection.closeClientSocket();
                        }
                    }
                    this.connection.sender.quiescent(true);
                    continue;
                }
                if (!ONS.debug) continue;
                ONS.outstream.println(this.id + "::run ==> unknown message: " + line);
            }
            pingServer = false;
            int errors = 0;
            int check = 0;
            long sleeptime = 1000L;
            while (this.s == null && !this.shutdown) {
                if (this.establishConnection()) {
                    check = 5000;
                } else if (sleeptime == 1000L && this.connection.getServerVersion() == 3) {
                    sleeptime = 0L;
                    continue;
                }
                if (this.s != null) continue;
                if (check >= 5000) {
                    check = 0;
                    this.oems.checkConnections(this.connection);
                    if (this.shutdown) {
                        if (!ONS.debug) continue block9;
                        ONS.outstream.println(this.id + "::run ==> replaced: shutting down");
                        continue block9;
                    }
                }
                check = (int)((long)check + sleeptime);
                try {
                    ReceiverThread.sleep(sleeptime);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (++errors <= 30 || sleeptime >= 5000L) continue;
                sleeptime += 1000L;
            }
        }
        if (ONS.debug) {
            ONS.outstream.println(this.id + "::run ==> stop");
        }
    }

    protected void shutdown() {
        block3: {
            if (ONS.debug) {
                ONS.outstream.println(this.id + "::shutdown");
            }
            this.shutdown = true;
            this.connection.closeClientSocket();
            try {
                this.interrupt();
            }
            catch (Exception e) {
                if (!ONS.debug) break block3;
                ONS.errstream.println(this.id + "::shutdown ==> exception interrupting thread");
                e.printStackTrace(ONS.errstream);
            }
        }
    }

    private boolean readStatusMessage(InputBuffer ibuf) {
        boolean ret = true;
        int subscriptionid = -1;
        boolean success = false;
        String message = null;
        try {
            String line = ibuf.getNextString();
            while (line != null) {
                int colon = line.indexOf(58);
                if (colon != -1) {
                    String headername = line.substring(0, colon);
                    String headervalue = line.substring(colon + 2);
                    if (headername.equalsIgnoreCase("result")) {
                        success = headervalue.equalsIgnoreCase("success");
                    } else if (headername.equalsIgnoreCase("subscriberid")) {
                        try {
                            subscriptionid = Integer.parseInt(headervalue);
                        }
                        catch (NumberFormatException e) {
                            if (ONS.debug) {
                                ONS.errstream.println(this.id + "::readStatusMessage ==> invalid subscriberid: " + headervalue);
                                e.printStackTrace(ONS.errstream);
                            }
                            subscriptionid = -1;
                        }
                    } else if (headername.equalsIgnoreCase("message")) {
                        message = headervalue;
                    }
                }
                line = ibuf.getNextString();
            }
        }
        catch (IOException e) {
            ret = false;
        }
        if (subscriptionid == -1) {
            ret = false;
        }
        if (ret && subscriptionid != 99) {
            this.oems.handleSubscriptionReply(subscriptionid, success, message);
        } else if (ONS.debug && subscriptionid == 99) {
            ONS.outstream.println(this.id + "::readStatusMessage ==> got server ping response");
        }
        return ret;
    }

    private Notification readNotificationMessage(InputBuffer ibuf) {
        Notification ev;
        try {
            ev = new Notification(ibuf);
        }
        catch (IOException e) {
            if (ONS.debug) {
                ONS.errstream.println(this.id + "::readNotificationMessage ==> Exception occurred");
                e.printStackTrace(ONS.errstream);
            }
            ev = null;
        }
        return ev;
    }
}

