/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.InstanceSet;

class DestinationMap {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final NavigableMap<Integer, InstanceSet> instsPerPriority = new TreeMap<Integer, InstanceSet>((o1, o2) -> o1 - o2);
    private final Map<ServiceMember, Integer> priorityPerInstance = new HashMap<ServiceMember, Integer>();
    private final AtomicReference<Set<ServiceMember>> allInstancesSnapshot = new AtomicReference<Set<ServiceMember>>(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityPerInstance.keySet())));
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    DestinationMap() {
    }

    void add(ServiceMember inst, int priority) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.instsPerPriority.computeIfAbsent(priority, p -> new InstanceSet()).add(inst);
            this.priorityPerInstance.put(inst, priority);
            this.allInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityPerInstance.keySet())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            Integer priority = this.priorityPerInstance.remove(inst);
            if (null != priority) {
                InstanceSet insts = this.instsPerPriority.getOrDefault(priority, InstanceSet.EMPTY);
                insts.remove(inst);
            }
            this.allInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityPerInstance.keySet())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    InstanceSet getHighestPriorityInstances() {
        this.rLock.lock();
        try {
            InstanceSet instanceSet = this.instsPerPriority.isEmpty() ? new InstanceSet() : this.instsPerPriority.firstEntry().getValue();
            return instanceSet;
        }
        finally {
            this.rLock.unlock();
        }
    }

    boolean contains(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            boolean bl = this.priorityPerInstance.containsKey(inst);
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    int getPriority(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            int n = this.priorityPerInstance.getOrDefault(inst, -1);
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    Set<ServiceMember> allInstances() {
        return this.allInstancesSnapshot.get();
    }

    static {
        try {
            $$$methodRef$$$8 = DestinationMap.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = DestinationMap.class.getDeclaredMethod("lambda$new$0", Integer.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = DestinationMap.class.getDeclaredMethod("lambda$add$1", Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = DestinationMap.class.getDeclaredMethod("allInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = DestinationMap.class.getDeclaredMethod("getPriority", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = DestinationMap.class.getDeclaredMethod("contains", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = DestinationMap.class.getDeclaredMethod("getHighestPriorityInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = DestinationMap.class.getDeclaredMethod("remove", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = DestinationMap.class.getDeclaredMethod("add", ServiceMember.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

