/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import com.otaliastudios.zoom.AbsolutePoint;
import com.otaliastudios.zoom.Alignment;
import com.otaliastudios.zoom.OverPanRangeProvider;
import com.otaliastudios.zoom.OverZoomRangeProvider;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomApi;
import com.otaliastudios.zoom.ZoomLogger;
import com.otaliastudios.zoom.internal.StateController;
import com.otaliastudios.zoom.internal.UpdatesDispatcher;
import com.otaliastudios.zoom.internal.gestures.PinchDetector;
import com.otaliastudios.zoom.internal.gestures.ScrollFlingDetector;
import com.otaliastudios.zoom.internal.matrix.MatrixController;
import com.otaliastudios.zoom.internal.matrix.MatrixUpdate;
import com.otaliastudios.zoom.internal.movement.PanManager;
import com.otaliastudios.zoom.internal.movement.ZoomManager;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u0000 \u009e\u00012\u00020\u0001:\b\u009d\u0001\u009e\u0001\u009f\u0001\u00a0\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010M\u001a\u00020N2\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010O\u001a\u00020PH\u0016J\u0006\u0010Q\u001a\u00020NJ\u0006\u0010R\u001a\u00020CJ\u0006\u0010S\u001a\u00020CJ\u0010\u0010T\u001a\u00020C2\u0006\u0010U\u001a\u00020CH\u0003J\b\u0010V\u001a\u000207H\u0002J\b\u0010W\u001a\u00020\u000eH\u0002J\u0006\u0010X\u001a\u00020CJ\u0006\u0010Y\u001a\u00020CJ\b\u0010Z\u001a\u00020\u000eH\u0016J\b\u0010[\u001a\u00020CH\u0016J\b\u0010\\\u001a\u00020\u000eH\u0016J\b\u0010]\u001a\u00020CH\u0016J(\u0010^\u001a\u00020N2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020PH\u0016J\u001f\u0010b\u001a\u00020N2\b\u0010E\u001a\u0004\u0018\u00010\u000e2\u0006\u0010a\u001a\u00020PH\u0016\u00a2\u0006\u0002\u0010cJ\u000e\u0010d\u001a\u00020P2\u0006\u0010e\u001a\u00020fJ\u000e\u0010g\u001a\u00020P2\u0006\u0010e\u001a\u00020fJ \u0010h\u001a\u00020N2\u0006\u0010i\u001a\u00020\u000e2\u0006\u0010j\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020PH\u0016J \u0010k\u001a\u00020N2\u0006\u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020PH\u0016J\u0018\u0010l\u001a\u00020N2\u0006\u00103\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020PH\u0016J\u000e\u0010m\u001a\u00020N2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010n\u001a\u00020N2\u0006\u0010o\u001a\u00020CH\u0016J\u0010\u0010p\u001a\u00020N2\u0006\u0010q\u001a\u00020PH\u0016J\u0010\u0010r\u001a\u00020N2\u0006\u0010s\u001a\u00020tH\u0016J\u000e\u0010u\u001a\u00020N2\u0006\u0010\u0004\u001a\u00020\u0005J\"\u0010v\u001a\u00020N2\u0006\u0010w\u001a\u00020\u000e2\u0006\u0010x\u001a\u00020\u000e2\b\b\u0002\u0010y\u001a\u00020PH\u0007J\u0010\u0010z\u001a\u00020N2\u0006\u0010{\u001a\u00020|H\u0007J\"\u0010z\u001a\u00020N2\u0006\u0010w\u001a\u00020\u000e2\u0006\u0010x\u001a\u00020\u000e2\b\b\u0002\u0010y\u001a\u00020PH\u0007J\u0010\u0010}\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u0010\u0010\u007f\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u001b\u0010\u0080\u0001\u001a\u00020N2\u0007\u0010\u0081\u0001\u001a\u00020\u000e2\u0007\u0010\u0082\u0001\u001a\u00020CH\u0016J\u001b\u0010\u0083\u0001\u001a\u00020N2\u0007\u0010\u0084\u0001\u001a\u00020\u000e2\u0007\u0010\u0082\u0001\u001a\u00020CH\u0016J\u0011\u0010\u0085\u0001\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u0013\u0010\u0086\u0001\u001a\u00020N2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0016J\u0012\u0010\u0089\u0001\u001a\u00020N2\u0007\u0010\u008a\u0001\u001a\u00020PH\u0016J\u0012\u0010\u008b\u0001\u001a\u00020N2\u0007\u0010\u008c\u0001\u001a\u00020PH\u0016J\u0012\u0010\u008d\u0001\u001a\u00020N2\u0007\u0010\u008c\u0001\u001a\u00020PH\u0016J\u0013\u0010\u008e\u0001\u001a\u00020N2\b\u0010\u0087\u0001\u001a\u00030\u008f\u0001H\u0016J\u0011\u0010\u0090\u0001\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u0011\u0010\u0091\u0001\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u001b\u0010\u0092\u0001\u001a\u00020N2\u0007\u0010\u0093\u0001\u001a\u00020C2\u0007\u0010\u0094\u0001\u001a\u00020CH\u0016J\u0011\u0010\u0095\u0001\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u0011\u0010\u0096\u0001\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u0011\u0010\u0097\u0001\u001a\u00020N2\u0006\u0010~\u001a\u00020PH\u0016J\u001a\u0010\u0098\u0001\u001a\u00020N2\u0007\u0010\u0099\u0001\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020PH\u0016J\t\u0010\u009a\u0001\u001a\u00020NH\u0016J\t\u0010\u009b\u0001\u001a\u00020NH\u0016J\u0019\u0010\u009c\u0001\u001a\u00020N2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020PH\u0016R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0010R\u0017\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0010R\u0014\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u0015R\u0017\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0015\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010\u0015R\u001a\u0010+\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010\u0015\u001a\u0004\b-\u0010\u0010R\u001a\u0010.\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010\u0015\u001a\u0004\b0\u0010\u0010R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010\u0015\u001a\u0004\b5\u0010\u0010R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0010R\u0014\u0010<\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0010R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010E\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\bF\u0010\u0015\u001a\u0004\bG\u0010\u0010R\u001a\u0010H\u001a\u00020IX\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bJ\u0010\u0015\u001a\u0004\bK\u0010L\u00a8\u0006\u00a1\u0001"}, d2={"Lcom/otaliastudios/zoom/ZoomEngine;", "Lcom/otaliastudios/zoom/ZoomApi;", "context", "Landroid/content/Context;", "container", "Landroid/view/View;", "(Landroid/content/Context;Landroid/view/View;)V", "listener", "Lcom/otaliastudios/zoom/ZoomEngine$Listener;", "(Landroid/content/Context;Landroid/view/View;Lcom/otaliastudios/zoom/ZoomEngine$Listener;)V", "(Landroid/content/Context;)V", "callbacks", "Lcom/otaliastudios/zoom/ZoomEngine$Callbacks;", "containerHeight", "", "getContainerHeight", "()F", "containerWidth", "getContainerWidth", "contentHeight", "getContentHeight$annotations", "()V", "getContentHeight", "contentWidth", "getContentWidth$annotations", "getContentWidth", "dispatcher", "Lcom/otaliastudios/zoom/internal/UpdatesDispatcher;", "getDispatcher$annotations", "matrix", "Landroid/graphics/Matrix;", "getMatrix$annotations", "getMatrix", "()Landroid/graphics/Matrix;", "matrixController", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController;", "pan", "Lcom/otaliastudios/zoom/AbsolutePoint;", "getPan", "()Lcom/otaliastudios/zoom/AbsolutePoint;", "panManager", "Lcom/otaliastudios/zoom/internal/movement/PanManager;", "getPanManager$annotations", "panX", "getPanX$annotations", "getPanX", "panY", "getPanY$annotations", "getPanY", "pinchDetector", "Lcom/otaliastudios/zoom/internal/gestures/PinchDetector;", "realZoom", "getRealZoom$annotations", "getRealZoom", "scaledPan", "Lcom/otaliastudios/zoom/ScaledPoint;", "getScaledPan", "()Lcom/otaliastudios/zoom/ScaledPoint;", "scaledPanX", "getScaledPanX", "scaledPanY", "getScaledPanY", "scrollFlingDetector", "Lcom/otaliastudios/zoom/internal/gestures/ScrollFlingDetector;", "stateController", "Lcom/otaliastudios/zoom/internal/StateController;", "transformationGravity", "", "transformationType", "zoom", "getZoom$annotations", "getZoom", "zoomManager", "Lcom/otaliastudios/zoom/internal/movement/ZoomManager;", "getZoomManager$library_release$annotations", "getZoomManager$library_release", "()Lcom/otaliastudios/zoom/internal/movement/ZoomManager;", "addListener", "", "cancelAnimations", "", "clear", "computeHorizontalScrollOffset", "computeHorizontalScrollRange", "computeTransformationGravity", "input", "computeTransformationPan", "computeTransformationZoom", "computeVerticalScrollOffset", "computeVerticalScrollRange", "getMaxZoom", "getMaxZoomType", "getMinZoom", "getMinZoomType", "moveTo", "x", "y", "animate", "moveToCenter", "(Ljava/lang/Float;Z)V", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onTouchEvent", "panBy", "dx", "dy", "panTo", "realZoomTo", "removeListener", "setAlignment", "alignment", "setAllowFlingInOverscroll", "allow", "setAnimationDuration", "duration", "", "setContainer", "setContainerSize", "width", "height", "applyTransformation", "setContentSize", "rect", "Landroid/graphics/RectF;", "setFlingEnabled", "enabled", "setHorizontalPanEnabled", "setMaxZoom", "maxZoom", "type", "setMinZoom", "minZoom", "setOneFingerScrollEnabled", "setOverPanRange", "provider", "Lcom/otaliastudios/zoom/OverPanRangeProvider;", "setOverPinchable", "overPinchable", "setOverScrollHorizontal", "overScroll", "setOverScrollVertical", "setOverZoomRange", "Lcom/otaliastudios/zoom/OverZoomRangeProvider;", "setScrollEnabled", "setThreeFingersScrollEnabled", "setTransformation", "transformation", "gravity", "setTwoFingersScrollEnabled", "setVerticalPanEnabled", "setZoomEnabled", "zoomBy", "zoomFactor", "zoomIn", "zoomOut", "zoomTo", "Callbacks", "Companion", "Listener", "SimpleListener", "library_release"})
public class ZoomEngine
implements ZoomApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int transformationType;
    private int transformationGravity;
    private View container;
    @NotNull
    private final Callbacks callbacks;
    @NotNull
    private final UpdatesDispatcher dispatcher;
    @NotNull
    private final StateController stateController;
    @NotNull
    private final PanManager panManager;
    @NotNull
    private final ZoomManager zoomManager;
    @NotNull
    private final MatrixController matrixController;
    @NotNull
    private final ScrollFlingDetector scrollFlingDetector;
    @NotNull
    private final PinchDetector pinchDetector;
    public static final long DEFAULT_ANIMATION_DURATION = 280L;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;

    public ZoomEngine(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.callbacks = new Callbacks();
        this.dispatcher = new UpdatesDispatcher(this);
        this.stateController = new StateController(this.callbacks);
        this.panManager = new PanManager(this, (Function0<MatrixController>)((Function0)new Function0<MatrixController>(this){
            final /* synthetic */ ZoomEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MatrixController invoke() {
                return ZoomEngine.access$getMatrixController$p(this.this$0);
            }
        }));
        this.zoomManager = new ZoomManager(this, (Function0<MatrixController>)((Function0)new Function0<MatrixController>(this){
            final /* synthetic */ ZoomEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MatrixController invoke() {
                return ZoomEngine.access$getMatrixController$p(this.this$0);
            }
        }));
        this.matrixController = new MatrixController(this.zoomManager, this.panManager, this.stateController, this.callbacks);
        this.scrollFlingDetector = new ScrollFlingDetector(context, this.panManager, this.stateController, this.matrixController);
        this.pinchDetector = new PinchDetector(context, this.zoomManager, this.panManager, this.stateController, this.matrixController);
    }

    public ZoomEngine(@NotNull Context context, @NotNull View container) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this(context);
        this.setContainer(container);
    }

    @Deprecated(message="Use [addListener] to add a listener.", replaceWith=@ReplaceWith(expression="constructor(context, container)", imports={}))
    public ZoomEngine(@NotNull Context context, @NotNull View container, @NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this(context, container);
        this.addListener(listener);
    }

    private static /* synthetic */ void getDispatcher$annotations() {
    }

    private static /* synthetic */ void getPanManager$annotations() {
    }

    @NotNull
    public final ZoomManager getZoomManager$library_release() {
        return this.zoomManager;
    }

    public static /* synthetic */ void getZoomManager$library_release$annotations() {
    }

    @Override
    public float getRealZoom() {
        return this.matrixController.getZoom$library_release();
    }

    public static /* synthetic */ void getRealZoom$annotations() {
    }

    @Override
    @NotNull
    public AbsolutePoint getPan() {
        return AbsolutePoint.copy$default(this.matrixController.getPan$library_release(), 0.0f, 0.0f, 3, null);
    }

    @Override
    public float getPanX() {
        return this.matrixController.getPanX$library_release();
    }

    public static /* synthetic */ void getPanX$annotations() {
    }

    @Override
    public float getPanY() {
        return this.matrixController.getPanY$library_release();
    }

    public static /* synthetic */ void getPanY$annotations() {
    }

    @Override
    @NotNull
    public ScaledPoint getScaledPan() {
        return ScaledPoint.copy$default(this.matrixController.getScaledPan$library_release(), 0.0f, 0.0f, 3, null);
    }

    @Override
    public float getScaledPanX() {
        return this.matrixController.getScaledPanX$library_release();
    }

    @Override
    public float getScaledPanY() {
        return this.matrixController.getScaledPanY$library_release();
    }

    @NotNull
    public final Matrix getMatrix() {
        return this.matrixController.getMatrix$library_release();
    }

    public static /* synthetic */ void getMatrix$annotations() {
    }

    public final float getContentWidth() {
        return this.matrixController.getContentWidth$library_release();
    }

    public static /* synthetic */ void getContentWidth$annotations() {
    }

    public final float getContentHeight() {
        return this.matrixController.getContentHeight$library_release();
    }

    public static /* synthetic */ void getContentHeight$annotations() {
    }

    public final float getContainerWidth() {
        return this.matrixController.getContainerWidth$library_release();
    }

    public final float getContainerHeight() {
        return this.matrixController.getContainerHeight$library_release();
    }

    @Override
    public float getZoom() {
        return this.zoomManager.realZoomToZoom$library_release(this.getRealZoom());
    }

    public static /* synthetic */ void getZoom$annotations() {
    }

    public final void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (this.container == null) {
            String string = "container is not initialized.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.dispatcher.addListener$library_release(listener);
    }

    public final void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dispatcher.removeListener$library_release(listener);
    }

    @Override
    public void setOverScrollHorizontal(boolean overScroll) {
        this.panManager.setHorizontalOverPanEnabled$library_release(overScroll);
    }

    @Override
    public void setOverScrollVertical(boolean overScroll) {
        this.panManager.setVerticalOverPanEnabled$library_release(overScroll);
    }

    @Override
    public void setOverPanRange(@NotNull OverPanRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.panManager.setOverPanRangeProvider$library_release(provider);
    }

    @Override
    public void setHorizontalPanEnabled(boolean enabled) {
        this.panManager.setHorizontalPanEnabled$library_release(enabled);
    }

    @Override
    public void setVerticalPanEnabled(boolean enabled) {
        this.panManager.setVerticalPanEnabled$library_release(enabled);
    }

    @Override
    public void setOverPinchable(boolean overPinchable) {
        this.zoomManager.setOverEnabled(overPinchable);
    }

    @Override
    public void setOverZoomRange(@NotNull OverZoomRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.zoomManager.setOverZoomRangeProvider$library_release(provider);
    }

    @Override
    public void setZoomEnabled(boolean enabled) {
        this.zoomManager.setEnabled(enabled);
    }

    @Override
    public void setFlingEnabled(boolean enabled) {
        this.scrollFlingDetector.setFlingEnabled$library_release(enabled);
    }

    @Override
    public void setScrollEnabled(boolean enabled) {
        this.scrollFlingDetector.setScrollEnabled$library_release(enabled);
    }

    @Override
    public void setOneFingerScrollEnabled(boolean enabled) {
        this.scrollFlingDetector.setOneFingerScrollEnabled$library_release(enabled);
    }

    @Override
    public void setTwoFingersScrollEnabled(boolean enabled) {
        this.scrollFlingDetector.setTwoFingersScrollEnabled$library_release(enabled);
    }

    @Override
    public void setThreeFingersScrollEnabled(boolean enabled) {
        this.scrollFlingDetector.setThreeFingersScrollEnabled$library_release(enabled);
    }

    @Override
    public void setAllowFlingInOverscroll(boolean allow) {
        this.scrollFlingDetector.setFlingInOverPanEnabled$library_release(allow);
    }

    @Override
    public void setTransformation(int transformation, int gravity) {
        this.transformationType = transformation;
        this.transformationGravity = gravity;
    }

    @Override
    public void setAlignment(int alignment) {
        this.panManager.setAlignment$library_release(alignment);
    }

    public final void setContainer(@NotNull View container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (this.container != null) {
            String string = "container already set";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.container = container;
        View view = this.container;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
            throw null;
        }
        view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(this){
            final /* synthetic */ ZoomEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public void onViewAttachedToWindow(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)ZoomEngine.access$getCallbacks$p(this.this$0));
            }

            public void onViewDetachedFromWindow(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)ZoomEngine.access$getCallbacks$p(this.this$0));
            }
        });
    }

    @Deprecated(message="Deprecated in favor of not using RectF class", replaceWith=@ReplaceWith(expression="setContentSize(width, height)", imports={}))
    public final void setContentSize(@NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        ZoomEngine.setContentSize$default(this, rect.width(), rect.height(), false, 4, null);
    }

    @JvmOverloads
    public final void setContentSize(float width, float height, boolean applyTransformation) {
        this.matrixController.setContentSize$library_release(width, height, applyTransformation);
    }

    public static /* synthetic */ void setContentSize$default(ZoomEngine zoomEngine, float f, float f2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setContentSize");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        zoomEngine.setContentSize(f, f2, bl);
    }

    @JvmOverloads
    public final void setContainerSize(float width, float height, boolean applyTransformation) {
        this.matrixController.setContainerSize$library_release(width, height, applyTransformation);
    }

    public static /* synthetic */ void setContainerSize$default(ZoomEngine zoomEngine, float f, float f2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setContainerSize");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        zoomEngine.setContainerSize(f, f2, bl);
    }

    public final void clear() {
        this.zoomManager.clear();
        this.panManager.clear();
        this.matrixController.clear$library_release();
    }

    private final float computeTransformationZoom() {
        int n = this.transformationType;
        switch (n) {
            case 0: {
                float scaleX = this.getContainerWidth() / this.getContentWidth();
                float scaleY = this.getContainerHeight() / this.getContentHeight();
                Object[] objectArray = new Object[]{"computeTransformationZoom", "centerInside", "scaleX:", Float.valueOf(scaleX), "scaleY:", Float.valueOf(scaleY)};
                LOG.v$library_release(objectArray);
                boolean bl = false;
                return Math.min(scaleX, scaleY);
            }
            case 1: {
                float scaleX = this.getContainerWidth() / this.getContentWidth();
                float scaleY = this.getContainerHeight() / this.getContentHeight();
                Object[] objectArray = new Object[]{"computeTransformationZoom", "centerCrop", "scaleX:", Float.valueOf(scaleX), "scaleY:", Float.valueOf(scaleY)};
                LOG.v$library_release(objectArray);
                boolean bl = false;
                return Math.max(scaleX, scaleY);
            }
            case 2: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    private final ScaledPoint computeTransformationPan() {
        float extraWidth = this.getContentWidth() * this.getRealZoom() - this.getContainerWidth();
        float extraHeight = this.getContentHeight() * this.getRealZoom() - this.getContainerHeight();
        int gravity = this.computeTransformationGravity(this.transformationGravity);
        float x = -this.panManager.applyGravity$library_release(gravity, extraWidth, true);
        float y = -this.panManager.applyGravity$library_release(gravity, extraHeight, false);
        return new ScaledPoint(x, y);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private final int computeTransformationGravity(int input) {
        int n = input;
        if (n == 0) {
            int horizontal = Alignment.INSTANCE.toHorizontalGravity$library_release(this.panManager.getAlignment$library_release(), 1);
            int vertical = Alignment.INSTANCE.toVerticalGravity$library_release(this.panManager.getAlignment$library_release(), 16);
            return horizontal | vertical;
        }
        return input;
    }

    public final boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.stateController.onInterceptTouchEvent$library_release(ev);
    }

    public final boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.stateController.onTouchEvent$library_release(ev);
    }

    @Override
    public void moveTo(float zoom, float x, float y, boolean animate) {
        float realZoom = this.zoomManager.zoomToRealZoom$library_release(zoom);
        MatrixUpdate update2 = MatrixUpdate.Companion.obtain$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(realZoom, x, y){
            final /* synthetic */ float $realZoom;
            final /* synthetic */ float $x;
            final /* synthetic */ float $y;
            {
                this.$realZoom = $realZoom;
                this.$x = $x;
                this.$y = $y;
                super(1);
            }

            public final void invoke(@NotNull MatrixUpdate.Builder $this$obtain) {
                Intrinsics.checkNotNullParameter((Object)$this$obtain, (String)"$this$obtain");
                $this$obtain.zoomTo$library_release(this.$realZoom, false);
                $this$obtain.panTo$library_release(new AbsolutePoint(this.$x, this.$y), false);
            }
        }));
        if (animate) {
            this.matrixController.animateUpdate$library_release(update2);
        } else {
            this.cancelAnimations();
            this.matrixController.applyUpdate$library_release(update2);
        }
    }

    @Override
    public void moveToCenter(@Nullable Float zoom, boolean animate) {
        Float f = zoom;
        Float f2 = f == null ? null : Float.valueOf(RangesKt.coerceIn((float)f.floatValue(), (float)this.zoomManager.realZoomToZoom$library_release(this.zoomManager.getMinZoom$library_release()), (float)this.zoomManager.realZoomToZoom$library_release(this.zoomManager.getMaxZoom$library_release())));
        float targetZoom = f2 == null ? this.getZoom() : f2.floatValue();
        float targetRealZoom = this.zoomManager.zoomToRealZoom$library_release(targetZoom);
        float zoomLayoutCenterX = this.getContainerWidth() / targetRealZoom / 2.0f;
        float zoomLayoutCenterY = this.getContainerHeight() / targetRealZoom / 2.0f;
        float contentCenterX = this.getContentWidth() / 2.0f;
        float contentCenterY = this.getContentHeight() / 2.0f;
        float diffX = contentCenterX - zoomLayoutCenterX;
        float diffY = contentCenterY - zoomLayoutCenterY;
        this.moveTo(targetZoom, -diffX, -diffY, animate);
    }

    @Override
    public void panTo(float x, float y, boolean animate) {
        this.panBy(x - this.getPanX(), y - this.getPanY(), animate);
    }

    @Override
    public void panBy(float dx, float dy, boolean animate) {
        MatrixUpdate update2 = MatrixUpdate.Companion.obtain$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(dx, dy){
            final /* synthetic */ float $dx;
            final /* synthetic */ float $dy;
            {
                this.$dx = $dx;
                this.$dy = $dy;
                super(1);
            }

            public final void invoke(@NotNull MatrixUpdate.Builder $this$obtain) {
                Intrinsics.checkNotNullParameter((Object)$this$obtain, (String)"$this$obtain");
                $this$obtain.panBy$library_release(new AbsolutePoint(this.$dx, this.$dy), false);
            }
        }));
        if (animate) {
            this.matrixController.animateUpdate$library_release(update2);
        } else {
            this.cancelAnimations();
            this.matrixController.applyUpdate$library_release(update2);
        }
    }

    @Override
    public void zoomTo(float zoom, boolean animate) {
        float realZoom = this.zoomManager.zoomToRealZoom$library_release(zoom);
        this.realZoomTo(realZoom, animate);
    }

    @Override
    public void zoomBy(float zoomFactor, boolean animate) {
        float newZoom = this.getZoom() * zoomFactor;
        this.zoomTo(newZoom, animate);
    }

    @Override
    public void zoomIn() {
        this.zoomBy(1.3f, true);
    }

    @Override
    public void zoomOut() {
        this.zoomBy(0.7f, true);
    }

    @Override
    public void realZoomTo(float realZoom, boolean animate) {
        MatrixUpdate update2 = MatrixUpdate.Companion.obtain$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(realZoom){
            final /* synthetic */ float $realZoom;
            {
                this.$realZoom = $realZoom;
                super(1);
            }

            public final void invoke(@NotNull MatrixUpdate.Builder $this$obtain) {
                Intrinsics.checkNotNullParameter((Object)$this$obtain, (String)"$this$obtain");
                $this$obtain.zoomTo$library_release(this.$realZoom, false);
            }
        }));
        if (animate) {
            this.matrixController.animateUpdate$library_release(update2);
        } else {
            this.cancelAnimations();
            this.matrixController.applyUpdate$library_release(update2);
        }
    }

    @Override
    public float getMaxZoom() {
        return this.zoomManager.getMaxZoom();
    }

    @Override
    public int getMaxZoomType() {
        return this.zoomManager.getMaxZoomMode();
    }

    @Override
    public void setMaxZoom(float maxZoom, int type) {
        this.zoomManager.setMaxZoom$library_release(maxZoom, type);
        if (this.getZoom() > this.zoomManager.getMaxZoom$library_release()) {
            this.realZoomTo(this.zoomManager.getMaxZoom$library_release(), true);
        }
    }

    @Override
    public float getMinZoom() {
        return this.zoomManager.getMinZoom();
    }

    @Override
    public int getMinZoomType() {
        return this.zoomManager.getMinZoomMode();
    }

    @Override
    public void setMinZoom(float minZoom, int type) {
        this.zoomManager.setMinZoom$library_release(minZoom, type);
        if (this.getRealZoom() <= this.zoomManager.getMinZoom$library_release()) {
            this.realZoomTo(this.zoomManager.getMinZoom$library_release(), true);
        }
    }

    @Override
    public void setAnimationDuration(long duration) {
        this.matrixController.setAnimationDuration$library_release(duration);
    }

    @Override
    public boolean cancelAnimations() {
        if (this.stateController.isFlinging$library_release()) {
            this.scrollFlingDetector.cancelFling$library_release();
            return true;
        }
        if (this.stateController.isAnimating$library_release()) {
            this.stateController.makeIdle$library_release();
            return true;
        }
        return false;
    }

    public final int computeHorizontalScrollOffset() {
        return (int)(-this.matrixController.getScaledPanX$library_release());
    }

    public final int computeHorizontalScrollRange() {
        return (int)this.matrixController.getContentScaledWidth$library_release();
    }

    public final int computeVerticalScrollOffset() {
        return (int)(-this.matrixController.getScaledPanY$library_release());
    }

    public final int computeVerticalScrollRange() {
        return (int)this.matrixController.getContentScaledHeight$library_release();
    }

    @Override
    public void setMaxZoom(float maxZoom) {
        ZoomApi.DefaultImpls.setMaxZoom(this, maxZoom);
    }

    @Override
    public void setMinZoom(float minZoom) {
        ZoomApi.DefaultImpls.setMinZoom(this, minZoom);
    }

    @Override
    public void setTransformation(int transformation) {
        ZoomApi.DefaultImpls.setTransformation(this, transformation);
    }

    @JvmOverloads
    public final void setContentSize(float width, float height) {
        ZoomEngine.setContentSize$default(this, width, height, false, 4, null);
    }

    @JvmOverloads
    public final void setContainerSize(float width, float height) {
        ZoomEngine.setContainerSize$default(this, width, height, false, 4, null);
    }

    public static final /* synthetic */ Callbacks access$getCallbacks$p(ZoomEngine $this) {
        return $this.callbacks;
    }

    static {
        String string = TAG = ZoomEngine.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/otaliastudios/zoom/ZoomEngine$Callbacks;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "Lcom/otaliastudios/zoom/internal/StateController$Callback;", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController$Callback;", "(Lcom/otaliastudios/zoom/ZoomEngine;)V", "cleanupState", "", "oldState", "", "endScrollGesture", "isStateAllowed", "", "newState", "maybeStartPinchGesture", "event", "Landroid/view/MotionEvent;", "maybeStartScrollFlingGesture", "onGlobalLayout", "onMatrixSizeChanged", "oldZoom", "", "firstTime", "onMatrixUpdate", "onStateIdle", "post", "action", "Ljava/lang/Runnable;", "postOnAnimation", "library_release"})
    private final class Callbacks
    implements ViewTreeObserver.OnGlobalLayoutListener,
    StateController.Callback,
    MatrixController.Callback {
        public Callbacks() {
            Intrinsics.checkNotNullParameter((Object)ZoomEngine.this, (String)"this$0");
        }

        public void onGlobalLayout() {
            View view = ZoomEngine.this.container;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"container");
                throw null;
            }
            float f = view.getWidth();
            view = ZoomEngine.this.container;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"container");
                throw null;
            }
            ZoomEngine.setContainerSize$default(ZoomEngine.this, f, view.getHeight(), false, 4, null);
        }

        @Override
        public boolean post(@NotNull Runnable action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            View view = ZoomEngine.this.container;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"container");
                throw null;
            }
            return view.post(action);
        }

        @Override
        public void postOnAnimation(@NotNull Runnable action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            View view = ZoomEngine.this.container;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"container");
                throw null;
            }
            view.postOnAnimation(action);
        }

        @Override
        public void onMatrixUpdate() {
            ZoomEngine.this.dispatcher.dispatchOnMatrix$library_release();
        }

        @Override
        public void onMatrixSizeChanged(float oldZoom, boolean firstTime) {
            Object[] objectArray = new Object[]{"onMatrixSizeChanged: firstTime:", firstTime, "oldZoom:", Float.valueOf(oldZoom), "transformation:", ZoomEngine.this.transformationType, "transformationZoom:", Float.valueOf(ZoomEngine.this.getZoomManager$library_release().getTransformationZoom$library_release())};
            LOG.w$library_release(objectArray);
            ZoomEngine.this.stateController.makeIdle$library_release();
            if (firstTime) {
                ZoomEngine.this.getZoomManager$library_release().setTransformationZoom$library_release(ZoomEngine.this.computeTransformationZoom());
                ZoomEngine.this.matrixController.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(ZoomEngine.this){
                    final /* synthetic */ ZoomEngine this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                        $this$applyUpdate.zoomTo$library_release(this.this$0.getZoomManager$library_release().getTransformationZoom$library_release(), false);
                        $this$applyUpdate.setNotify$library_release(false);
                    }
                }));
                ScaledPoint newPan = ZoomEngine.this.computeTransformationPan();
                ZoomEngine.this.matrixController.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(newPan){
                    final /* synthetic */ ScaledPoint $newPan;
                    {
                        this.$newPan = $newPan;
                        super(1);
                    }

                    public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                        $this$applyUpdate.panTo$library_release(this.$newPan, false);
                    }
                }));
            } else {
                ZoomEngine.this.getZoomManager$library_release().setTransformationZoom$library_release(ZoomEngine.this.computeTransformationZoom());
                ZoomEngine.this.matrixController.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(ZoomEngine.this){
                    final /* synthetic */ ZoomEngine this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                        $this$applyUpdate.zoomTo$library_release(this.this$0.getRealZoom(), false);
                    }
                }));
            }
            objectArray = new Object[]{"onMatrixSizeChanged: newTransformationZoom:", Float.valueOf(ZoomEngine.this.getZoomManager$library_release().getTransformationZoom$library_release()), "newRealZoom:", Float.valueOf(ZoomEngine.this.getRealZoom()), "newZoom:", Float.valueOf(ZoomEngine.this.getZoom())};
            LOG.i$library_release(objectArray);
        }

        @Override
        public boolean isStateAllowed(int newState) {
            return ZoomEngine.this.matrixController.isInitialized$library_release();
        }

        @Override
        public void onStateIdle() {
            ZoomEngine.this.dispatcher.dispatchOnIdle$library_release();
        }

        @Override
        public void cleanupState(int oldState) {
            int n = oldState;
            switch (n) {
                case 3: {
                    ZoomEngine.this.matrixController.cancelAnimations$library_release();
                    break;
                }
                case 4: {
                    ZoomEngine.this.scrollFlingDetector.cancelFling$library_release();
                }
            }
        }

        @Override
        public void endScrollGesture() {
            ZoomEngine.this.scrollFlingDetector.cancelScroll$library_release();
        }

        @Override
        public boolean maybeStartPinchGesture(@NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return ZoomEngine.this.pinchDetector.maybeStart$library_release(event);
        }

        @Override
        public boolean maybeStartScrollFlingGesture(@NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return ZoomEngine.this.scrollFlingDetector.maybeStart$library_release(event);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/otaliastudios/zoom/ZoomEngine$Listener;", "", "onIdle", "", "engine", "Lcom/otaliastudios/zoom/ZoomEngine;", "onUpdate", "matrix", "Landroid/graphics/Matrix;", "library_release"})
    public static interface Listener {
        public void onUpdate(@NotNull ZoomEngine var1, @NotNull Matrix var2);

        public void onIdle(@NotNull ZoomEngine var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J-\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH \u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/otaliastudios/zoom/ZoomEngine$SimpleListener;", "Lcom/otaliastudios/zoom/ZoomEngine$Listener;", "()V", "mMatrixValues", "", "onUpdate", "", "engine", "Lcom/otaliastudios/zoom/ZoomEngine;", "matrix", "Landroid/graphics/Matrix;", "panX", "", "panY", "zoom", "onUpdate$library_release", "library_release"})
    public static abstract class SimpleListener
    implements Listener {
        @NotNull
        private final float[] mMatrixValues = new float[9];

        @Override
        public void onUpdate(@NotNull ZoomEngine engine, @NotNull Matrix matrix) {
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
            matrix.getValues(this.mMatrixValues);
            float panX = this.mMatrixValues[2];
            float panY = this.mMatrixValues[5];
            float scaleX = this.mMatrixValues[0];
            float scaleY = this.mMatrixValues[4];
            float scale = (scaleX + scaleY) / 2.0f;
            this.onUpdate$library_release(engine, panX, panY, scale);
        }

        public abstract void onUpdate$library_release(@NotNull ZoomEngine var1, float var2, float var3, float var4);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/otaliastudios/zoom/ZoomEngine$Companion;", "", "()V", "DEFAULT_ANIMATION_DURATION", "", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

