/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import com.otaliastudios.zoom.AbsolutePoint;
import com.otaliastudios.zoom.OverPanRangeProvider;
import com.otaliastudios.zoom.OverZoomRangeProvider;
import com.otaliastudios.zoom.R;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomApi;
import com.otaliastudios.zoom.ZoomEngine;
import com.otaliastudios.zoom.ZoomLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 z2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001zB%\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB-\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0016J\t\u0010/\u001a\u00020\u0011H\u0096\u0001J\b\u00100\u001a\u00020\tH\u0014J\b\u00101\u001a\u00020\tH\u0014J\b\u00102\u001a\u00020\tH\u0014J\b\u00103\u001a\u00020\tH\u0014J \u00104\u001a\u00020\u00112\u0006\u00105\u001a\u0002062\u0006\u0010*\u001a\u00020+2\u0006\u00107\u001a\u000208H\u0014J\t\u00109\u001a\u00020\u0017H\u0096\u0001J\t\u0010:\u001a\u00020\tH\u0096\u0001J\t\u0010;\u001a\u00020\u0017H\u0096\u0001J\t\u0010<\u001a\u00020\tH\u0096\u0001J)\u0010=\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0011H\u0096\u0001J\"\u0010A\u001a\u00020)2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010@\u001a\u00020\u0011H\u0096\u0001\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020)H\u0014J\b\u0010D\u001a\u00020)H\u0014J\b\u0010E\u001a\u00020)H\u0016J\u0010\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020HH\u0016J\u0018\u0010I\u001a\u00020)2\u0006\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u00020\tH\u0014J\u0010\u0010L\u001a\u00020\u00112\u0006\u0010G\u001a\u00020HH\u0017J\b\u0010M\u001a\u00020)H\u0002J!\u0010N\u001a\u00020)2\u0006\u0010O\u001a\u00020\u00172\u0006\u0010P\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0011H\u0096\u0001J!\u0010Q\u001a\u00020)2\u0006\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0011H\u0096\u0001J\u0019\u0010R\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010S\u001a\u00020)2\u0006\u0010T\u001a\u00020\tH\u0096\u0001J\u0011\u0010U\u001a\u00020)2\u0006\u0010V\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010W\u001a\u00020)2\u0006\u0010X\u001a\u000208H\u0096\u0001J\u0011\u0010Y\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u000e\u0010[\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u0011J\u0011\u0010\\\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010]\u001a\u00020)2\u0006\u0010^\u001a\u00020\u0017H\u0096\u0001J\u0019\u0010]\u001a\u00020)2\u0006\u0010^\u001a\u00020\u00172\u0006\u0010_\u001a\u00020\tH\u0096\u0001J\u0011\u0010`\u001a\u00020)2\u0006\u0010a\u001a\u00020\u0017H\u0096\u0001J\u0019\u0010`\u001a\u00020)2\u0006\u0010a\u001a\u00020\u00172\u0006\u0010_\u001a\u00020\tH\u0096\u0001J\u0011\u0010b\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010c\u001a\u00020)2\u0006\u0010d\u001a\u00020eH\u0096\u0001J\u0011\u0010f\u001a\u00020)2\u0006\u0010g\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010h\u001a\u00020)2\u0006\u0010i\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010j\u001a\u00020)2\u0006\u0010i\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010k\u001a\u00020)2\u0006\u0010d\u001a\u00020lH\u0096\u0001J\u0011\u0010m\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010n\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010o\u001a\u00020)2\u0006\u0010p\u001a\u00020\tH\u0096\u0001J\u0019\u0010o\u001a\u00020)2\u0006\u0010p\u001a\u00020\t2\u0006\u0010q\u001a\u00020\tH\u0096\u0001J\u0011\u0010r\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010s\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010t\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u0011H\u0096\u0001J\u0019\u0010u\u001a\u00020)2\u0006\u0010v\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0011H\u0096\u0001J\t\u0010w\u001a\u00020)H\u0096\u0001J\t\u0010x\u001a\u00020)H\u0096\u0001J\u0019\u0010y\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0011H\u0096\u0001R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0012\u0010\u001c\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0012\u0010\u001e\u001a\u00020\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0012\u0010$\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0019R\u0012\u0010&\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019\u00a8\u0006{"}, d2={"Lcom/otaliastudios/zoom/ZoomLayout;", "Landroid/widget/FrameLayout;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "Lcom/otaliastudios/zoom/ZoomApi;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "engine", "Lcom/otaliastudios/zoom/ZoomEngine;", "(Landroid/content/Context;Landroid/util/AttributeSet;ILcom/otaliastudios/zoom/ZoomEngine;)V", "getEngine", "()Lcom/otaliastudios/zoom/ZoomEngine;", "hasClickableChildren", "", "pan", "Lcom/otaliastudios/zoom/AbsolutePoint;", "getPan", "()Lcom/otaliastudios/zoom/AbsolutePoint;", "panX", "", "getPanX", "()F", "panY", "getPanY", "realZoom", "getRealZoom", "scaledPan", "Lcom/otaliastudios/zoom/ScaledPoint;", "getScaledPan", "()Lcom/otaliastudios/zoom/ScaledPoint;", "scaledPanX", "getScaledPanX", "scaledPanY", "getScaledPanY", "zoom", "getZoom", "addView", "", "child", "Landroid/view/View;", "index", "params", "Landroid/view/ViewGroup$LayoutParams;", "cancelAnimations", "computeHorizontalScrollOffset", "computeHorizontalScrollRange", "computeVerticalScrollOffset", "computeVerticalScrollRange", "drawChild", "canvas", "Landroid/graphics/Canvas;", "drawingTime", "", "getMaxZoom", "getMaxZoomType", "getMinZoom", "getMinZoomType", "moveTo", "x", "y", "animate", "moveToCenter", "(Ljava/lang/Float;Z)V", "onAttachedToWindow", "onDetachedFromWindow", "onGlobalLayout", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "onUpdate", "panBy", "dx", "dy", "panTo", "realZoomTo", "setAlignment", "alignment", "setAllowFlingInOverscroll", "allow", "setAnimationDuration", "duration", "setFlingEnabled", "enabled", "setHasClickableChildren", "setHorizontalPanEnabled", "setMaxZoom", "maxZoom", "type", "setMinZoom", "minZoom", "setOneFingerScrollEnabled", "setOverPanRange", "provider", "Lcom/otaliastudios/zoom/OverPanRangeProvider;", "setOverPinchable", "overPinchable", "setOverScrollHorizontal", "overScroll", "setOverScrollVertical", "setOverZoomRange", "Lcom/otaliastudios/zoom/OverZoomRangeProvider;", "setScrollEnabled", "setThreeFingersScrollEnabled", "setTransformation", "transformation", "gravity", "setTwoFingersScrollEnabled", "setVerticalPanEnabled", "setZoomEnabled", "zoomBy", "zoomFactor", "zoomIn", "zoomOut", "zoomTo", "Companion", "library_release"})
public class ZoomLayout
extends FrameLayout
implements ViewTreeObserver.OnGlobalLayoutListener,
ZoomApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomEngine engine;
    private boolean hasClickableChildren;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;

    private ZoomLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, ZoomEngine engine) {
        super(context, attrs, defStyleAttr);
        this.engine = engine;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ZoomEngine, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.ZoomEngine, defStyleAttr, 0)");
        TypedArray a = typedArray;
        boolean overScrollHorizontal = a.getBoolean(R.styleable.ZoomEngine_overScrollHorizontal, true);
        boolean overScrollVertical = a.getBoolean(R.styleable.ZoomEngine_overScrollVertical, true);
        boolean horizontalPanEnabled = a.getBoolean(R.styleable.ZoomEngine_horizontalPanEnabled, true);
        boolean verticalPanEnabled = a.getBoolean(R.styleable.ZoomEngine_verticalPanEnabled, true);
        boolean overPinchable = a.getBoolean(R.styleable.ZoomEngine_overPinchable, true);
        boolean zoomEnabled = a.getBoolean(R.styleable.ZoomEngine_zoomEnabled, true);
        boolean flingEnabled = a.getBoolean(R.styleable.ZoomEngine_flingEnabled, true);
        boolean scrollEnabled = a.getBoolean(R.styleable.ZoomEngine_scrollEnabled, true);
        boolean oneFingerScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_oneFingerScrollEnabled, true);
        boolean twoFingersScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_twoFingersScrollEnabled, true);
        boolean threeFingersScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_threeFingersScrollEnabled, true);
        boolean allowFlingInOverscroll = a.getBoolean(R.styleable.ZoomEngine_allowFlingInOverscroll, true);
        boolean hasChildren = a.getBoolean(R.styleable.ZoomEngine_hasClickableChildren, false);
        float minZoom = a.getFloat(R.styleable.ZoomEngine_minZoom, 0.8f);
        float maxZoom = a.getFloat(R.styleable.ZoomEngine_maxZoom, 2.5f);
        int minZoomMode = a.getInteger(R.styleable.ZoomEngine_minZoomType, 0);
        int maxZoomMode = a.getInteger(R.styleable.ZoomEngine_maxZoomType, 0);
        int transformation = a.getInteger(R.styleable.ZoomEngine_transformation, 0);
        int transformationGravity = a.getInt(R.styleable.ZoomEngine_transformationGravity, 0);
        int alignment = a.getInt(R.styleable.ZoomEngine_alignment, 51);
        long animationDuration = a.getInt(R.styleable.ZoomEngine_animationDuration, 280);
        a.recycle();
        this.engine.setContainer((View)this);
        this.engine.addListener(new ZoomEngine.Listener(){

            @Override
            public void onIdle(@NotNull ZoomEngine engine) {
                Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            }

            @Override
            public void onUpdate(@NotNull ZoomEngine engine, @NotNull Matrix matrix) {
                Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
                Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
                this.onUpdate();
            }
        });
        this.setTransformation(transformation, transformationGravity);
        this.setAlignment(alignment);
        this.setOverScrollHorizontal(overScrollHorizontal);
        this.setOverScrollVertical(overScrollVertical);
        this.setHorizontalPanEnabled(horizontalPanEnabled);
        this.setVerticalPanEnabled(verticalPanEnabled);
        this.setOverPinchable(overPinchable);
        this.setZoomEnabled(zoomEnabled);
        this.setFlingEnabled(flingEnabled);
        this.setScrollEnabled(scrollEnabled);
        this.setOneFingerScrollEnabled(oneFingerScrollEnabled);
        this.setTwoFingersScrollEnabled(twoFingersScrollEnabled);
        this.setThreeFingersScrollEnabled(threeFingersScrollEnabled);
        this.setAllowFlingInOverscroll(allowFlingInOverscroll);
        this.setAnimationDuration(animationDuration);
        this.setMinZoom(minZoom, minZoomMode);
        this.setMaxZoom(maxZoom, maxZoomMode);
        this.setHasClickableChildren(hasChildren);
        this.setWillNotDraw(false);
    }

    /* synthetic */ ZoomLayout(Context context, AttributeSet attributeSet, int n, ZoomEngine zoomEngine, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            zoomEngine = new ZoomEngine(context);
        }
        this(context, attributeSet, n, zoomEngine);
    }

    @NotNull
    public final ZoomEngine getEngine() {
        return this.engine;
    }

    @Override
    public float getPanX() {
        return this.engine.getPanX();
    }

    @Override
    public float getPanY() {
        return this.engine.getPanY();
    }

    @Override
    public float getRealZoom() {
        return this.engine.getRealZoom();
    }

    @Override
    public float getScaledPanX() {
        return this.engine.getScaledPanX();
    }

    @Override
    public float getScaledPanY() {
        return this.engine.getScaledPanY();
    }

    @Override
    public float getZoom() {
        return this.engine.getZoom();
    }

    @Override
    public int getMaxZoomType() {
        return this.engine.getMaxZoomType();
    }

    @Override
    public int getMinZoomType() {
        return this.engine.getMinZoomType();
    }

    @Override
    public boolean cancelAnimations() {
        return this.engine.cancelAnimations();
    }

    @Override
    public float getMaxZoom() {
        return this.engine.getMaxZoom();
    }

    @Override
    public float getMinZoom() {
        return this.engine.getMinZoom();
    }

    @Override
    public void moveTo(float zoom, float x, float y, boolean animate) {
        this.engine.moveTo(zoom, x, y, animate);
    }

    @Override
    public void moveToCenter(@Nullable Float zoom, boolean animate) {
        this.engine.moveToCenter(zoom, animate);
    }

    @Override
    public void panBy(float dx, float dy, boolean animate) {
        this.engine.panBy(dx, dy, animate);
    }

    @Override
    public void panTo(float x, float y, boolean animate) {
        this.engine.panTo(x, y, animate);
    }

    @Override
    public void realZoomTo(float realZoom, boolean animate) {
        this.engine.realZoomTo(realZoom, animate);
    }

    @Override
    public void setAlignment(int alignment) {
        this.engine.setAlignment(alignment);
    }

    @Override
    public void setAllowFlingInOverscroll(boolean allow) {
        this.engine.setAllowFlingInOverscroll(allow);
    }

    @Override
    public void setAnimationDuration(long duration) {
        this.engine.setAnimationDuration(duration);
    }

    @Override
    public void setFlingEnabled(boolean enabled) {
        this.engine.setFlingEnabled(enabled);
    }

    @Override
    public void setHorizontalPanEnabled(boolean enabled) {
        this.engine.setHorizontalPanEnabled(enabled);
    }

    @Override
    public void setMaxZoom(float maxZoom) {
        this.engine.setMaxZoom(maxZoom);
    }

    @Override
    public void setMaxZoom(float maxZoom, int type) {
        this.engine.setMaxZoom(maxZoom, type);
    }

    @Override
    public void setMinZoom(float minZoom) {
        this.engine.setMinZoom(minZoom);
    }

    @Override
    public void setMinZoom(float minZoom, int type) {
        this.engine.setMinZoom(minZoom, type);
    }

    @Override
    public void setOneFingerScrollEnabled(boolean enabled) {
        this.engine.setOneFingerScrollEnabled(enabled);
    }

    @Override
    public void setOverPanRange(@NotNull OverPanRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.engine.setOverPanRange(provider);
    }

    @Override
    public void setOverPinchable(boolean overPinchable) {
        this.engine.setOverPinchable(overPinchable);
    }

    @Override
    public void setOverScrollHorizontal(boolean overScroll) {
        this.engine.setOverScrollHorizontal(overScroll);
    }

    @Override
    public void setOverScrollVertical(boolean overScroll) {
        this.engine.setOverScrollVertical(overScroll);
    }

    @Override
    public void setOverZoomRange(@NotNull OverZoomRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.engine.setOverZoomRange(provider);
    }

    @Override
    public void setScrollEnabled(boolean enabled) {
        this.engine.setScrollEnabled(enabled);
    }

    @Override
    public void setThreeFingersScrollEnabled(boolean enabled) {
        this.engine.setThreeFingersScrollEnabled(enabled);
    }

    @Override
    public void setTransformation(int transformation) {
        this.engine.setTransformation(transformation);
    }

    @Override
    public void setTransformation(int transformation, int gravity) {
        this.engine.setTransformation(transformation, gravity);
    }

    @Override
    public void setTwoFingersScrollEnabled(boolean enabled) {
        this.engine.setTwoFingersScrollEnabled(enabled);
    }

    @Override
    public void setVerticalPanEnabled(boolean enabled) {
        this.engine.setVerticalPanEnabled(enabled);
    }

    @Override
    public void setZoomEnabled(boolean enabled) {
        this.engine.setZoomEnabled(enabled);
    }

    @Override
    public void zoomBy(float zoomFactor, boolean animate) {
        this.engine.zoomBy(zoomFactor, animate);
    }

    @Override
    public void zoomIn() {
        this.engine.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.engine.zoomOut();
    }

    @Override
    public void zoomTo(float zoom, boolean animate) {
        this.engine.zoomTo(zoom, animate);
    }

    @Override
    @NotNull
    public AbsolutePoint getPan() {
        return this.engine.getPan();
    }

    @Override
    @NotNull
    public ScaledPoint getScaledPan() {
        return this.engine.getScaledPan();
    }

    @JvmOverloads
    public ZoomLayout(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, new ZoomEngine(context));
    }

    public /* synthetic */ ZoomLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void onGlobalLayout() {
        if (this.getChildCount() == 0) {
            return;
        }
        View child = this.getChildAt(0);
        ZoomEngine.setContentSize$default(this.engine, child.getWidth(), child.getHeight(), false, 4, null);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode == 0 || heightMode == 0) {
            throw new RuntimeException(Intrinsics.stringPlus((String)TAG, (Object)" must be used with fixed dimensions (e.g. match_parent)"));
        }
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
        int spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.measureChildren(spec, spec);
    }

    public void addView(@NotNull View child, int index, @NotNull ViewGroup.LayoutParams params) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.getChildCount() > 0) {
            throw new RuntimeException(Intrinsics.stringPlus((String)TAG, (Object)" accepts only a single child."));
        }
        super.addView(child, index, params);
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.engine.onInterceptTouchEvent(ev) || this.hasClickableChildren && super.onInterceptTouchEvent(ev);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.engine.onTouchEvent(ev) || this.hasClickableChildren && super.onTouchEvent(ev);
    }

    private final void onUpdate() {
        if (this.hasClickableChildren) {
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                child.setPivotX(0.0f);
                child.setPivotY(0.0f);
                child.setTranslationX(this.engine.getScaledPanX());
                child.setTranslationY(this.engine.getScaledPanY());
                child.setScaleX(this.engine.getRealZoom());
                child.setScaleY(this.engine.getRealZoom());
            }
        } else {
            this.invalidate();
        }
        if ((this.isHorizontalScrollBarEnabled() || this.isVerticalScrollBarEnabled()) && !this.awakenScrollBars()) {
            this.invalidate();
        }
    }

    protected int computeHorizontalScrollOffset() {
        return this.engine.computeHorizontalScrollOffset();
    }

    protected int computeHorizontalScrollRange() {
        return this.engine.computeHorizontalScrollRange();
    }

    protected int computeVerticalScrollOffset() {
        return this.engine.computeVerticalScrollOffset();
    }

    protected int computeVerticalScrollRange() {
        return this.engine.computeVerticalScrollRange();
    }

    protected boolean drawChild(@NotNull Canvas canvas, @NotNull View child, long drawingTime) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean result = false;
        if (!this.hasClickableChildren) {
            int save = canvas.save();
            canvas.concat(this.engine.getMatrix());
            result = super.drawChild(canvas, child, drawingTime);
            canvas.restoreToCount(save);
        } else {
            result = super.drawChild(canvas, child, drawingTime);
        }
        return result;
    }

    public final void setHasClickableChildren(boolean hasClickableChildren) {
        Object[] objectArray = new Object[]{"setHasClickableChildren:", "old:", this.hasClickableChildren, "new:", hasClickableChildren};
        LOG.i$library_release(objectArray);
        if (this.hasClickableChildren && !hasClickableChildren && this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            child.setScaleX(1.0f);
            child.setScaleY(1.0f);
            child.setTranslationX(0.0f);
            child.setTranslationY(0.0f);
        }
        this.hasClickableChildren = hasClickableChildren;
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            if (this.hasClickableChildren) {
                this.onUpdate();
            } else {
                this.invalidate();
            }
        }
    }

    @JvmOverloads
    public ZoomLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ZoomLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    static {
        String string = TAG = ZoomLayout.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/otaliastudios/zoom/ZoomLayout$Companion;", "", "()V", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

