/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom.internal;

import android.view.MotionEvent;
import com.otaliastudios.zoom.ZoomLogger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 /2\u00020\u0001:\u0003./0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0014J\r\u0010\u0015\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u001cH\u0002J\r\u0010\"\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0006H\u0002J\f\u0010,\u001a\u00020-*\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u00061"}, d2={"Lcom/otaliastudios/zoom/internal/StateController;", "", "callback", "Lcom/otaliastudios/zoom/internal/StateController$Callback;", "(Lcom/otaliastudios/zoom/internal/StateController$Callback;)V", "<set-?>", "", "state", "getState$library_release$annotations", "()V", "getState$library_release", "()I", "isAnimating", "", "isAnimating$library_release", "isFlinging", "isFlinging$library_release", "isIdle", "isIdle$library_release", "isPinching", "isPinching$library_release", "isScrolling", "isScrolling$library_release", "makeIdle", "makeIdle$library_release", "needsCleanupWhenCalledTwice", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onInterceptTouchEvent$library_release", "onTouchEvent", "onTouchEvent$library_release", "processTouchEvent", "event", "setAnimating", "setAnimating$library_release", "setFlinging", "setFlinging$library_release", "setPinching", "setPinching$library_release", "setScrolling", "setScrolling$library_release", "setState", "newState", "toStateName", "", "Callback", "Companion", "State", "library_release"})
public final class StateController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Callback callback;
    private int state;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;
    public static final int IDLE = 0;
    public static final int SCROLLING = 1;
    public static final int PINCHING = 2;
    public static final int ANIMATING = 3;
    public static final int FLINGING = 4;
    private static final int TOUCH_NO = 0;
    private static final int TOUCH_LISTEN = 1;
    private static final int TOUCH_STEAL = 2;

    public StateController(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callback = callback;
    }

    public final int getState$library_release() {
        return this.state;
    }

    public static /* synthetic */ void getState$library_release$annotations() {
    }

    private final boolean needsCleanupWhenCalledTwice(int state) {
        return state == 3;
    }

    private final boolean setState(int newState) {
        Object[] objectArray = new Object[]{"trySetState:", this.toStateName(newState)};
        LOG.v$library_release(objectArray);
        if (!this.callback.isStateAllowed(newState)) {
            return false;
        }
        if (newState == this.state && !this.needsCleanupWhenCalledTwice(newState)) {
            return true;
        }
        int oldState = this.state;
        int n = newState;
        switch (n) {
            case 1: {
                switch (oldState) {
                    case 2: 
                    case 3: {
                        return false;
                    }
                }
                break;
            }
            case 4: {
                if (oldState != 3) break;
                return false;
            }
            case 2: {
                if (oldState != 3) break;
                return false;
            }
            case 0: {
                this.callback.onStateIdle();
            }
        }
        this.callback.cleanupState(oldState);
        Object[] objectArray2 = new Object[]{"setState:", this.toStateName(newState)};
        LOG.i$library_release(objectArray2);
        this.state = newState;
        return true;
    }

    public final boolean onInterceptTouchEvent$library_release(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.processTouchEvent(ev) > 1;
    }

    public final boolean onTouchEvent$library_release(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.processTouchEvent(ev) > 0;
    }

    private final int processTouchEvent(MotionEvent event) {
        int n;
        Object[] objectArray = new Object[]{"processTouchEvent:", "start."};
        LOG.v$library_release(objectArray);
        if (this.isAnimating$library_release()) {
            return 2;
        }
        boolean result = this.callback.maybeStartPinchGesture(event);
        Object[] objectArray2 = new Object[]{"processTouchEvent:", "scaleResult:", result};
        LOG.v$library_release(objectArray2);
        if (!this.isPinching$library_release()) {
            objectArray2 = new Object[]{"processTouchEvent:", "flingResult:", result |= this.callback.maybeStartScrollFlingGesture(event)};
            LOG.v$library_release(objectArray2);
        }
        if (this.isScrolling$library_release()) {
            int a = event.getActionMasked();
            switch (a) {
                case 1: 
                case 3: {
                    Object[] objectArray3 = new Object[]{"processTouchEvent:", "up event while scrolling, dispatching endScrollGesture."};
                    LOG.i$library_release(objectArray3);
                    this.callback.endScrollGesture();
                }
            }
        }
        if (result && !this.isIdle$library_release()) {
            Object[] objectArray4 = new Object[]{"processTouchEvent:", "returning: TOUCH_STEAL"};
            LOG.v$library_release(objectArray4);
            n = 2;
        } else if (result) {
            Object[] objectArray5 = new Object[]{"processTouchEvent:", "returning: TOUCH_LISTEN"};
            LOG.v$library_release(objectArray5);
            n = 1;
        } else {
            Object[] objectArray6 = new Object[]{"processTouchEvent:", "returning: TOUCH_NO"};
            LOG.v$library_release(objectArray6);
            this.makeIdle$library_release();
            n = 0;
        }
        return n;
    }

    public final boolean isFlinging$library_release() {
        return this.state == 4;
    }

    public final boolean isScrolling$library_release() {
        return this.state == 1;
    }

    public final boolean isPinching$library_release() {
        return this.state == 2;
    }

    public final boolean isAnimating$library_release() {
        return this.state == 3;
    }

    public final boolean isIdle$library_release() {
        return this.state == 0;
    }

    public final boolean setFlinging$library_release() {
        return this.setState(4);
    }

    public final boolean setScrolling$library_release() {
        return this.setState(1);
    }

    public final boolean setPinching$library_release() {
        return this.setState(2);
    }

    public final boolean setAnimating$library_release() {
        return this.setState(3);
    }

    public final boolean makeIdle$library_release() {
        return this.setState(0);
    }

    private final String toStateName(int $this$toStateName) {
        String string;
        int n = $this$toStateName;
        switch (n) {
            case 0: {
                string = "IDLE";
                break;
            }
            case 4: {
                string = "FLINGING";
                break;
            }
            case 1: {
                string = "SCROLLING";
                break;
            }
            case 2: {
                string = "PINCHING";
                break;
            }
            case 3: {
                string = "ANIMATING";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static {
        String string = TAG = StateController.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H&J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH&J\b\u0010\u000e\u001a\u00020\u0003H&\u00a8\u0006\u000f"}, d2={"Lcom/otaliastudios/zoom/internal/StateController$Callback;", "", "cleanupState", "", "oldState", "", "endScrollGesture", "isStateAllowed", "", "newState", "maybeStartPinchGesture", "event", "Landroid/view/MotionEvent;", "maybeStartScrollFlingGesture", "onStateIdle", "library_release"})
    public static interface Callback {
        public boolean isStateAllowed(int var1);

        public void onStateIdle();

        public void cleanupState(int var1);

        public boolean maybeStartPinchGesture(@NotNull MotionEvent var1);

        public boolean maybeStartScrollFlingGesture(@NotNull MotionEvent var1);

        public void endScrollGesture();
    }

    @kotlin.annotation.Retention(value=AnnotationRetention.SOURCE)
    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/otaliastudios/zoom/internal/StateController$State;", "", "library_release"})
    public static @interface State {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/otaliastudios/zoom/internal/StateController$Companion;", "", "()V", "ANIMATING", "", "FLINGING", "IDLE", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "PINCHING", "SCROLLING", "TAG", "", "kotlin.jvm.PlatformType", "TOUCH_LISTEN", "TOUCH_NO", "TOUCH_STEAL", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

