/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom.internal.gestures;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.widget.OverScroller;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomLogger;
import com.otaliastudios.zoom.internal.StateController;
import com.otaliastudios.zoom.internal.matrix.MatrixController;
import com.otaliastudios.zoom.internal.matrix.MatrixUpdate;
import com.otaliastudios.zoom.internal.movement.PanManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\t\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\r\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020(H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020\u000eH\u0002J\u0015\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020/H\u0016J,\u00103\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u00010/2\b\u00105\u001a\u0004\u0018\u00010/2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0016J\u0012\u00109\u001a\u00020(2\b\u00102\u001a\u0004\u0018\u00010/H\u0016J,\u0010:\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u00010/2\b\u00105\u001a\u0004\u0018\u00010/2\u0006\u0010;\u001a\u0002072\u0006\u0010<\u001a\u000207H\u0016J\u0012\u0010=\u001a\u00020(2\b\u00102\u001a\u0004\u0018\u00010/H\u0016J\u0012\u0010>\u001a\u00020\u000e2\b\u00102\u001a\u0004\u0018\u00010/H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010\u0012R\u001a\u0010$\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0010\"\u0004\b&\u0010\u0012\u00a8\u0006@"}, d2={"Lcom/otaliastudios/zoom/internal/gestures/ScrollFlingDetector;", "Landroid/view/GestureDetector$OnGestureListener;", "context", "Landroid/content/Context;", "panManager", "Lcom/otaliastudios/zoom/internal/movement/PanManager;", "stateController", "Lcom/otaliastudios/zoom/internal/StateController;", "matrixController", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController;", "(Landroid/content/Context;Lcom/otaliastudios/zoom/internal/movement/PanManager;Lcom/otaliastudios/zoom/internal/StateController;Lcom/otaliastudios/zoom/internal/matrix/MatrixController;)V", "detector", "Landroid/view/GestureDetector;", "flingEnabled", "", "getFlingEnabled$library_release", "()Z", "setFlingEnabled$library_release", "(Z)V", "flingInOverPanEnabled", "getFlingInOverPanEnabled$library_release", "setFlingInOverPanEnabled$library_release", "flingScroller", "Landroid/widget/OverScroller;", "oneFingerScrollEnabled", "getOneFingerScrollEnabled$library_release", "setOneFingerScrollEnabled$library_release", "panStatusX", "Lcom/otaliastudios/zoom/internal/movement/PanManager$Status;", "panStatusY", "scrollEnabled", "getScrollEnabled$library_release", "setScrollEnabled$library_release", "threeFingersScrollEnabled", "getThreeFingersScrollEnabled$library_release", "setThreeFingersScrollEnabled$library_release", "twoFingersScrollEnabled", "getTwoFingersScrollEnabled$library_release", "setTwoFingersScrollEnabled$library_release", "cancelFling", "", "cancelFling$library_release", "cancelScroll", "cancelScroll$library_release", "correctOverpan", "maybeStart", "event", "Landroid/view/MotionEvent;", "maybeStart$library_release", "onDown", "e", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onLongPress", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "Companion", "library_release"})
public final class ScrollFlingDetector
implements GestureDetector.OnGestureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PanManager panManager;
    @NotNull
    private final StateController stateController;
    @NotNull
    private final MatrixController matrixController;
    @NotNull
    private final GestureDetector detector;
    @NotNull
    private final OverScroller flingScroller;
    @NotNull
    private final PanManager.Status panStatusX;
    @NotNull
    private final PanManager.Status panStatusY;
    private boolean flingEnabled;
    private boolean scrollEnabled;
    private boolean oneFingerScrollEnabled;
    private boolean twoFingersScrollEnabled;
    private boolean threeFingersScrollEnabled;
    private boolean flingInOverPanEnabled;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;

    /*
     * WARNING - void declaration
     */
    public ScrollFlingDetector(@NotNull Context context, @NotNull PanManager panManager2, @NotNull StateController stateController, @NotNull MatrixController matrixController) {
        void $this$detector_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)panManager2, (String)"panManager");
        Intrinsics.checkNotNullParameter((Object)stateController, (String)"stateController");
        Intrinsics.checkNotNullParameter((Object)matrixController, (String)"matrixController");
        this.panManager = panManager2;
        this.stateController = stateController;
        this.matrixController = matrixController;
        GestureDetector gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        boolean bl = false;
        boolean bl2 = false;
        GestureDetector gestureDetector2 = gestureDetector;
        ScrollFlingDetector scrollFlingDetector = this;
        boolean bl3 = false;
        $this$detector_u24lambda_u2d0.setOnDoubleTapListener(null);
        Unit unit = Unit.INSTANCE;
        scrollFlingDetector.detector = gestureDetector;
        this.flingScroller = new OverScroller(context);
        this.panStatusX = new PanManager.Status();
        this.panStatusY = new PanManager.Status();
        this.flingEnabled = true;
        this.scrollEnabled = true;
        this.oneFingerScrollEnabled = true;
        this.twoFingersScrollEnabled = true;
        this.threeFingersScrollEnabled = true;
    }

    public final boolean getFlingEnabled$library_release() {
        return this.flingEnabled;
    }

    public final void setFlingEnabled$library_release(boolean bl) {
        this.flingEnabled = bl;
    }

    public final boolean getScrollEnabled$library_release() {
        return this.scrollEnabled;
    }

    public final void setScrollEnabled$library_release(boolean bl) {
        this.scrollEnabled = bl;
    }

    public final boolean getOneFingerScrollEnabled$library_release() {
        return this.oneFingerScrollEnabled;
    }

    public final void setOneFingerScrollEnabled$library_release(boolean bl) {
        this.oneFingerScrollEnabled = bl;
    }

    public final boolean getTwoFingersScrollEnabled$library_release() {
        return this.twoFingersScrollEnabled;
    }

    public final void setTwoFingersScrollEnabled$library_release(boolean bl) {
        this.twoFingersScrollEnabled = bl;
    }

    public final boolean getThreeFingersScrollEnabled$library_release() {
        return this.threeFingersScrollEnabled;
    }

    public final void setThreeFingersScrollEnabled$library_release(boolean bl) {
        this.threeFingersScrollEnabled = bl;
    }

    public final boolean getFlingInOverPanEnabled$library_release() {
        return this.flingInOverPanEnabled;
    }

    public final void setFlingInOverPanEnabled$library_release(boolean bl) {
        this.flingInOverPanEnabled = bl;
    }

    public final boolean maybeStart$library_release(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.detector.onTouchEvent(event);
    }

    public final void cancelFling$library_release() {
        this.flingScroller.forceFinished(true);
    }

    public final void cancelScroll$library_release() {
        if (!this.correctOverpan()) {
            this.stateController.makeIdle$library_release();
        }
    }

    private final boolean correctOverpan() {
        ScaledPoint fix;
        if (!(!this.panManager.isOverEnabled() || (fix = this.panManager.getCorrection$library_release()).getX() == 0.0f && fix.getY() == 0.0f)) {
            this.matrixController.animateUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(fix){
                final /* synthetic */ ScaledPoint $fix;
                {
                    this.$fix = $fix;
                    super(1);
                }

                public final void invoke(@NotNull MatrixUpdate.Builder $this$animateUpdate) {
                    Intrinsics.checkNotNullParameter((Object)$this$animateUpdate, (String)"$this$animateUpdate");
                    $this$animateUpdate.panBy$library_release(this.$fix, true);
                }
            }));
            return true;
        }
        return false;
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.cancelFling$library_release();
        return true;
    }

    public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
        if (!this.flingEnabled) {
            return false;
        }
        if (!this.panManager.isEnabled()) {
            return false;
        }
        int velX = (int)(this.panManager.getHorizontalPanEnabled$library_release() ? velocityX : 0.0f);
        int velY = (int)(this.panManager.getVerticalPanEnabled$library_release() ? velocityY : 0.0f);
        this.panManager.computeStatus$library_release(true, this.panStatusX);
        this.panManager.computeStatus$library_release(false, this.panStatusY);
        int minX = this.panStatusX.getMinValue$library_release();
        int startX = this.panStatusX.getCurrentValue$library_release();
        int maxX = this.panStatusX.getMaxValue$library_release();
        int minY = this.panStatusY.getMinValue$library_release();
        int startY = this.panStatusY.getCurrentValue$library_release();
        int maxY = this.panStatusY.getMaxValue$library_release();
        if (!this.flingInOverPanEnabled && (this.panStatusX.isInOverPan$library_release() || this.panStatusY.isInOverPan$library_release())) {
            return false;
        }
        if (minX >= maxX && minY >= maxY && !this.panManager.isOverEnabled()) {
            return false;
        }
        if (!this.stateController.setFlinging$library_release()) {
            return false;
        }
        this.detector.setIsLongpressEnabled(false);
        float overScrollX = this.panManager.getHorizontalOverPanEnabled$library_release() ? this.panManager.getMaxHorizontalOverPan$library_release() : 0.0f;
        float overScrollY = this.panManager.getVerticalOverPanEnabled$library_release() ? this.panManager.getMaxVerticalOverPan$library_release() : 0.0f;
        Object[] objectArray = new Object[]{"startFling", "velocityX:", velX, "velocityY:", velY};
        LOG.i$library_release(objectArray);
        objectArray = new Object[]{"startFling", "flingX:", "min:", minX, "max:", maxX, "start:", startX, "overScroll:", Float.valueOf(overScrollY)};
        LOG.i$library_release(objectArray);
        objectArray = new Object[]{"startFling", "flingY:", "min:", minY, "max:", maxY, "start:", startY, "overScroll:", Float.valueOf(overScrollX)};
        LOG.i$library_release(objectArray);
        this.flingScroller.fling(startX, startY, velX, velY, minX, maxX, minY, maxY, (int)overScrollX, (int)overScrollY);
        this.matrixController.post$library_release(new Runnable(this){
            final /* synthetic */ ScrollFlingDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                if (ScrollFlingDetector.access$getFlingScroller$p(this.this$0).isFinished()) {
                    ScrollFlingDetector.access$getStateController$p(this.this$0).makeIdle$library_release();
                    ScrollFlingDetector.access$getDetector$p(this.this$0).setIsLongpressEnabled(true);
                } else if (ScrollFlingDetector.access$getFlingScroller$p(this.this$0).computeScrollOffset()) {
                    ScaledPoint newPan = new ScaledPoint(ScrollFlingDetector.access$getFlingScroller$p(this.this$0).getCurrX(), ScrollFlingDetector.access$getFlingScroller$p(this.this$0).getCurrY());
                    ScrollFlingDetector.access$getMatrixController$p(this.this$0).applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(newPan){
                        final /* synthetic */ ScaledPoint $newPan;
                        {
                            this.$newPan = $newPan;
                            super(1);
                        }

                        public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                            Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                            $this$applyUpdate.panTo$library_release(this.$newPan, true);
                        }
                    }));
                    ScrollFlingDetector.access$getMatrixController$p(this.this$0).postOnAnimation$library_release(this);
                }
            }
        });
        return true;
    }

    public boolean onScroll(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float distanceX, float distanceY) {
        float frictionX;
        boolean bl;
        double d;
        boolean isThreeFingers;
        if (!this.scrollEnabled) {
            return false;
        }
        MotionEvent motionEvent = e2;
        boolean isOneFinger = motionEvent == null ? false : motionEvent.getPointerCount() == 1;
        MotionEvent motionEvent2 = e2;
        boolean isTwoFingers = motionEvent2 == null ? false : motionEvent2.getPointerCount() == 2;
        MotionEvent motionEvent3 = e2;
        boolean bl2 = motionEvent3 == null ? false : (isThreeFingers = motionEvent3.getPointerCount() == 3);
        if (!this.oneFingerScrollEnabled && isOneFinger) {
            return false;
        }
        if (!this.twoFingersScrollEnabled && isTwoFingers) {
            return false;
        }
        if (!this.threeFingersScrollEnabled && isThreeFingers) {
            return false;
        }
        if (!this.panManager.isEnabled()) {
            return false;
        }
        if (!this.stateController.setScrolling$library_release()) {
            return false;
        }
        ScaledPoint delta = new ScaledPoint(-distanceX, -distanceY);
        ScaledPoint panFix = this.panManager.getCorrection$library_release();
        if (panFix.getX() < 0.0f && delta.getX() > 0.0f || panFix.getX() > 0.0f && delta.getX() < 0.0f) {
            float f = panFix.getX();
            boolean bl3 = false;
            float overScrollX = Math.abs(f) / this.panManager.getMaxHorizontalOverPan$library_release();
            double d2 = overScrollX;
            d = 0.4;
            bl = false;
            frictionX = 0.6f * (1.0f - (float)Math.pow(d2, d));
            Object object = new Object[]{"onScroll", "applying friction X:", Float.valueOf(frictionX)};
            LOG.i$library_release((Object[])object);
            object = delta;
            ((ScaledPoint)object).setX(((ScaledPoint)object).getX() * frictionX);
        }
        if (panFix.getY() < 0.0f && delta.getY() > 0.0f || panFix.getY() > 0.0f && delta.getY() < 0.0f) {
            frictionX = panFix.getY();
            boolean bl4 = false;
            float overScrollY = Math.abs(frictionX) / this.panManager.getMaxVerticalOverPan$library_release();
            double d3 = overScrollY;
            d = 0.4;
            bl = false;
            float frictionY = 0.6f * (1.0f - (float)Math.pow(d3, d));
            Object object = new Object[]{"onScroll", "applying friction Y:", Float.valueOf(frictionY)};
            LOG.i$library_release((Object[])object);
            object = delta;
            ((ScaledPoint)object).setY(((ScaledPoint)object).getY() * frictionY);
        }
        if (!this.panManager.getHorizontalPanEnabled$library_release()) {
            delta.setX(0.0f);
        }
        if (!this.panManager.getVerticalPanEnabled$library_release()) {
            delta.setY(0.0f);
        }
        if (!(delta.getX() == 0.0f) || !(delta.getY() == 0.0f)) {
            this.matrixController.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(delta){
                final /* synthetic */ ScaledPoint $delta;
                {
                    this.$delta = $delta;
                    super(1);
                }

                public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                    Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                    $this$applyUpdate.panBy$library_release(this.$delta, true);
                }
            }));
        }
        return true;
    }

    public void onShowPress(@Nullable MotionEvent e) {
    }

    public boolean onSingleTapUp(@Nullable MotionEvent e) {
        return false;
    }

    public void onLongPress(@Nullable MotionEvent e) {
    }

    public static final /* synthetic */ OverScroller access$getFlingScroller$p(ScrollFlingDetector $this) {
        return $this.flingScroller;
    }

    public static final /* synthetic */ StateController access$getStateController$p(ScrollFlingDetector $this) {
        return $this.stateController;
    }

    public static final /* synthetic */ GestureDetector access$getDetector$p(ScrollFlingDetector $this) {
        return $this.detector;
    }

    public static final /* synthetic */ MatrixController access$getMatrixController$p(ScrollFlingDetector $this) {
        return $this.matrixController;
    }

    static {
        String string = TAG = ScrollFlingDetector.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/otaliastudios/zoom/internal/gestures/ScrollFlingDetector$Companion;", "", "()V", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

