/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom.internal.movement;

import com.otaliastudios.zoom.OverZoomRangeProvider;
import com.otaliastudios.zoom.ZoomEngine;
import com.otaliastudios.zoom.ZoomLogger;
import com.otaliastudios.zoom.internal.matrix.MatrixController;
import com.otaliastudios.zoom.internal.movement.MovementManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u0000 B2\u00020\u0001:\u0001BB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001d\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u000206H\u0016J\r\u0010\u0019\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b7J\r\u0010#\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b;J\u001d\u0010\u001a\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b=J\u001d\u0010$\u001a\u0002062\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bAR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u00108@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u00108@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u001bR\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0014\"\u0004\b0\u0010\u001b\u00a8\u0006C"}, d2={"Lcom/otaliastudios/zoom/internal/movement/ZoomManager;", "Lcom/otaliastudios/zoom/internal/movement/MovementManager;", "engine", "Lcom/otaliastudios/zoom/ZoomEngine;", "provider", "Lkotlin/Function0;", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController;", "(Lcom/otaliastudios/zoom/ZoomEngine;Lkotlin/jvm/functions/Function0;)V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "isOverEnabled", "setOverEnabled", "maxOverZoomIn", "", "getMaxOverZoomIn$library_release$annotations", "()V", "getMaxOverZoomIn$library_release", "()F", "maxOverZoomOut", "getMaxOverZoomOut$library_release$annotations", "getMaxOverZoomOut$library_release", "maxZoom", "getMaxZoom", "setMaxZoom", "(F)V", "maxZoomMode", "", "getMaxZoomMode", "()I", "setMaxZoomMode", "(I)V", "minZoom", "getMinZoom", "setMinZoom", "minZoomMode", "getMinZoomMode", "setMinZoomMode", "overZoomRangeProvider", "Lcom/otaliastudios/zoom/OverZoomRangeProvider;", "getOverZoomRangeProvider$library_release", "()Lcom/otaliastudios/zoom/OverZoomRangeProvider;", "setOverZoomRangeProvider$library_release", "(Lcom/otaliastudios/zoom/OverZoomRangeProvider;)V", "transformationZoom", "getTransformationZoom$library_release", "setTransformationZoom$library_release", "checkBounds", "value", "allowOverZoom", "checkBounds$library_release", "clear", "", "getMaxZoom$library_release", "getMinZoom$library_release", "realZoomToZoom", "realZoom", "realZoomToZoom$library_release", "type", "setMaxZoom$library_release", "setMinZoom$library_release", "zoomToRealZoom", "zoom", "zoomToRealZoom$library_release", "Companion", "library_release"})
public final class ZoomManager
extends MovementManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomEngine engine;
    private float transformationZoom;
    private float minZoom;
    private int minZoomMode;
    private float maxZoom;
    private int maxZoomMode;
    @NotNull
    private OverZoomRangeProvider overZoomRangeProvider;
    private boolean isEnabled;
    private boolean isOverEnabled;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;

    public ZoomManager(@NotNull ZoomEngine engine, @NotNull Function0<MatrixController> provider) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        super(provider);
        this.engine = engine;
        this.minZoom = 0.8f;
        this.maxZoom = 2.5f;
        this.overZoomRangeProvider = OverZoomRangeProvider.DEFAULT;
        this.isEnabled = true;
        this.isOverEnabled = true;
    }

    public final float getTransformationZoom$library_release() {
        return this.transformationZoom;
    }

    public final void setTransformationZoom$library_release(float f) {
        this.transformationZoom = f;
    }

    public final float getMinZoom() {
        return this.minZoom;
    }

    public final void setMinZoom(float f) {
        this.minZoom = f;
    }

    public final int getMinZoomMode() {
        return this.minZoomMode;
    }

    public final void setMinZoomMode(int n) {
        this.minZoomMode = n;
    }

    public final float getMaxZoom() {
        return this.maxZoom;
    }

    public final void setMaxZoom(float f) {
        this.maxZoom = f;
    }

    public final int getMaxZoomMode() {
        return this.maxZoomMode;
    }

    public final void setMaxZoomMode(int n) {
        this.maxZoomMode = n;
    }

    @NotNull
    public final OverZoomRangeProvider getOverZoomRangeProvider$library_release() {
        return this.overZoomRangeProvider;
    }

    public final void setOverZoomRangeProvider$library_release(@NotNull OverZoomRangeProvider overZoomRangeProvider) {
        Intrinsics.checkNotNullParameter((Object)overZoomRangeProvider, (String)"<set-?>");
        this.overZoomRangeProvider = overZoomRangeProvider;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Override
    public boolean isOverEnabled() {
        return this.isOverEnabled;
    }

    public void setOverEnabled(boolean bl) {
        this.isOverEnabled = bl;
    }

    @Override
    public void clear() {
        this.transformationZoom = 0.0f;
    }

    public final float realZoomToZoom$library_release(float realZoom) {
        return realZoom / this.transformationZoom;
    }

    public final float zoomToRealZoom$library_release(float zoom) {
        return zoom * this.transformationZoom;
    }

    public final void setMaxZoom$library_release(float maxZoom, int type) {
        if (maxZoom < 0.0f) {
            throw new IllegalArgumentException("Max zoom should be >= 0.");
        }
        this.maxZoom = maxZoom;
        this.maxZoomMode = type;
    }

    public final void setMinZoom$library_release(float minZoom, int type) {
        if (minZoom < 0.0f) {
            throw new IllegalArgumentException("Min zoom should be >= 0");
        }
        this.minZoom = minZoom;
        this.minZoomMode = type;
    }

    public final float getMaxOverZoomIn$library_release() {
        float value = this.overZoomRangeProvider.getOverZoom(this.engine, true);
        if (value < 0.0f) {
            LOG.w$library_release("Received negative maxOverZoomIn value, coercing to 0");
            value = RangesKt.coerceAtLeast((float)value, (float)0.0f);
        }
        return value;
    }

    public static /* synthetic */ void getMaxOverZoomIn$library_release$annotations() {
    }

    public final float getMaxOverZoomOut$library_release() {
        float value = this.overZoomRangeProvider.getOverZoom(this.engine, false);
        if (value < 0.0f) {
            LOG.w$library_release("Received negative maxOverZoomOut value, coercing to 0");
            value = RangesKt.coerceAtLeast((float)value, (float)0.0f);
        }
        return value;
    }

    public static /* synthetic */ void getMaxOverZoomOut$library_release$annotations() {
    }

    public final float getMinZoom$library_release() {
        float f;
        int n = this.minZoomMode;
        switch (n) {
            case 1: {
                f = this.minZoom;
                break;
            }
            case 0: {
                f = this.zoomToRealZoom$library_release(this.minZoom);
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown ZoomType ", (Object)this.minZoomMode));
            }
        }
        return f;
    }

    public final float getMaxZoom$library_release() {
        float f;
        int n = this.maxZoomMode;
        switch (n) {
            case 1: {
                f = this.maxZoom;
                break;
            }
            case 0: {
                f = this.zoomToRealZoom$library_release(this.maxZoom);
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown ZoomType ", (Object)this.maxZoomMode));
            }
        }
        return f;
    }

    public final float checkBounds$library_release(float value, boolean allowOverZoom) {
        float minZoom = this.getMinZoom$library_release();
        float maxZoom = this.getMaxZoom$library_release();
        if (allowOverZoom && this.isOverEnabled()) {
            minZoom -= this.getMaxOverZoomOut$library_release();
            maxZoom += this.getMaxOverZoomIn$library_release();
        }
        if (maxZoom < minZoom) {
            if (this.maxZoomMode == this.minZoomMode) {
                throw new IllegalStateException("maxZoom is less than minZoom: " + maxZoom + " < " + minZoom);
            }
            if (this.maxZoomMode == 0) {
                minZoom = maxZoom;
            } else {
                maxZoom = minZoom;
            }
        }
        return RangesKt.coerceIn((float)value, (float)minZoom, (float)maxZoom);
    }

    static {
        String string = TAG = ZoomManager.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/otaliastudios/zoom/internal/movement/ZoomManager$Companion;", "", "()V", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

