/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark;

import com.overzealous.remark.IgnoredHtmlElement;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
implements Cloneable {
    public boolean hardwraps = false;
    public InWordEmphasis inWordEmphasis = InWordEmphasis.NORMAL;
    public boolean preserveRelativeLinks = false;
    public boolean inlineLinks = false;
    public boolean simpleLinkIds = false;
    public Tables tables = Tables.LEAVE_AS_HTML;
    public boolean reverseHtmlSmartQuotes = false;
    public boolean reverseUnicodeSmartQuotes = false;
    public boolean reverseHtmlSmartPunctuation = false;
    public boolean reverseUnicodeSmartPunctuation = false;
    public boolean definitionLists = false;
    public boolean abbreviations = false;
    public boolean autoLinks = false;
    public boolean headerIds = false;
    public FencedCodeBlocks fencedCodeBlocks = FencedCodeBlocks.DISABLED;
    public int fencedCodeBlocksWidth = 10;
    public Set<IgnoredHtmlElement> ignoredHtmlElements = new HashSet<IgnoredHtmlElement>();
    public boolean fixPegdownStrongEmphasisInLinks = false;

    public static Options markdown() {
        return new Options();
    }

    public static Options markdownExtra() {
        Options opts = new Options();
        opts.headerIds = true;
        opts.fencedCodeBlocks = FencedCodeBlocks.ENABLED_TILDE;
        opts.tables = Tables.MARKDOWN_EXTRA;
        opts.definitionLists = true;
        opts.abbreviations = true;
        return opts;
    }

    public static Options multiMarkdown() {
        Options opts = new Options();
        opts.tables = Tables.MULTI_MARKDOWN;
        opts.definitionLists = true;
        return opts;
    }

    public static Options pegdownBase() {
        Options opts = new Options();
        opts.inWordEmphasis = InWordEmphasis.REMOVE_EMPHASIS;
        return opts;
    }

    public static Options pegdownAllExtensions() {
        Options opts = Options.pegdownBase();
        opts.hardwraps = true;
        opts.fencedCodeBlocks = FencedCodeBlocks.ENABLED_TILDE;
        opts.reverseHtmlSmartPunctuation = true;
        opts.reverseHtmlSmartQuotes = true;
        opts.reverseUnicodeSmartPunctuation = true;
        opts.reverseUnicodeSmartQuotes = true;
        opts.autoLinks = true;
        opts.tables = Tables.MULTI_MARKDOWN;
        opts.definitionLists = true;
        opts.abbreviations = true;
        return opts;
    }

    public static Options github() {
        Options opts = new Options();
        opts.hardwraps = true;
        opts.fencedCodeBlocks = FencedCodeBlocks.ENABLED_BACKTICK;
        opts.autoLinks = true;
        opts.tables = Tables.CONVERT_TO_CODE_BLOCK;
        return opts;
    }

    public FencedCodeBlocks getFencedCodeBlocks() {
        if (this.fencedCodeBlocks == null) {
            this.fencedCodeBlocks = FencedCodeBlocks.DISABLED;
        }
        return this.fencedCodeBlocks;
    }

    public Set<IgnoredHtmlElement> getIgnoredHtmlElements() {
        if (this.ignoredHtmlElements == null) {
            this.ignoredHtmlElements = new HashSet<IgnoredHtmlElement>();
        }
        return this.ignoredHtmlElements;
    }

    public Tables getTables() {
        if (this.tables == null) {
            this.tables = Tables.LEAVE_AS_HTML;
        }
        return this.tables;
    }

    public InWordEmphasis getInWordEmphasis() {
        if (this.inWordEmphasis == null) {
            this.inWordEmphasis = InWordEmphasis.NORMAL;
        }
        return this.inWordEmphasis;
    }

    public void setReverseSmartQuotes(boolean reverse) {
        this.reverseHtmlSmartQuotes = reverse;
        this.reverseUnicodeSmartQuotes = reverse;
    }

    public void setReverseSmartPunctuation(boolean reverse) {
        this.reverseHtmlSmartPunctuation = reverse;
        this.reverseUnicodeSmartPunctuation = reverse;
    }

    public void setReverseAllSmarts(boolean reverse) {
        this.setReverseSmartQuotes(reverse);
        this.setReverseSmartPunctuation(reverse);
    }

    public Options getCopy() {
        Options copy;
        try {
            copy = (Options)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen");
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InWordEmphasis {
        NORMAL(true, false),
        ADD_SPACES(true, true),
        REMOVE_EMPHASIS(false, false);

        private final boolean emphasisPreserved;
        private final boolean additionalSpacingNeeded;

        private InWordEmphasis(boolean emphasisPreserved, boolean additionalSpacingNeeded) {
            this.emphasisPreserved = emphasisPreserved;
            this.additionalSpacingNeeded = additionalSpacingNeeded;
        }

        public boolean isEmphasisPreserved() {
            return this.emphasisPreserved;
        }

        public boolean isAdditionalSpacingNeeded() {
            return this.additionalSpacingNeeded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FencedCodeBlocks {
        DISABLED(false, ' '),
        ENABLED_TILDE(true, '~'),
        ENABLED_BACKTICK(true, '`');

        private final boolean enabled;
        private final char separatorCharacter;

        private FencedCodeBlocks(boolean enabled, char separatorCharacter) {
            this.enabled = enabled;
            this.separatorCharacter = separatorCharacter;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public char getSeparatorCharacter() {
            return this.separatorCharacter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tables {
        REMOVE(true, false, false, false, false),
        LEAVE_AS_HTML(false, true, false, false, false),
        CONVERT_TO_CODE_BLOCK(false, false, true, true, true),
        MARKDOWN_EXTRA(false, false, true, false, false),
        MULTI_MARKDOWN(false, false, true, false, true);

        private final boolean removed;
        private final boolean leftAsHtml;
        private final boolean convertedToText;
        private final boolean renderedAsCode;
        private final boolean colspanEnabled;

        private Tables(boolean removed, boolean leftAsHtml, boolean convertedToText, boolean renderedAsCode, boolean colspanEnabled) {
            this.removed = removed;
            this.leftAsHtml = leftAsHtml;
            this.convertedToText = convertedToText;
            this.renderedAsCode = renderedAsCode;
            this.colspanEnabled = colspanEnabled;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public boolean isLeftAsHtml() {
            return this.leftAsHtml;
        }

        public boolean isConvertedToText() {
            return this.convertedToText;
        }

        public boolean isRenderedAsCode() {
            return this.renderedAsCode;
        }

        public boolean isColspanEnabled() {
            return this.colspanEnabled;
        }
    }
}

