/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark;

import com.overzealous.remark.IgnoredHtmlElement;
import com.overzealous.remark.Options;
import com.overzealous.remark.convert.DocumentConverter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

public class Remark {
    private final Cleaner cleaner;
    private final Options options;
    private final DocumentConverter converter;
    private final ReentrantLock converterLock = new ReentrantLock();
    private boolean cleanedHtmlEchoed = false;

    public Remark() {
        this(Options.markdown());
    }

    public Remark(Options options) {
        this.options = options.getCopy();
        Whitelist whitelist = Whitelist.basicWithImages().addTags(new String[]{"div", "h1", "h2", "h3", "h4", "h5", "h6", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "hr", "span", "font"}).addAttributes("th", new String[]{"colspan", "align", "style"}).addAttributes("td", new String[]{"colspan", "align", "style"}).addAttributes(":all", new String[]{"title", "style"});
        if (options.preserveRelativeLinks) {
            whitelist.preserveRelativeLinks(true);
        }
        if (options.abbreviations) {
            whitelist.addTags(new String[]{"abbr", "acronym"});
        }
        if (options.headerIds) {
            for (int i = 1; i <= 6; ++i) {
                whitelist.addAttributes("h" + i, new String[]{"id"});
            }
        }
        for (IgnoredHtmlElement el : options.getIgnoredHtmlElements()) {
            whitelist.addTags(new String[]{el.getTagName()});
            if (el.getAttributes().isEmpty()) continue;
            whitelist.addAttributes(el.getTagName(), el.getAttributes().toArray(new String[el.getAttributes().size()]));
        }
        this.cleaner = new Cleaner(whitelist);
        if (options.getTables().isLeftAsHtml()) {
            options.getIgnoredHtmlElements().add(IgnoredHtmlElement.create("table", new String[0]));
        }
        this.converter = new DocumentConverter(options);
    }

    public DocumentConverter getConverter() {
        return this.converter;
    }

    public boolean isCleanedHtmlEchoed() {
        return this.cleanedHtmlEchoed;
    }

    public void setCleanedHtmlEchoed(boolean cleanedHtmlEchoed) {
        this.cleanedHtmlEchoed = cleanedHtmlEchoed;
    }

    public synchronized Remark withWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Writer cannot be null.");
        }
        return new StreamRemark(this, writer);
    }

    public synchronized Remark withOutputStream(OutputStream os) {
        if (os == null) {
            throw new NullPointerException("OutputStream cannot be null.");
        }
        return new StreamRemark(this, os);
    }

    public String convert(URL url, int timeoutMillis) throws IOException {
        Document doc = Jsoup.parse((URL)url, (int)timeoutMillis);
        return this.convert(doc);
    }

    public String convert(File file) throws IOException {
        return this.convert(file, null);
    }

    public String convert(File file, String charset) throws IOException {
        return this.convert(file, charset, "");
    }

    public String convert(File file, String charset, String baseUri) throws IOException {
        Document doc = Jsoup.parse((File)file, (String)charset, (String)baseUri);
        return this.convert(doc);
    }

    public String convert(String html) {
        return this.convert(html, "");
    }

    public String convert(String html, String baseUri) {
        Document doc = Jsoup.parse((String)html, (String)baseUri);
        return this.convert(doc);
    }

    public String convertFragment(String body) {
        return this.convertFragment(body, "");
    }

    public String convertFragment(String body, String baseUri) {
        Document doc = Jsoup.parseBodyFragment((String)body, (String)baseUri);
        return this.convert(doc);
    }

    public String convert(Document doc) {
        return this.processConvert(doc, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processConvert(Document doc, Writer writer, OutputStream os) {
        doc = this.cleaner.clean(doc);
        if (this.cleanedHtmlEchoed) {
            System.out.println("Cleaned and processed HTML document:");
            System.out.println(doc.toString());
            System.out.println();
        }
        String result = null;
        this.converterLock.lock();
        try {
            if (writer != null) {
                this.converter.convert(doc, writer);
            } else if (os != null) {
                this.converter.convert(doc, os);
            } else {
                result = this.converter.convert(doc);
            }
        }
        finally {
            this.converterLock.unlock();
        }
        return result;
    }

    private final class StreamRemark
    extends Remark {
        private final Remark remark;
        private final Writer writer;
        private final OutputStream os;

        private StreamRemark(Remark remark2, Writer writer) {
            this.remark = remark2;
            this.writer = writer;
            this.os = null;
        }

        private StreamRemark(Remark remark2, OutputStream out) {
            this.remark = remark2;
            this.writer = null;
            this.os = out;
        }

        public Remark withWriter(Writer writer) {
            return this.remark.withWriter(writer);
        }

        public Remark withOutputStream(OutputStream os) {
            return this.remark.withOutputStream(os);
        }

        public String convert(Document doc) {
            return this.remark.processConvert(doc, this.writer, this.os);
        }
    }
}

