/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.util;

import com.overzealous.remark.util.MarkdownTableCell;
import com.overzealous.remark.util.StringUtils;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkdownTable {
    private final List<List<MarkdownTableCell>> header = new LinkedList<List<MarkdownTableCell>>();
    private final List<List<MarkdownTableCell>> body = new LinkedList<List<MarkdownTableCell>>();
    private int cols;
    private int[] widths;
    private Alignment[] alignments;
    private boolean firstNewline = true;

    public List<MarkdownTableCell> addHeaderRow() {
        LinkedList<MarkdownTableCell> newRow = new LinkedList<MarkdownTableCell>();
        this.header.add(newRow);
        return newRow;
    }

    public List<MarkdownTableCell> addBodyRow() {
        LinkedList<MarkdownTableCell> newRow = new LinkedList<MarkdownTableCell>();
        this.body.add(newRow);
        return newRow;
    }

    public void renderTable(PrintWriter output, boolean allowColspan, boolean renderAsCode) {
        this.cols = this.getNumberOfColumns();
        this.widths = new int[this.cols];
        this.alignments = new Alignment[this.cols];
        for (int i = 0; i < this.cols; ++i) {
            this.alignments[i] = Alignment.LEFT;
        }
        this.calculateColumnMetrics(this.header, allowColspan);
        this.calculateColumnMetrics(this.body, allowColspan);
        this.firstNewline = true;
        this.renderRows(output, this.header, allowColspan, renderAsCode);
        this.renderHeaderSeparator(output, renderAsCode);
        this.renderRows(output, this.body, allowColspan, renderAsCode);
    }

    private void calculateColumnMetrics(List<List<MarkdownTableCell>> rows, boolean allowColspan) {
        for (List<MarkdownTableCell> row : rows) {
            int col = 0;
            for (MarkdownTableCell cell : row) {
                if (cell.getAlignment() != Alignment.LEFT) {
                    this.alignments[col] = cell.getAlignment();
                }
                if (!allowColspan || cell.getColspan() == 1) {
                    this.widths[col] = Math.max(this.widths[col], cell.getWidth());
                } else {
                    int totalWidth = 0;
                    for (int i = col; i < col + cell.getColspan(); ++i) {
                        totalWidth += this.widths[i];
                    }
                    int cellWidth = cell.getWidth();
                    if (cellWidth > totalWidth) {
                        int diff = cellWidth - totalWidth;
                        int addToEveryColumn = diff / cell.getColspan();
                        int columnsWithMore = diff % cell.getColspan();
                        for (int i = 0; i < cell.getColspan(); ++i) {
                            int carryOver = 0;
                            if (i < columnsWithMore) {
                                carryOver = 1;
                            }
                            int n = i + col;
                            this.widths[n] = this.widths[n] + (addToEveryColumn + carryOver);
                        }
                    }
                }
                col += cell.getColspan();
            }
        }
    }

    private void renderRows(PrintWriter output, List<List<MarkdownTableCell>> rows, boolean allowColspan, boolean renderAsCode) {
        for (List<MarkdownTableCell> row : rows) {
            this.println(output);
            if (renderAsCode) {
                output.write("    ");
            }
            output.write(124);
            int col = 0;
            for (MarkdownTableCell cell : row) {
                Alignment alignment = this.alignments[col];
                if (!allowColspan || cell.getColspan() == 1) {
                    String contents = String.format(" %s ", cell.getContents());
                    StringUtils.align(output, contents, this.widths[col], alignment.getDir());
                    output.write(124);
                    if (cell.getColspan() > 1) {
                        for (int emptyCol = col + 1; emptyCol < col + cell.getColspan(); ++emptyCol) {
                            StringUtils.multiply(output, ' ', this.widths[emptyCol]);
                            output.write(124);
                        }
                    }
                } else {
                    int totalWidth = 0;
                    for (int i = col; i < col + cell.getColspan(); ++i) {
                        totalWidth += this.widths[i];
                    }
                    String contents = String.format(" %s ", cell.getContents());
                    StringUtils.align(output, contents, totalWidth, alignment.getDir());
                    StringUtils.multiply(output, '|', cell.getColspan());
                }
                col += cell.getColspan();
            }
        }
    }

    private void renderHeaderSeparator(PrintWriter output, boolean renderAsCode) {
        int i;
        this.println(output);
        boolean alignmentFound = false;
        for (i = 0; i < this.cols; ++i) {
            if (this.alignments[i] == Alignment.LEFT) continue;
            alignmentFound = true;
            break;
        }
        if (renderAsCode) {
            output.write("    ");
        }
        output.write(124);
        for (i = 0; i < this.cols; ++i) {
            int width = this.widths[i] - 2;
            if (alignmentFound) {
                Alignment alignment = this.alignments[i];
                output.write(alignment == Alignment.RIGHT ? 32 : 58);
                StringUtils.multiply(output, '-', width);
                output.write(alignment == Alignment.LEFT ? 32 : 58);
            } else {
                output.write(32);
                StringUtils.multiply(output, '-', width);
                output.write(32);
            }
            output.write(124);
        }
    }

    private void println(PrintWriter output) {
        if (this.firstNewline) {
            this.firstNewline = false;
        } else {
            output.println();
        }
    }

    public int getNumberOfColumns() {
        int columns = 0;
        for (List<MarkdownTableCell> row : this.header) {
            columns = Math.max(columns, this.getNumberOfColumnsInRow(row));
        }
        for (List<MarkdownTableCell> row : this.body) {
            columns = Math.max(columns, this.getNumberOfColumnsInRow(row));
        }
        return columns;
    }

    private int getNumberOfColumnsInRow(List<MarkdownTableCell> row) {
        int count = 0;
        for (MarkdownTableCell cell : row) {
            count += cell.getColspan();
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT(-1),
        CENTER(0),
        RIGHT(1);

        private final int dir;

        private Alignment(int dir) {
            this.dir = dir;
        }

        public int getDir() {
            return this.dir;
        }

        public static Alignment find(int alignment) {
            if (alignment == 0) {
                return CENTER;
            }
            if (alignment < 0) {
                return LEFT;
            }
            return RIGHT;
        }
    }
}

