/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class InlineStyle
extends AbstractNodeHandler {
    private static final char ITALICS_WRAPPER = '*';
    private static final String BOLD_WRAPPER = "**";
    private static final String STRIKETHROUGH_WRAPPER = "~~";
    private static final Pattern ITALICS_PATTERN = Pattern.compile("font-style:\\s*italic", 2);
    private static final Pattern BOLD_PATTERN = Pattern.compile("font-weight:\\s*bold", 2);
    private static final Pattern STRIKE_THROUGH_PATTERN = Pattern.compile("text-decoration:\\s*line-through", 2);
    private static final Pattern INWORD_CHARACTER = Pattern.compile("\\w");
    private static final Pattern SPACE_CONTENT_SPACE = Pattern.compile("^(\\s*+)(.*?)(\\s*)$", 32);
    private int italicDepth = 0;
    private int boldDepth = 0;
    private int strikeThroughDepth = 0;

    public void handleNode(NodeHandler parent, Element node, DocumentConverter converter) {
        if (this.checkInnerBlock(node)) {
            converter.walkNodes(parent, node);
        } else {
            Rules rules = this.checkInword(node, converter);
            if (rules.emphasisPreserved) {
                this.checkTag(node, rules);
                if (rules.bold || rules.italics || rules.strikeThrough) {
                    this.handleStyled(parent, node, converter, rules);
                } else {
                    converter.walkNodes(this, node, converter.inlineNodes);
                }
            } else {
                ++this.italicDepth;
                ++this.boldDepth;
                ++this.strikeThroughDepth;
                converter.walkNodes(this, node, converter.inlineNodes);
                --this.italicDepth;
                --this.boldDepth;
                --this.strikeThroughDepth;
            }
        }
    }

    public void handleTextNode(TextNode node, DocumentConverter converter) {
        if (node.previousSibling() != null && node.nextSibling() != null || node.text().trim().length() != 0) {
            super.handleTextNode(node, converter);
        }
    }

    private void handleStyled(NodeHandler parent, Element node, DocumentConverter converter, Rules rules) {
        Matcher parts;
        if (rules.bold) {
            ++this.boldDepth;
        }
        if (rules.italics) {
            ++this.italicDepth;
        }
        if (rules.strikeThrough) {
            ++this.strikeThroughDepth;
        }
        String content = converter.getInlineContent(this, node, true);
        if (rules.bold) {
            --this.boldDepth;
        }
        if (rules.italics) {
            --this.italicDepth;
        }
        if (rules.strikeThrough) {
            --this.strikeThroughDepth;
        }
        if (content.length() > 0 && (parts = SPACE_CONTENT_SPACE.matcher(content)).find()) {
            converter.output.write(parts.group(1));
            if (parts.group(2).length() > 0) {
                this.start(rules, parts.group(1), converter);
                converter.output.write(parts.group(2));
                this.end(rules, parts.group(3), converter);
            }
            converter.output.write(parts.group(3));
        }
    }

    private boolean checkInnerBlock(Element node) {
        Element child;
        boolean blockExists = false;
        Iterator iterator = node.children().iterator();
        while (iterator.hasNext() && !(blockExists = (child = (Element)iterator.next()).isBlock() || this.checkInnerBlock(child))) {
        }
        return blockExists;
    }

    private Rules checkInword(Element node, DocumentConverter converter) {
        Rules result = new Rules();
        Options.InWordEmphasis iwe = converter.options.getInWordEmphasis();
        if (!iwe.isEmphasisPreserved() || iwe.isAdditionalSpacingNeeded()) {
            TextNode tn;
            String text;
            Node n = node.previousSibling();
            if (n != null && n instanceof TextNode && INWORD_CHARACTER.matcher((text = (tn = (TextNode)n).text()).substring(text.length() - 1)).matches()) {
                result.emphasisPreserved = iwe.isEmphasisPreserved();
                result.addSpacing = iwe.isAdditionalSpacingNeeded();
            }
            if ((n = node.nextSibling()) != null && n instanceof TextNode && INWORD_CHARACTER.matcher((tn = (TextNode)n).text().substring(0, 1)).matches()) {
                result.emphasisPreserved = iwe.isEmphasisPreserved();
                result.addSpacing = iwe.isAdditionalSpacingNeeded();
            }
        }
        if (node.tagName().equals("del")) {
            result.addSpacing = true;
        }
        return result;
    }

    private void checkTag(Element node, Rules rules) {
        String tn = node.tagName();
        if (tn.equals("i") || tn.equals("em")) {
            rules.italics = this.italicDepth == 0;
        } else if (tn.equals("b") || tn.equals("strong")) {
            rules.bold = this.boldDepth == 0;
        } else if (tn.equals("s") || tn.equals("strike") || tn.equals("del")) {
            rules.strikeThrough = this.strikeThroughDepth == 0;
        } else if (node.hasAttr("style")) {
            String style = node.attr("style");
            if (ITALICS_PATTERN.matcher(style).find()) {
                boolean bl = rules.italics = this.italicDepth == 0;
            }
            if (BOLD_PATTERN.matcher(style).find()) {
                boolean bl = rules.bold = this.boldDepth == 0;
            }
            if (STRIKE_THROUGH_PATTERN.matcher(style).find()) {
                rules.strikeThrough = this.strikeThroughDepth == 0;
            }
        }
    }

    private void start(Rules style, String leadingSpaces, DocumentConverter converter) {
        if (!(!style.addSpacing || this.italicDepth != 0 && this.boldDepth != 0 && this.strikeThroughDepth != 0 || leadingSpaces != null && leadingSpaces.length() != 0)) {
            converter.output.write(32);
        }
        if (style.italics && this.italicDepth == 0) {
            converter.output.write(42);
        }
        if (style.bold && this.boldDepth == 0) {
            converter.output.write(BOLD_WRAPPER);
        }
        if (style.strikeThrough && this.strikeThroughDepth == 0) {
            converter.output.write(STRIKETHROUGH_WRAPPER);
        }
    }

    private void end(Rules style, String trailingSpaces, DocumentConverter converter) {
        if (style.bold && this.boldDepth == 0) {
            converter.output.write(BOLD_WRAPPER);
        }
        if (style.italics && this.italicDepth == 0) {
            converter.output.write(42);
        }
        if (style.strikeThrough && this.strikeThroughDepth == 0) {
            converter.output.write(STRIKETHROUGH_WRAPPER);
        }
        if (!(!style.addSpacing || this.italicDepth != 0 && this.boldDepth != 0 && this.strikeThroughDepth != 0 || trailingSpaces != null && trailingSpaces.length() != 0)) {
            converter.output.write(32);
        }
    }

    private class Rules {
        boolean emphasisPreserved = true;
        boolean addSpacing = false;
        boolean italics = false;
        boolean bold = false;
        boolean strikeThrough = false;

        private Rules() {
        }
    }
}

