package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@JsonDeserialize(builder = Task.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class Task {
    private final OffsetDateTime startTime;

    private final OffsetDateTime endTime;

    private final Optional<String> failure;

    private int memoizedHashCode;

    private Task(OffsetDateTime startTime, OffsetDateTime endTime, Optional<String> failure) {
        validateFields(startTime, endTime, failure);
        this.startTime = startTime;
        this.endTime = endTime;
        this.failure = failure;
    }

    @JsonProperty("startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty("endTime")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty("failure")
    public Optional<String> getFailure() {
        return this.failure;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof Task && equalTo((Task) other));
    }

    private boolean equalTo(Task other) {
        return this.startTime.isEqual(other.startTime)
                && this.endTime.isEqual(other.endTime)
                && this.failure.equals(other.failure);
    }

    @Override
    public int hashCode() {
        int result = memoizedHashCode;
        if (result == 0) {
            result = Objects.hash(this.startTime.toInstant(), this.endTime.toInstant(), this.failure);
            memoizedHashCode = result;
        }
        return result;
    }

    @Override
    public String toString() {
        return "Task{startTime: " + startTime + ", endTime: " + endTime + ", failure: " + failure + '}';
    }

    public static Task of(OffsetDateTime startTime, OffsetDateTime endTime, String failure) {
        return builder()
                .startTime(startTime)
                .endTime(endTime)
                .failure(Optional.of(failure))
                .build();
    }

    private static void validateFields(OffsetDateTime startTime, OffsetDateTime endTime, Optional<String> failure) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, startTime, "startTime");
        missingFields = addFieldIfMissing(missingFields, endTime, "endTime");
        missingFields = addFieldIfMissing(missingFields, failure, "failure");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private OffsetDateTime startTime;

        private OffsetDateTime endTime;

        private Optional<String> failure = Optional.empty();

        private Builder() {}

        public Builder from(Task other) {
            startTime(other.getStartTime());
            endTime(other.getEndTime());
            failure(other.getFailure());
            return this;
        }

        @JsonSetter("startTime")
        public Builder startTime(@Nonnull OffsetDateTime startTime) {
            this.startTime = Preconditions.checkNotNull(startTime, "startTime cannot be null");
            return this;
        }

        @JsonSetter("endTime")
        public Builder endTime(@Nonnull OffsetDateTime endTime) {
            this.endTime = Preconditions.checkNotNull(endTime, "endTime cannot be null");
            return this;
        }

        @JsonSetter(value = "failure", nulls = Nulls.SKIP)
        public Builder failure(@Nonnull Optional<String> failure) {
            this.failure = Preconditions.checkNotNull(failure, "failure cannot be null");
            return this;
        }

        public Builder failure(@Nonnull String failure) {
            this.failure = Optional.of(Preconditions.checkNotNull(failure, "failure cannot be null"));
            return this;
        }

        public Task build() {
            return new Task(startTime, endTime, failure);
        }
    }
}
