package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@JsonDeserialize(builder = GitInfo.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class GitInfo {
    private final Optional<String> branch;

    private final Optional<String> commit;

    private final Optional<Boolean> dirty;

    private final Optional<String> originPath;

    private int memoizedHashCode;

    private GitInfo(
            Optional<String> branch, Optional<String> commit, Optional<Boolean> dirty, Optional<String> originPath) {
        validateFields(branch, commit, dirty, originPath);
        this.branch = branch;
        this.commit = commit;
        this.dirty = dirty;
        this.originPath = originPath;
    }

    @JsonProperty("branch")
    public Optional<String> getBranch() {
        return this.branch;
    }

    @JsonProperty("commit")
    public Optional<String> getCommit() {
        return this.commit;
    }

    @JsonProperty("dirty")
    public Optional<Boolean> getDirty() {
        return this.dirty;
    }

    @JsonProperty("originPath")
    public Optional<String> getOriginPath() {
        return this.originPath;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof GitInfo && equalTo((GitInfo) other));
    }

    private boolean equalTo(GitInfo other) {
        return this.branch.equals(other.branch)
                && this.commit.equals(other.commit)
                && this.dirty.equals(other.dirty)
                && this.originPath.equals(other.originPath);
    }

    @Override
    public int hashCode() {
        int result = memoizedHashCode;
        if (result == 0) {
            result = Objects.hash(this.branch, this.commit, this.dirty, this.originPath);
            memoizedHashCode = result;
        }
        return result;
    }

    @Override
    public String toString() {
        return "GitInfo{branch: " + branch + ", commit: " + commit + ", dirty: " + dirty + ", originPath: " + originPath
                + '}';
    }

    private static void validateFields(
            Optional<String> branch, Optional<String> commit, Optional<Boolean> dirty, Optional<String> originPath) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, branch, "branch");
        missingFields = addFieldIfMissing(missingFields, commit, "commit");
        missingFields = addFieldIfMissing(missingFields, dirty, "dirty");
        missingFields = addFieldIfMissing(missingFields, originPath, "originPath");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(4);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> branch = Optional.empty();

        private Optional<String> commit = Optional.empty();

        private Optional<Boolean> dirty = Optional.empty();

        private Optional<String> originPath = Optional.empty();

        private Builder() {}

        public Builder from(GitInfo other) {
            branch(other.getBranch());
            commit(other.getCommit());
            dirty(other.getDirty());
            originPath(other.getOriginPath());
            return this;
        }

        @JsonSetter(value = "branch", nulls = Nulls.SKIP)
        public Builder branch(@Nonnull Optional<String> branch) {
            this.branch = Preconditions.checkNotNull(branch, "branch cannot be null");
            return this;
        }

        public Builder branch(@Nonnull String branch) {
            this.branch = Optional.of(Preconditions.checkNotNull(branch, "branch cannot be null"));
            return this;
        }

        @JsonSetter(value = "commit", nulls = Nulls.SKIP)
        public Builder commit(@Nonnull Optional<String> commit) {
            this.commit = Preconditions.checkNotNull(commit, "commit cannot be null");
            return this;
        }

        public Builder commit(@Nonnull String commit) {
            this.commit = Optional.of(Preconditions.checkNotNull(commit, "commit cannot be null"));
            return this;
        }

        @JsonSetter(value = "dirty", nulls = Nulls.SKIP)
        public Builder dirty(@Nonnull Optional<Boolean> dirty) {
            this.dirty = Preconditions.checkNotNull(dirty, "dirty cannot be null");
            return this;
        }

        public Builder dirty(boolean dirty) {
            this.dirty = Optional.of(dirty);
            return this;
        }

        @JsonSetter(value = "originPath", nulls = Nulls.SKIP)
        public Builder originPath(@Nonnull Optional<String> originPath) {
            this.originPath = Preconditions.checkNotNull(originPath, "originPath cannot be null");
            return this;
        }

        public Builder originPath(@Nonnull String originPath) {
            this.originPath = Optional.of(Preconditions.checkNotNull(originPath, "originPath cannot be null"));
            return this;
        }

        public GitInfo build() {
            return new GitInfo(branch, commit, dirty, originPath);
        }
    }
}
