/*
 * Decompiled with CFR 0.152.
 */
package slf4jtest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LogLevel {
    public static final LogLevel ErrorLevel = new LogLevel(){

        public String toString() {
            return "ERROR";
        }
    };
    public static final LogLevel WarnLevel = new LogLevel(){

        public String toString() {
            return "WARN";
        }
    };
    public static final LogLevel InfoLevel = new LogLevel(){

        public String toString() {
            return "INFO";
        }
    };
    public static final LogLevel DebugLevel = new LogLevel(){

        public String toString() {
            return "DEBUG";
        }
    };
    public static final LogLevel TraceLevel = new LogLevel(){

        public String toString() {
            return "TRACE";
        }
    };
    public static final List<LogLevel> All = Collections.unmodifiableList(new ArrayList<LogLevel>(){
        {
            this.add(ErrorLevel);
            this.add(WarnLevel);
            this.add(InfoLevel);
            this.add(DebugLevel);
            this.add(TraceLevel);
        }
    });

    private LogLevel() {
    }

    public static final LogLevel from(String name) {
        if (name.equals("error")) {
            return ErrorLevel;
        }
        if (name.equals("warn")) {
            return WarnLevel;
        }
        if (name.equals("info")) {
            return InfoLevel;
        }
        if (name.equals("debug")) {
            return DebugLevel;
        }
        if (name.equals("trace")) {
            return TraceLevel;
        }
        throw new IllegalArgumentException("invalid slf4jtest.LogLevel " + name);
    }
}

