/*
 * Decompiled with CFR 0.152.
 */
package slf4jtest;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import slf4jtest.LogLevel;
import slf4jtest.LogMessage;
import slf4jtest.LoggerExtensions;
import slf4jtest.Predicate;
import slf4jtest.Settings;

class LoggerExtensionsImpl
implements LoggerExtensions {
    private final Settings settings;
    private final long startTime;
    private final Queue<LogMessage> rows = new ConcurrentLinkedQueue<LogMessage>();

    LoggerExtensionsImpl(Settings settings, long startTime) {
        this.settings = settings;
        this.startTime = startTime;
    }

    void record(LogMessage message) {
        this.doLogging(message);
        this.doConsole(message);
    }

    private void doLogging(LogMessage message) {
        if (this.settings.isEnabled(message.level)) {
            this.rows.add(message);
        }
    }

    private void doConsole(LogMessage message) {
        boolean messageIsntSuppressed;
        boolean levelIsEnabled = this.settings.isEnabled(message.level);
        boolean bl = messageIsntSuppressed = !this.isPrintSuppressed(message);
        if (levelIsEnabled && this.settings.printingEnabled && messageIsntSuppressed) {
            PrintStream out = this.settings.printStreams.get(message.level);
            out.println(this.layout(message));
            out.flush();
        }
    }

    private String layout(LogMessage message) {
        long delta = message.timeStamp - this.startTime;
        return delta + " " + message.level + " [" + message.threadName + "] " + message.logName + " - " + message.text;
    }

    private boolean isPrintSuppressed(LogMessage msg) {
        for (Predicate<LogMessage> predicate : this.settings.printSuppressions) {
            if (!predicate.matches(msg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<LogMessage> lines() {
        return Collections.unmodifiableCollection(this.rows);
    }

    @Override
    public boolean contains(final String substring) {
        return this.matches(new Predicate<LogMessage>(){

            @Override
            public boolean matches(LogMessage lm) {
                return lm.text.contains(substring);
            }
        });
    }

    @Override
    public boolean contains(final LogLevel level, final String substring) {
        return this.matches(new Predicate<LogMessage>(){

            @Override
            public boolean matches(LogMessage lm) {
                return lm.text.contains(substring) && lm.level == level;
            }
        });
    }

    @Override
    public boolean matches(String regex) {
        Pattern pat = Pattern.compile(regex, 32);
        return this.matches(pat);
    }

    @Override
    public boolean matches(final Pattern regex) {
        return this.matches(new Predicate<LogMessage>(){

            @Override
            public boolean matches(LogMessage lm) {
                return regex.matcher(lm.text).matches();
            }
        });
    }

    @Override
    public boolean matches(LogLevel level, String regex) {
        Pattern pat = Pattern.compile(regex, 32);
        return this.matches(level, pat);
    }

    @Override
    public boolean matches(final LogLevel level, final Pattern regex) {
        return this.matches(new Predicate<LogMessage>(){

            @Override
            public boolean matches(LogMessage row) {
                return row.level == level && regex.matcher(row.text).matches();
            }
        });
    }

    @Override
    public boolean matches(Predicate<LogMessage> predicate) {
        for (LogMessage row : this.rows) {
            if (!predicate.matches(row)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean assertMatches(Predicate<LogMessage> predicate) throws Error {
        boolean matched = this.matches(predicate);
        if (!matched) {
            throw new AssertionError((Object)("did not match " + predicate.toString()));
        }
        return true;
    }

    @Override
    public void clear() {
        this.rows.clear();
    }
}

