/*
 * Decompiled with CFR 0.152.
 */
package slf4jtest;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import slf4jtest.LogLevel;
import slf4jtest.LogMessage;
import slf4jtest.Predicate;
import slf4jtest.TestLoggerFactory;

public class Settings {
    final boolean printingEnabled;
    final Map<LogLevel, PrintStream> printStreams;
    final List<Predicate<LogMessage>> printSuppressions;
    final Set<LogLevel> enabledLevels;
    final Map<String, Logger> delegates;

    private Settings(boolean print, Map<LogLevel, PrintStream> printStreams, List<Predicate<LogMessage>> suppressionPatterns, Set<LogLevel> enabledLevels, Map<String, Logger> delegates) {
        this.printingEnabled = print;
        this.printStreams = Settings.readonlyMap(printStreams);
        this.printSuppressions = Settings.readonlyList(suppressionPatterns);
        this.enabledLevels = Settings.readonlySet(enabledLevels);
        this.delegates = Settings.readonlyMap(delegates);
    }

    public Settings() {
        this.printingEnabled = true;
        this.printStreams = Settings.readonlyMap(new HashMap<LogLevel, PrintStream>(){
            {
                for (LogLevel l : LogLevel.All) {
                    this.put(l, System.out);
                }
                this.put(LogLevel.ErrorLevel, System.err);
            }
        });
        this.printSuppressions = Settings.readonlyList();
        this.enabledLevels = Settings.readonlySet(new HashSet<LogLevel>(){
            {
                this.add(LogLevel.ErrorLevel);
            }
        });
        this.delegates = Settings.readonlyMap();
    }

    public static Settings instance() {
        return new Settings();
    }

    public TestLoggerFactory buildLogging() {
        return new TestLoggerFactory(this);
    }

    public Settings printingEnabled(boolean print) {
        return new Settings(print, this.printStreams, this.printSuppressions, this.enabledLevels, this.delegates);
    }

    public Settings suppressPrinting(String regex) {
        final Pattern pat = Pattern.compile(regex, 32);
        Predicate<LogMessage> pred = new Predicate<LogMessage>(){

            @Override
            public boolean matches(LogMessage row) {
                return pat.matcher(row.text).matches();
            }
        };
        return this.suppressPrinting(pred);
    }

    public Settings suppressPrinting(final Pattern compile) {
        Predicate<LogMessage> pred = new Predicate<LogMessage>(){

            @Override
            public boolean matches(LogMessage row) {
                return compile.matcher(row.toString()).matches();
            }
        };
        return this.suppressPrinting(pred);
    }

    public Settings suppressPrinting(Predicate<LogMessage> pred) {
        ArrayList<Predicate<LogMessage>> newSuppressions = new ArrayList<Predicate<LogMessage>>(this.printSuppressions);
        newSuppressions.add(pred);
        return new Settings(this.printingEnabled, this.printStreams, newSuppressions, this.enabledLevels, this.delegates);
    }

    public Settings enableAll() {
        return this.enable(LogLevel.All.toArray(new LogLevel[0]));
    }

    public Settings disableAll() {
        return this.disable(LogLevel.All.toArray(new LogLevel[0]));
    }

    public Settings enable(LogLevel ... levels) {
        HashSet<LogLevel> newLevels = new HashSet<LogLevel>(this.enabledLevels);
        newLevels.addAll(Arrays.asList(levels));
        return new Settings(this.printingEnabled, this.printStreams, this.printSuppressions, newLevels, this.delegates);
    }

    public Settings disable(LogLevel ... levels) {
        HashSet<LogLevel> newLevels = new HashSet<LogLevel>(this.enabledLevels);
        newLevels.removeAll(Arrays.asList(levels));
        return new Settings(this.printingEnabled, this.printStreams, this.printSuppressions, newLevels, this.delegates);
    }

    public Settings redirectPrintStream(LogLevel level, PrintStream ps) {
        HashMap<LogLevel, PrintStream> newPrintStreams = new HashMap<LogLevel, PrintStream>(this.printStreams);
        newPrintStreams.put(level, ps);
        return new Settings(this.printingEnabled, newPrintStreams, this.printSuppressions, this.enabledLevels, this.delegates);
    }

    public Settings delegate(Class<?> loggerName, Logger logger) {
        return this.delegate(loggerName.getName(), logger);
    }

    public Settings delegate(String loggerName, Logger logger) {
        HashMap<String, Logger> newDelegates = new HashMap<String, Logger>(this.delegates);
        newDelegates.put(loggerName, logger);
        return new Settings(this.printingEnabled, this.printStreams, this.printSuppressions, this.enabledLevels, newDelegates);
    }

    public boolean isEnabled(LogLevel level) {
        return this.enabledLevels.contains(level);
    }

    private static <a, b> Map<a, b> readonlyMap() {
        return Collections.unmodifiableMap(new HashMap());
    }

    private static <a, b> Map<a, b> readonlyMap(Map<a, b> map) {
        return Collections.unmodifiableMap(map);
    }

    private static <a> List<a> readonlyList() {
        return Collections.unmodifiableList(new ArrayList());
    }

    private static <a> List<a> readonlyList(List<a> list) {
        return Collections.unmodifiableList(list);
    }

    private static <a> Set<a> readonlySet(Set<a> set) {
        return Collections.unmodifiableSet(set);
    }
}

