/*
 * Decompiled with CFR 0.152.
 */
package slf4jtest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import slf4jtest.LogLevel;
import slf4jtest.LogMessage;
import slf4jtest.LoggerExtensions;
import slf4jtest.LoggerExtensionsImpl;
import slf4jtest.LoggerFactoryExtensions;
import slf4jtest.Predicate;
import slf4jtest.Settings;
import slf4jtest.TestLogger;

public class TestLoggerFactory
implements LoggerFactoryExtensions,
LoggerExtensions {
    private final long startTime = System.currentTimeMillis();
    private final Settings settings;
    private final ConcurrentMap<String, TestLogger> loggers = new ConcurrentHashMap<String, TestLogger>();
    private static final Map<String, LogLevel> logFnNameToLogLevel = new HashMap<String, LogLevel>(){
        {
            this.put("error", LogLevel.ErrorLevel);
            this.put("warn", LogLevel.WarnLevel);
            this.put("info", LogLevel.InfoLevel);
            this.put("debug", LogLevel.DebugLevel);
            this.put("trace", LogLevel.TraceLevel);
        }
    };
    private static final Map<String, LogLevel> isEnabledFnNameToLogLevel = new HashMap<String, LogLevel>(){
        {
            this.put("isErrorEnabled", LogLevel.ErrorLevel);
            this.put("isWarnEnabled", LogLevel.WarnLevel);
            this.put("isInfoEnabled", LogLevel.InfoLevel);
            this.put("isDebugEnabled", LogLevel.DebugLevel);
            this.put("isTraceEnabled", LogLevel.TraceLevel);
        }
    };

    public TestLoggerFactory(Settings settings) {
        this.settings = settings;
    }

    public TestLoggerFactory() {
        this.settings = new Settings();
    }

    @Override
    public boolean contains(LogLevel level, String substring) {
        for (TestLogger l : this.loggers.values()) {
            if (!l.contains(level, substring)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String substring) {
        for (TestLogger l : this.loggers.values()) {
            if (!l.matches(substring)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(LogLevel level, String regex) {
        for (TestLogger l : this.loggers.values()) {
            if (!l.matches(level, regex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<LogMessage> lines() {
        ArrayList<LogMessage> lm = new ArrayList<LogMessage>();
        for (TestLogger l : this.loggers.values()) {
            lm.addAll(l.lines());
        }
        return Collections.unmodifiableCollection(lm);
    }

    @Override
    public boolean matches(String regex) {
        for (TestLogger l : this.loggers.values()) {
            if (!l.matches(regex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(LogLevel level, Pattern regex) {
        for (TestLogger l : this.loggers.values()) {
            if (!l.matches(level, regex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean assertMatches(Predicate<LogMessage> predicate) throws Error {
        boolean matched = this.matches(predicate);
        if (!matched) {
            throw new AssertionError((Object)("did not match " + predicate.toString()));
        }
        return true;
    }

    @Override
    public boolean matches(Pattern regex) {
        for (TestLogger l : this.loggers.values()) {
            if (!l.matches(regex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Predicate<LogMessage> predicate) {
        for (TestLogger l : this.loggers.values()) {
            if (!l.matches(predicate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (TestLogger l : this.loggers.values()) {
            l.clear();
        }
    }

    public TestLogger getLogger(String name) {
        TestLogger cached = (TestLogger)this.loggers.get(name);
        if (cached != null) {
            return cached;
        }
        TestLogger newLogger = this.createMock(this.settings, name);
        TestLogger oldLogger = this.loggers.putIfAbsent(name, newLogger);
        if (oldLogger != null) {
            return oldLogger;
        }
        return newLogger;
    }

    @Override
    public TestLogger getLogger(Class<?> name) {
        return this.getLogger(name.getName());
    }

    @Override
    public boolean loggerExists(String name) {
        return this.loggers.containsKey(name);
    }

    @Override
    public boolean loggerExists(Class<?> name) {
        return this.loggers.containsKey(name.getName());
    }

    private TestLogger createMock(final Settings settings, final String logName) {
        InvocationHandler handler = new InvocationHandler(){
            LoggerExtensionsImpl extension;
            {
                this.extension = new LoggerExtensionsImpl(settings, TestLoggerFactory.this.startTime);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                Class<?> declaringClass = method.getDeclaringClass();
                if (declaringClass == LoggerExtensions.class) {
                    try {
                        return method.invoke((Object)this.extension, args);
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getCause();
                    }
                }
                try {
                    if ("getName".equals(name)) {
                        String ite = logName;
                        return ite;
                    }
                    if (isEnabledFnNameToLogLevel.containsKey(name)) {
                        LogLevel l = (LogLevel)isEnabledFnNameToLogLevel.get(name);
                        Boolean bl = settings.enabledLevels.contains(l);
                        return bl;
                    }
                    if (logFnNameToLogLevel.containsKey(name)) {
                        LogLevel l = (LogLevel)logFnNameToLogLevel.get(name);
                        String s = TestLoggerFactory.this.formatLogMessage(method, args);
                        LogMessage message = new LogMessage(logName, l, s);
                        this.extension.record(message);
                    }
                    Object var6_9 = null;
                    return var6_9;
                }
                finally {
                    this.callDelegate(method, args);
                }
            }

            private void callDelegate(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
                Logger delegate = settings.delegates.get(logName);
                if (delegate != null) {
                    method.invoke((Object)delegate, args);
                }
            }
        };
        return (TestLogger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{TestLogger.class}, handler);
    }

    private String formatLogMessage(Method method, Object[] args) {
        Class<?>[] paramTypes = method.getParameterTypes();
        StringBuilder s = new StringBuilder();
        int p = 0;
        if (paramTypes[0] == Marker.class) {
            ++p;
        }
        if (paramTypes.length - p == 1) {
            s.append(args[p].toString());
        } else {
            FormattingTuple ft;
            String format = args[p].toString();
            if (paramTypes[p + 1] == Object[].class) {
                ft = MessageFormatter.arrayFormat((String)format, (Object[])((Object[])args[p + 1]));
            } else {
                Object[] arr = new Object[args.length - 1 - p];
                for (int i = 0; i < args.length - p - 1; ++i) {
                    arr[i] = args[i + 1 + p];
                }
                ft = MessageFormatter.arrayFormat((String)format, (Object[])arr);
            }
            s.append(ft.getMessage());
            if (null != ft.getThrowable()) {
                StringWriter sw = new StringWriter();
                ft.getThrowable().printStackTrace(new PrintWriter(sw));
                s.append("\n");
                s.append(sw.toString());
            }
        }
        return s.toString();
    }
}

