/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.util.List;
import java.util.Set;

public class JavadocPackageCheck
extends AbstractFileSetCheck {
    public static final String MSG_LEGACY_PACKAGE_HTML = "javadoc.legacyPackageHtml";
    public static final String MSG_PACKAGE_INFO = "javadoc.packageInfo";
    private boolean allowLegacy;
    private final Set<File> directoriesChecked = Sets.newHashSet();

    public JavadocPackageCheck() {
        this.setFileExtensions("java");
    }

    @Override
    public void beginProcessing(String charset) {
        super.beginProcessing(charset);
        this.directoriesChecked.clear();
    }

    @Override
    protected void processFiltered(File file, List<String> lines) {
        File dir = file.getParentFile();
        if (this.directoriesChecked.contains(dir)) {
            return;
        }
        this.directoriesChecked.add(dir);
        File packageInfo = new File(dir, "package-info.java");
        File packageHtml = new File(dir, "package.html");
        if (packageInfo.exists()) {
            if (packageHtml.exists()) {
                this.log(0, MSG_LEGACY_PACKAGE_HTML, new Object[0]);
            }
        } else if (!this.allowLegacy || !packageHtml.exists()) {
            this.log(0, MSG_PACKAGE_INFO, new Object[0]);
        }
    }

    public void setAllowLegacy(boolean allowLegacy) {
        this.allowLegacy = allowLegacy;
    }
}

