/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableMap;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class TrailingCommentCheck
extends AbstractCheck {
    public static final String MSG_KEY = "trailing.comments";
    private Pattern legalComment;
    private Pattern format = Pattern.compile("^[\\s\\});]*$");

    public void setLegalComment(Pattern legalComment) {
        this.legalComment = legalComment;
    }

    public final void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        throw new IllegalStateException("visitToken() shouldn't be called.");
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        ImmutableMap<Integer, TextBlock> cppComments = this.getFileContents().getSingleLineComments();
        ImmutableMap<Integer, List<TextBlock>> cComments = this.getFileContents().getBlockComments();
        HashSet lines = new HashSet();
        lines.addAll(cppComments.keySet());
        lines.addAll(cComments.keySet());
        for (Integer lineNo : lines) {
            String lineBefore;
            TextBlock comment;
            String line = this.getLines()[lineNo - 1];
            if (cppComments.containsKey(lineNo)) {
                comment = (TextBlock)cppComments.get(lineNo);
                lineBefore = line.substring(0, comment.getStartColNo());
            } else {
                List commentList = (List)cComments.get(lineNo);
                comment = (TextBlock)commentList.get(commentList.size() - 1);
                lineBefore = line.substring(0, comment.getStartColNo());
                if (comment.getText().length == 1 && !line.substring(comment.getEndColNo() + 1).trim().isEmpty()) continue;
            }
            if (this.format.matcher(lineBefore).find() || this.isLegalComment(comment)) continue;
            this.log((int)lineNo, MSG_KEY, new Object[0]);
        }
    }

    private boolean isLegalComment(TextBlock comment) {
        boolean legal;
        if (this.legalComment == null || comment.getStartLineNo() != comment.getEndLineNo()) {
            legal = false;
        } else {
            String commentText = comment.getText()[0];
            if ((commentText = commentText.substring(2)).endsWith("*/")) {
                commentText = commentText.substring(0, commentText.length() - 2);
            }
            commentText = commentText.trim();
            legal = this.legalComment.matcher(commentText).find();
        }
        return legal;
    }
}

